/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.threadpool.ThreadPool;

public class RoutingService
extends AbstractLifecycleComponent<RoutingService>
implements ClusterStateListener {
    private static final String CLUSTER_UPDATE_TASK_SOURCE = "cluster_reroute";
    final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private AtomicBoolean rerouting = new AtomicBoolean();
    private volatile long registeredNextDelaySetting = Long.MAX_VALUE;
    private volatile ScheduledFuture registeredNextDelayFuture;
    private volatile long unassignedShardsAllocatedTimestamp = 0L;

    @Inject
    public RoutingService(Settings settings, ThreadPool threadPool, ClusterService clusterService, AllocationService allocationService) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        if (clusterService != null) {
            clusterService.addFirst(this);
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        FutureUtils.cancel(this.registeredNextDelayFuture);
        this.clusterService.remove(this);
    }

    public AllocationService getAllocationService() {
        return this.allocationService;
    }

    public void setUnassignedShardsAllocatedTimestamp(long timeInMillis) {
        this.unassignedShardsAllocatedTimestamp = timeInMillis;
    }

    public final void reroute(String reason) {
        this.performReroute(reason);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().nodes().localNodeMaster()) {
            long nextDelaySetting = UnassignedInfo.findSmallestDelayedAllocationSetting(this.settings, event.state());
            if (nextDelaySetting > 0L && nextDelaySetting < this.registeredNextDelaySetting) {
                FutureUtils.cancel(this.registeredNextDelayFuture);
                this.registeredNextDelaySetting = nextDelaySetting;
                long nextDelayBasedOnUnassignedShardsAllocatedTimestamp = UnassignedInfo.findNextDelayedAllocationIn(this.unassignedShardsAllocatedTimestamp, this.settings, event.state());
                long nextDelayMillis = nextDelayBasedOnUnassignedShardsAllocatedTimestamp - (System.currentTimeMillis() - this.unassignedShardsAllocatedTimestamp);
                if (nextDelayMillis < 0L) {
                    nextDelayMillis = 0L;
                }
                TimeValue nextDelay = TimeValue.timeValueMillis(nextDelayMillis);
                int unassignedDelayedShards = UnassignedInfo.getNumberOfDelayedUnassigned(this.unassignedShardsAllocatedTimestamp, this.settings, event.state());
                if (unassignedDelayedShards > 0) {
                    this.logger.info("delaying allocation for [{}] unassigned shards, next check in [{}]", unassignedDelayedShards, nextDelay);
                    this.registeredNextDelayFuture = this.threadPool.schedule(nextDelay, "same", new AbstractRunnable(){

                        @Override
                        protected void doRun() throws Exception {
                            RoutingService.this.registeredNextDelaySetting = Long.MAX_VALUE;
                            RoutingService.this.reroute("assign delayed unassigned shards");
                        }

                        @Override
                        public void onFailure(Throwable t) {
                            RoutingService.this.logger.warn("failed to schedule/execute reroute post unassigned shard", t, new Object[0]);
                            RoutingService.this.registeredNextDelaySetting = Long.MAX_VALUE;
                        }
                    });
                }
            } else {
                this.logger.trace("no need to schedule reroute due to delayed unassigned, next_delay_setting [{}], registered [{}]", nextDelaySetting, this.registeredNextDelaySetting);
            }
        }
    }

    long getRegisteredNextDelaySetting() {
        return this.registeredNextDelaySetting;
    }

    protected void performReroute(String reason) {
        try {
            if (this.lifecycle.stopped()) {
                return;
            }
            if (!this.rerouting.compareAndSet(false, true)) {
                this.logger.trace("already has pending reroute, ignoring {}", reason);
                return;
            }
            this.logger.trace("rerouting {}", reason);
            this.clusterService.submitStateUpdateTask("cluster_reroute(" + reason + ")", Priority.HIGH, new ClusterStateUpdateTask(){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    RoutingService.this.rerouting.set(false);
                    RoutingAllocation.Result routingResult = RoutingService.this.allocationService.reroute(currentState);
                    if (!routingResult.changed()) {
                        return currentState;
                    }
                    return ClusterState.builder(currentState).routingResult(routingResult).build();
                }

                @Override
                public void onNoLongerMaster(String source) {
                    RoutingService.this.rerouting.set(false);
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    RoutingService.this.rerouting.set(false);
                    ClusterState state = RoutingService.this.clusterService.state();
                    if (RoutingService.this.logger.isTraceEnabled()) {
                        RoutingService.this.logger.error("unexpected failure during [{}], current state:\n{}", t, source, state.prettyPrint());
                    } else {
                        RoutingService.this.logger.error("unexpected failure during [{}], current state version [{}]", t, source, state.version());
                    }
                }
            });
        }
        catch (Throwable e) {
            this.rerouting.set(false);
            ClusterState state = this.clusterService.state();
            this.logger.warn("failed to reroute routing table, current state:\n{}", e, state.prettyPrint());
        }
    }
}

