/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketscript;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.bucketscript.BucketScriptPipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormat;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.internal.SearchContext;

public class BucketScriptParser
implements PipelineAggregator.Parser {
    public static final ParseField FORMAT = new ParseField("format", new String[0]);
    public static final ParseField GAP_POLICY = new ParseField("gap_policy", new String[0]);
    public static final ParseField PARAMS_FIELD = new ParseField("params", new String[0]);

    @Override
    public String type() {
        return BucketScriptPipelineAggregator.TYPE.name();
    }

    @Override
    public PipelineAggregatorFactory parse(String reducerName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        Script script = null;
        String currentFieldName = null;
        HashMap<String, String> bucketsPathsMap = null;
        String format = null;
        BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.SKIP;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (context.parseFieldMatcher().match(currentFieldName, FORMAT)) {
                    format = parser.text();
                    continue;
                }
                if (context.parseFieldMatcher().match(currentFieldName, BUCKETS_PATH)) {
                    bucketsPathsMap = new HashMap<String, String>();
                    bucketsPathsMap.put("_value", parser.text());
                    continue;
                }
                if (context.parseFieldMatcher().match(currentFieldName, GAP_POLICY)) {
                    gapPolicy = BucketHelpers.GapPolicy.parse(context, parser.text(), parser.getTokenLocation());
                    continue;
                }
                if (context.parseFieldMatcher().match(currentFieldName, Script.ScriptField.SCRIPT)) {
                    script = Script.parse(parser, context.parseFieldMatcher());
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + reducerName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (context.parseFieldMatcher().match(currentFieldName, BUCKETS_PATH)) {
                    ArrayList<String> paths = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String path = parser.text();
                        paths.add(path);
                    }
                    bucketsPathsMap = new HashMap();
                    for (int i = 0; i < paths.size(); ++i) {
                        bucketsPathsMap.put("_value" + i, (String)paths.get(i));
                    }
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + reducerName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (context.parseFieldMatcher().match(currentFieldName, Script.ScriptField.SCRIPT)) {
                    script = Script.parse(parser, context.parseFieldMatcher());
                    continue;
                }
                if (context.parseFieldMatcher().match(currentFieldName, BUCKETS_PATH)) {
                    Map<String, Object> map = parser.map();
                    bucketsPathsMap = new HashMap();
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        bucketsPathsMap.put(entry.getKey(), String.valueOf(entry.getValue()));
                    }
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + reducerName + "]: [" + currentFieldName + "].", parser.getTokenLocation());
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + reducerName + "].", parser.getTokenLocation());
        }
        if (bucketsPathsMap == null) {
            throw new SearchParseException(context, "Missing required field [" + BUCKETS_PATH.getPreferredName() + "] for series_arithmetic aggregation [" + reducerName + "]", parser.getTokenLocation());
        }
        if (script == null) {
            throw new SearchParseException(context, "Missing required field [" + Script.ScriptField.SCRIPT.getPreferredName() + "] for series_arithmetic aggregation [" + reducerName + "]", parser.getTokenLocation());
        }
        ValueFormatter formatter = null;
        formatter = format != null ? ValueFormat.Number.format(format).formatter() : ValueFormatter.RAW;
        return new BucketScriptPipelineAggregator.Factory(reducerName, bucketsPathsMap, script, formatter, gapPolicy);
    }
}

