/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.tasks.compile.incremental.deps.DefaultDependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDependentsAccumulator {
    private final Map<String, DependentsSet> dependents = new HashMap<String, DependentsSet>();
    private final String packagePrefix;

    public ClassDependentsAccumulator(String packagePrefix) {
        this.packagePrefix = packagePrefix;
    }

    public void addClass(String className, boolean dependencyToAll, Iterable<String> classDependencies) {
        if (className.startsWith(this.packagePrefix)) {
            this.rememberClass(className).setDependencyToAll(dependencyToAll);
        }
        for (String dependency : classDependencies) {
            if (dependency.equals(className) || !dependency.startsWith(this.packagePrefix)) continue;
            DefaultDependentsSet d = this.rememberClass(dependency);
            if (!className.startsWith(this.packagePrefix)) continue;
            d.addDependent(className);
        }
    }

    private DefaultDependentsSet rememberClass(String className) {
        DependentsSet d = this.dependents.get(className);
        if (d == null) {
            d = new DefaultDependentsSet();
            this.dependents.put(className, d);
        }
        return (DefaultDependentsSet)d;
    }

    public Map<String, DependentsSet> getDependentsMap() {
        return this.dependents;
    }
}

