/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MethodType {
    IS_GETTER,
    GET_GETTER,
    SETTER,
    NON_PROPERTY;


    public String propertyNameFor(Method method) {
        String methodName = method.getName();
        int prefixLength = this == IS_GETTER ? 2 : 3;
        String methodNamePrefixRemoved = methodName.substring(prefixLength);
        return StringUtils.uncapitalize((String)methodNamePrefixRemoved);
    }

    public static MethodType of(Method method) {
        String methodName = method.getName();
        if (!MethodType.hasVoidReturnType(method) && MethodType.takesNoParameter(method)) {
            if (MethodType.isGetGetterName(methodName)) {
                return GET_GETTER;
            }
            if (MethodType.isIsGetterName(methodName)) {
                return IS_GETTER;
            }
        }
        if (MethodType.hasVoidReturnType(method) && MethodType.takesSingleParameter(method) && MethodType.isSetterName(methodName)) {
            return SETTER;
        }
        return NON_PROPERTY;
    }

    public static boolean hasVoidReturnType(Method method) {
        return Void.TYPE.equals(method.getReturnType());
    }

    public static boolean takesNoParameter(Method method) {
        return method.getParameterTypes().length == 0;
    }

    public static boolean takesSingleParameter(Method method) {
        return method.getParameterTypes().length == 1;
    }

    public static boolean isPropertyMethodName(String methodName) {
        return MethodType.isGetGetterName(methodName) || MethodType.isIsGetterName(methodName) || MethodType.isSetterName(methodName);
    }

    public static boolean isGetterName(String methodName) {
        return MethodType.isGetGetterName(methodName) || MethodType.isIsGetterName(methodName);
    }

    public static boolean isGetGetterName(String methodName) {
        return methodName.startsWith("get") && !"get".equals(methodName) && MethodType.isNthCharUpperCase(methodName, 4);
    }

    public static boolean isIsGetterName(String methodName) {
        return methodName.startsWith("is") && !"is".equals(methodName) && MethodType.isNthCharUpperCase(methodName, 3);
    }

    public static boolean isSetterName(String methodName) {
        return methodName.startsWith("set") && !"set".equals(methodName) && MethodType.isNthCharUpperCase(methodName, 4);
    }

    private static boolean isNthCharUpperCase(String methodName, int position) {
        return Character.isUpperCase(methodName.charAt(position - 1));
    }
}

