/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.interop.messages.Argument;
import com.oracle.truffle.interop.messages.Execute;
import com.oracle.truffle.interop.messages.GetSize;
import com.oracle.truffle.interop.messages.HasSize;
import com.oracle.truffle.interop.messages.IsBoxed;
import com.oracle.truffle.interop.messages.IsExecutable;
import com.oracle.truffle.interop.messages.IsNull;
import com.oracle.truffle.interop.messages.Read;
import com.oracle.truffle.interop.messages.Receiver;
import com.oracle.truffle.interop.messages.Unbox;
import com.oracle.truffle.interop.messages.Write;
import com.oracle.truffle.interop.node.ForeignObjectAccessNode;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@CoreClass(name="Truffle::Interop")
public abstract class TruffleInteropNodes {

    @CoreMethod(names={"size"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class GetSizeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ForeignObjectAccessNode node = ForeignObjectAccessNode.getAccess(GetSize.create(Receiver.create()));

        public GetSizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object executeForeign(VirtualFrame frame, String receiver) {
            return receiver.length();
        }

        @Specialization
        public Object executeForeign(VirtualFrame frame, TruffleObject receiver) {
            return this.node.executeForeign(frame, receiver, new Object[0]);
        }
    }

    @CoreMethod(names={"execute"}, isModuleFunction=true, needsSelf=false, required=1, rest=true)
    public static abstract class ExecuteNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ForeignObjectAccessNode node;

        public ExecuteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object executeForeign(VirtualFrame frame, TruffleObject receiver, Object[] arguments) {
            if (this.node == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.node = ForeignObjectAccessNode.getAccess(Execute.create(Receiver.create(), arguments.length));
            }
            return this.node.executeForeign(frame, receiver, arguments);
        }
    }

    @CoreMethod(names={"unbox_value"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class UnboxValueNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ForeignObjectAccessNode node = ForeignObjectAccessNode.getAccess(Unbox.create(Receiver.create()));

        public UnboxValueNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object executeForeign(VirtualFrame frame, TruffleObject receiver) {
            return this.node.executeForeign(frame, receiver, new Object[0]);
        }
    }

    @CoreMethod(names={"write_property"}, isModuleFunction=true, needsSelf=false, required=3)
    public static abstract class WritePropertyNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ForeignObjectAccessNode node = ForeignObjectAccessNode.getAccess(Write.create(Receiver.create(), Argument.create(), Argument.create()));
        @CompilerDirectives.CompilationFinal
        private String identifier;

        public WritePropertyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object executeForeign(VirtualFrame frame, TruffleObject receiver, int identifier, Object value) {
            return this.node.executeForeign(frame, receiver, identifier, value);
        }

        @Specialization
        public Object executeForeign(VirtualFrame frame, TruffleObject receiver, long identifier, Object value) {
            return this.node.executeForeign(frame, receiver, identifier, value);
        }

        @Specialization(guards={"isRubySymbol(identifier)"})
        public Object executeForeignSymbol(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, Object value) {
            if (this.identifier == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.identifier = Layouts.SYMBOL.getString(identifier).intern();
            }
            return this.node.executeForeign(frame, receiver, this.identifier, value);
        }

        @Specialization(guards={"isRubyString(identifier)"})
        public Object executeForeignString(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier, Object value) {
            return this.node.executeForeign(frame, receiver, WritePropertyNode.slowPathToString(identifier), value);
        }

        @CompilerDirectives.TruffleBoundary
        private static String slowPathToString(DynamicObject identifier) {
            assert (RubyGuards.isRubyString(identifier));
            return identifier.toString();
        }
    }

    @CoreMethod(names={"read_property"}, isModuleFunction=true, needsSelf=false, required=2)
    public static abstract class ReadPropertyNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ForeignObjectAccessNode node = ForeignObjectAccessNode.getAccess(Read.create(Receiver.create(), Argument.create()));
        @CompilerDirectives.CompilationFinal
        private String identifier;

        public ReadPropertyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object executeForeign(VirtualFrame frame, TruffleObject receiver, int identifier) {
            return this.node.executeForeign(frame, receiver, identifier);
        }

        @Specialization
        public Object executeForeign(VirtualFrame frame, TruffleObject receiver, long identifier) {
            return this.node.executeForeign(frame, receiver, identifier);
        }

        @Specialization(guards={"isRubySymbol(identifier)"})
        public Object executeForeignSymbol(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier) {
            if (this.identifier == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.identifier = Layouts.SYMBOL.getString(identifier).intern();
            }
            return this.node.executeForeign(frame, receiver, this.identifier);
        }

        @Specialization(guards={"isRubyString(identifier)"})
        public Object executeForeignString(VirtualFrame frame, TruffleObject receiver, DynamicObject identifier) {
            return this.node.executeForeign(frame, receiver, ReadPropertyNode.slowPathToString(identifier));
        }

        @CompilerDirectives.TruffleBoundary
        private static String slowPathToString(DynamicObject identifier) {
            assert (RubyGuards.isRubyString(identifier));
            return identifier.toString();
        }
    }

    @CoreMethod(names={"has_size_property?"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class HasSizePropertyNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ForeignObjectAccessNode node = ForeignObjectAccessNode.getAccess(HasSize.create(Receiver.create()));

        public HasSizePropertyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean hasSizeProperty(VirtualFrame frame, TruffleObject receiver) {
            return (Boolean)this.node.executeForeign(frame, receiver, new Object[0]);
        }
    }

    @CoreMethod(names={"null?"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class IsNullNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ForeignObjectAccessNode node = ForeignObjectAccessNode.getAccess(IsNull.create(Receiver.create()));

        public IsNullNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isNull(VirtualFrame frame, TruffleObject receiver) {
            return (Boolean)this.node.executeForeign(frame, receiver, new Object[0]);
        }
    }

    @CoreMethod(names={"boxed_primitive?"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class IsBoxedPrimitiveNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ForeignObjectAccessNode node = ForeignObjectAccessNode.getAccess(IsBoxed.create(Receiver.create()));

        public IsBoxedPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isBoxedPrimitive(VirtualFrame frame, TruffleObject receiver) {
            return (Boolean)this.node.executeForeign(frame, receiver, new Object[0]);
        }
    }

    @CoreMethod(names={"executable?"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class IsExecutableNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ForeignObjectAccessNode node = ForeignObjectAccessNode.getAccess(IsExecutable.create(Receiver.create()));

        public IsExecutableNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isExecutable(VirtualFrame frame, TruffleObject receiver) {
            return (Boolean)this.node.executeForeign(frame, receiver, new Object[0]);
        }
    }

    @CoreMethod(names={"interop_to_ruby_primitive"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class InteropToRubyNode
    extends CoreMethodArrayArgumentsNode {
        public InteropToRubyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int convert(byte value) {
            return value;
        }

        @Specialization
        public int convert(short value) {
            return value;
        }

        @Specialization
        public int convert(char value) {
            return value;
        }

        @Specialization
        public int convert(int value) {
            return value;
        }

        @Specialization
        public long convert(long value) {
            return value;
        }

        @Specialization
        public double convert(float value) {
            return value;
        }

        @Specialization
        public double convert(double value) {
            return value;
        }

        @Specialization
        public int convert(String value) {
            return value.charAt(0);
        }
    }
}

