/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import morfologik.fsa.FSA;
import morfologik.fsa.FSA5;
import morfologik.fsa.FSAInfo;
import morfologik.fsa.FSAUtils;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryAttribute;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import morfologik.tools.SharedOptions;
import morfologik.tools.Tool;
import morfologik.util.FileUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public final class FSADumpTool
extends Tool {
    private OutputStream os;
    private Writer w;
    private boolean dataOnly;
    private boolean decode;
    private boolean dot;

    @Override
    protected void go(CommandLine line) throws Exception {
        File dictionaryFile = (File)line.getParsedOptionValue(SharedOptions.fsaDictionaryFileOption.getOpt());
        this.dataOnly = line.hasOption(SharedOptions.dataOnly.getOpt());
        this.decode = line.hasOption(SharedOptions.decode.getOpt());
        this.dot = line.hasOption(SharedOptions.dot.getLongOpt());
        FileUtils.assertExists((File)dictionaryFile, (boolean)true, (boolean)false);
        this.dump(dictionaryFile);
    }

    private void dump(File dictionaryFile) throws UnsupportedEncodingException, IOException {
        FSA fsa;
        Dictionary dictionary;
        long start = System.currentTimeMillis();
        if (!dictionaryFile.canRead()) {
            this.printWarning("Dictionary file does not exist: " + dictionaryFile.getAbsolutePath());
            return;
        }
        this.os = new BufferedOutputStream(System.out, 32768);
        this.w = new OutputStreamWriter(this.os, "UTF-8");
        File metadataFile = FSADumpTool.expectedMetadataFile(dictionaryFile).getAbsoluteFile();
        if (metadataFile.exists() && metadataFile.isFile() && metadataFile.canRead()) {
            dictionary = Dictionary.read((File)dictionaryFile);
            fsa = dictionary.fsa;
            String encoding = dictionary.metadata.getEncoding();
            if (!Charset.isSupported(encoding)) {
                this.printWarning("Dictionary's charset is not supported on this JVM: " + encoding);
                return;
            }
        } else {
            dictionary = null;
            fsa = FSA.read((InputStream)new FileInputStream(dictionaryFile));
            this.printWarning("Warning: FSA automaton without metadata *.info file. The metadata file was expected at: " + metadataFile);
        }
        this.printExtra("FSA properties");
        this.printExtra("--------------");
        this.printExtra("FSA implementation     : " + fsa.getClass().getName());
        this.printExtra("Compiled with flags    : " + fsa.getFlags().toString());
        if (!this.dataOnly) {
            FSAInfo info = new FSAInfo(fsa);
            this.printExtra("Number of arcs         : " + info.arcsCount + "/" + info.arcsCountTotal);
            this.printExtra("Number of nodes        : " + info.nodeCount);
            this.printExtra("Number of final states : " + info.finalStatesCount);
            this.printExtra("");
        }
        char separator = '\t';
        if (fsa instanceof FSA5) {
            this.printExtra("FSA5 properties");
            this.printExtra("---------------");
            this.printFSA5((FSA5)fsa);
            this.printExtra("");
        }
        if (dictionary != null) {
            this.printExtra("Dictionary metadata");
            this.printExtra("-------------------");
            LinkedHashMap<DictionaryAttribute, String> values = new LinkedHashMap<DictionaryAttribute, String>(dictionary.metadata.getAttributes());
            values.put(DictionaryAttribute.ENCODING, dictionary.metadata.getEncoding());
            values.put(DictionaryAttribute.SEPARATOR, "0x" + Integer.toHexString(dictionary.metadata.getSeparator()) + " ('" + dictionary.metadata.getSeparatorAsChar() + "')");
            for (Map.Entry e : values.entrySet()) {
                this.printExtra(String.format(Locale.ENGLISH, "%-40s: %s", ((DictionaryAttribute)e.getKey()).propertyName, e.getValue()));
            }
            this.printExtra("");
        }
        int sequences = 0;
        if (this.decode) {
            if (dictionary == null) {
                this.printWarning("No dictionary metadata available.");
                return;
            }
            this.printExtra("Decoded FSA data (in the encoding above)");
            this.printExtra("----------------------------------------");
            DictionaryLookup dl = new DictionaryLookup(dictionary);
            StringBuilder builder = new StringBuilder();
            OutputStreamWriter osw = new OutputStreamWriter(this.os, dictionary.metadata.getEncoding());
            for (WordData wd : dl) {
                builder.setLength(0);
                builder.append(wd.getWord());
                builder.append(separator);
                CharSequence t = wd.getStem();
                if (t == null) {
                    t = "";
                }
                builder.append(t);
                builder.append(separator);
                t = wd.getTag();
                if (t == null) {
                    t = "";
                }
                builder.append(t);
                builder.append('\n');
                osw.write(builder.toString());
                ++sequences;
            }
            osw.flush();
        } else if (this.dot) {
            FSAUtils.toDot((Writer)this.w, (FSA)fsa, (int)fsa.getRootNode());
            this.w.flush();
        } else {
            this.printExtra("FSA data (raw bytes in the encoding above)");
            this.printExtra("------------------------------------------");
            for (ByteBuffer bb : fsa) {
                this.os.write(bb.array(), 0, bb.remaining());
                this.os.write(10);
                ++sequences;
            }
        }
        this.printExtra("--------------------");
        long millis = Math.max(1L, System.currentTimeMillis() - start);
        this.printExtra(String.format(Locale.ENGLISH, "Dictionary dumped in %.3f second(s), %d sequences (%d sequences/sec.).", (double)millis / 1000.0, sequences, (int)((double)sequences / ((double)millis / 1000.0))));
        this.os.flush();
    }

    private void printFSA5(FSA5 fsa) throws IOException {
        this.printExtra("GTL                    : " + fsa.gtl);
        this.printExtra("Node extra data        : " + fsa.nodeDataLength);
        this.printExtra("Annotation separator   : " + this.byteAsChar(fsa.annotation));
        this.printExtra("Filler character       : " + this.byteAsChar(fsa.filler));
    }

    private char byteAsChar(byte v) {
        char chr = (char)(v & 0xFF);
        if (chr < '\u007f') {
            return chr;
        }
        return '?';
    }

    private void printExtra(String msg) throws IOException {
        if (this.dataOnly) {
            return;
        }
        this.w.write(msg);
        this.w.write(10);
        this.w.flush();
    }

    private void printWarning(String msg) {
        System.err.println(msg);
    }

    private static File expectedMetadataFile(File fsaFile) {
        return new File(fsaFile.getParent(), Dictionary.getExpectedFeaturesName((String)fsaFile.getName()));
    }

    @Override
    protected void initializeOptions(Options options) {
        options.addOption(SharedOptions.fsaDictionaryFileOption);
        options.addOption(SharedOptions.dataOnly);
        options.addOption(SharedOptions.decode);
        options.addOption(SharedOptions.dot);
    }

    public static void main(String ... args) throws Exception {
        FSADumpTool fsaDump = new FSADumpTool();
        fsaDump.go(args);
    }
}

