/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.languagetool.rules.ConfusionString;
import org.languagetool.tools.StringTools;

public class ConfusionSet {
    private final Set<ConfusionString> set = new HashSet<ConfusionString>();
    private final long factor;

    public ConfusionSet(long factor, List<ConfusionString> confusionStrings) {
        if (factor < 1L) {
            throw new IllegalArgumentException("factor must be >= 1: " + factor);
        }
        this.factor = factor;
        this.set.addAll((Collection<ConfusionString>)Objects.requireNonNull(confusionStrings));
    }

    public ConfusionSet(long factor, String ... words) {
        if (factor < 1L) {
            throw new IllegalArgumentException("factor must be >= 1: " + factor);
        }
        Objects.requireNonNull(words);
        this.factor = factor;
        for (String word : words) {
            this.set.add(new ConfusionString(word, null));
        }
    }

    public long getFactor() {
        return this.factor;
    }

    public Set<ConfusionString> getSet() {
        return Collections.unmodifiableSet(this.set);
    }

    public Set<ConfusionString> getUppercaseFirstCharSet() {
        HashSet<ConfusionString> result = new HashSet<ConfusionString>();
        for (ConfusionString s : this.set) {
            ConfusionString newString = new ConfusionString(StringTools.uppercaseFirstChar(s.getString()), s.getDescription());
            result.add(newString);
        }
        return Collections.unmodifiableSet(result);
    }

    public String toString() {
        return this.set.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfusionSet other = (ConfusionSet)o;
        if (this.factor != other.factor) {
            return false;
        }
        return this.set.equals(other.set);
    }

    public int hashCode() {
        int result = this.set.hashCode();
        result = 31 * result + (int)(this.factor ^ this.factor >>> 32);
        return result;
    }
}

