/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import morfologik.fsa.FSA;

public final class FSAFinalStatesIterator
implements Iterator<ByteBuffer> {
    private static final int EXPECTED_MAX_STATES = 15;
    private final FSA fsa;
    private ByteBuffer nextElement;
    private byte[] buffer = new byte[15];
    private ByteBuffer bufferWrapper = ByteBuffer.wrap(this.buffer);
    private int[] arcs = new int[15];
    private int position;

    public FSAFinalStatesIterator(FSA fsa, int node) {
        this.fsa = fsa;
        if (fsa.getFirstArc(node) != 0) {
            this.restartFrom(node);
        }
    }

    public void restartFrom(int node) {
        this.position = 0;
        this.bufferWrapper.clear();
        this.nextElement = null;
        this.pushNode(node);
    }

    @Override
    public boolean hasNext() {
        if (this.nextElement == null) {
            this.nextElement = this.advance();
        }
        return this.nextElement != null;
    }

    @Override
    public ByteBuffer next() {
        if (this.nextElement != null) {
            ByteBuffer cache = this.nextElement;
            this.nextElement = null;
            return cache;
        }
        ByteBuffer cache = this.advance();
        if (cache == null) {
            throw new NoSuchElementException();
        }
        return cache;
    }

    private final ByteBuffer advance() {
        if (this.position == 0) {
            return null;
        }
        while (this.position > 0) {
            int lastIndex = this.position - 1;
            int arc = this.arcs[lastIndex];
            if (arc == 0) {
                --this.position;
                continue;
            }
            this.arcs[lastIndex] = this.fsa.getNextArc(arc);
            int bufferLength = this.buffer.length;
            if (lastIndex >= bufferLength) {
                this.buffer = Arrays.copyOf(this.buffer, bufferLength + 15);
                this.bufferWrapper = ByteBuffer.wrap(this.buffer);
            }
            this.buffer[lastIndex] = this.fsa.getArcLabel(arc);
            if (!this.fsa.isArcTerminal(arc)) {
                this.pushNode(this.fsa.getEndNode(arc));
            }
            if (!this.fsa.isArcFinal(arc)) continue;
            this.bufferWrapper.clear();
            this.bufferWrapper.limit(lastIndex + 1);
            return this.bufferWrapper;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Read-only iterator.");
    }

    private void pushNode(int node) {
        if (this.position == this.arcs.length) {
            this.arcs = Arrays.copyOf(this.arcs, this.arcs.length + 15);
        }
        this.arcs[this.position++] = this.fsa.getFirstArc(node);
    }
}

