/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.StringUtils;
import org.languagetool.rules.Category;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.FalseFriendPatternRule;
import org.languagetool.tools.StringTools;

public final class Tools {
    private Tools() {
    }

    static File openFileDialog(Frame frame, FileFilter fileFilter) {
        return Tools.openFileDialog(frame, fileFilter, null);
    }

    static File openFileDialog(Frame frame, FileFilter fileFilter, File initialDir) {
        return Tools.openFileDialog(frame, fileFilter, initialDir, 0);
    }

    static File openDirectoryDialog(Frame frame, File initialDir) {
        return Tools.openFileDialog(frame, null, initialDir, 1);
    }

    private static File openFileDialog(Frame frame, FileFilter fileFilter, File initialDir, int mode) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(mode);
        jfc.setCurrentDirectory(initialDir);
        jfc.setFileFilter(fileFilter);
        jfc.showOpenDialog(frame);
        return jfc.getSelectedFile();
    }

    static void showError(Exception e) {
        String stackTrace = org.languagetool.tools.Tools.getFullStackTrace((Throwable)e);
        String msg = "<html><p style='width: 600px;'>" + StringTools.escapeHTML((String)stackTrace);
        JOptionPane.showMessageDialog(null, msg, "Error", 0);
        e.printStackTrace();
    }

    static void showErrorMessage(Exception e, Component parent) {
        String msg = e.getMessage();
        JOptionPane.showMessageDialog(parent, msg, "Error", 0);
        e.printStackTrace();
    }

    static void showErrorMessage(Exception e) {
        Tools.showErrorMessage(e, null);
    }

    public static String shortenComment(String comment) {
        int maxCommentLength = 100;
        String shortComment = comment;
        if (shortComment.length() > 100) {
            while (shortComment.lastIndexOf(" [") > 0 && shortComment.lastIndexOf(93) > shortComment.lastIndexOf(" [") && shortComment.length() > 100) {
                shortComment = shortComment.substring(0, shortComment.lastIndexOf(" [")) + shortComment.substring(shortComment.lastIndexOf(93) + 1);
            }
            while (shortComment.lastIndexOf(" (") > 0 && shortComment.lastIndexOf(41) > shortComment.lastIndexOf(" (") && shortComment.length() > 100) {
                shortComment = shortComment.substring(0, shortComment.lastIndexOf(" (")) + shortComment.substring(shortComment.lastIndexOf(41) + 1);
            }
            if (shortComment.length() > 100) {
                shortComment = shortComment.substring(0, 99) + "\u2026";
            }
        }
        return shortComment;
    }

    public static String getLabel(String label) {
        return label.replaceAll("&([^&])", "$1").replaceAll("&&", "&");
    }

    public static char getMnemonic(String label) {
        int mnemonicPos = label.indexOf(38);
        while (mnemonicPos != -1 && mnemonicPos == label.indexOf("&&") && mnemonicPos < label.length()) {
            mnemonicPos = label.indexOf(38, mnemonicPos + 2);
        }
        if (mnemonicPos == -1 || mnemonicPos == label.length()) {
            return '\u0000';
        }
        return label.charAt(mnemonicPos + 1);
    }

    public static void centerDialog(JDialog dialog) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = dialog.getSize();
        dialog.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
        dialog.setLocationByPlatform(true);
    }

    static void showRuleInfoDialog(Component parent, String title, String message, Rule rule, ResourceBundle messages, String lang) {
        int dialogWidth = 320;
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setContentType("text/html");
        textPane.setBorder(BorderFactory.createEmptyBorder());
        textPane.setOpaque(false);
        textPane.setBackground(new Color(0, 0, 0, 0));
        textPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception ex) {
                        Tools.showError(ex);
                    }
                }
            }
        });
        textPane.setSize(dialogWidth, Short.MAX_VALUE);
        String messageWithBold = message.replaceAll("<suggestion>", "<b>").replaceAll("</suggestion>", "</b>");
        String exampleSentences = Tools.getExampleSentences(rule, messages);
        String url = "http://community.languagetool.org/rule/show/" + Tools.encodeUrl(rule) + "?lang=" + lang + "&amp;ref=standalone-gui";
        boolean isExternal = rule.getCategory().getLocation() == Category.Location.EXTERNAL;
        String ruleDetailLink = rule instanceof FalseFriendPatternRule || isExternal ? "" : "<a href='" + url + "'>" + messages.getString("ruleDetailsLink") + "</a>";
        textPane.setText("<html>" + messageWithBold + exampleSentences + Tools.formatURL(rule.getUrl()) + "<br><br>" + ruleDetailLink + "</html>");
        JScrollPane scrollPane = new JScrollPane(textPane);
        scrollPane.setPreferredSize(new Dimension(dialogWidth, textPane.getPreferredSize().height));
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        String cleanTitle = title.replace("<suggestion>", "'").replace("</suggestion>", "'");
        JOptionPane.showMessageDialog(parent, scrollPane, cleanTitle, 1);
    }

    private static String encodeUrl(Rule rule) {
        try {
            return URLEncoder.encode(rule.getId(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getExampleSentences(Rule rule, ResourceBundle messages) {
        IncorrectExample incorrectExample;
        List corrections;
        List correctExamples;
        StringBuilder examples = new StringBuilder(200);
        List incorrectExamples = rule.getIncorrectExamples();
        if (incorrectExamples.size() > 0) {
            String incorrectExample2 = ((IncorrectExample)incorrectExamples.iterator().next()).getExample();
            String sentence = incorrectExample2.replace("<marker>", "<span style='background-color:#ff8080'>").replace("</marker>", "</span>");
            examples.append("<br/>").append(sentence).append("&nbsp;<span style='color:red;font-style:italic;font-weight:bold'>x</span>");
        }
        if ((correctExamples = rule.getCorrectExamples()).size() > 0) {
            String correctExample = (String)correctExamples.iterator().next();
            String sentence = correctExample.replace("<marker>", "<span style='background-color:#80ff80'>").replace("</marker>", "</span>");
            examples.append("<br/>").append(sentence).append("&nbsp;<span style='color:green'>\u2713</span>");
        } else if (incorrectExamples.size() > 0 && (corrections = (incorrectExample = (IncorrectExample)incorrectExamples.iterator().next()).getCorrections()) != null && corrections.size() > 0) {
            String incorrectSentence = ((IncorrectExample)incorrectExamples.iterator().next()).getExample();
            String correctedSentence = incorrectSentence.replaceAll("<marker>.*?</marker>", "<span style='background-color:#80ff80'>" + (String)corrections.get(0) + "</span>");
            examples.append("<br/>").append(correctedSentence).append("&nbsp;<span style='color:green'>\u2713</span>");
        }
        if (examples.length() > 0) {
            examples.insert(0, "<br/><br/>" + messages.getString("guiExamples"));
        }
        return examples.toString();
    }

    private static String formatURL(URL url) {
        if (url == null) {
            return "";
        }
        return String.format("<br/><br/><a href=\"%s\">%s</a>", url.toExternalForm(), StringUtils.abbreviate((String)url.toString(), (int)50));
    }
}

