/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business.thumbnails.callables;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.pd.PDPage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.IdManager;
import org.pdfsam.guiclient.business.thumbnails.JPodRenderer;
import org.pdfsam.guiclient.commons.models.VisualListModel;
import org.pdfsam.guiclient.commons.panels.JVisualPdfPageSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.Rotation;
import org.pdfsam.guiclient.dto.VisualPageListItem;
import org.pdfsam.guiclient.utils.ImageUtility;
import org.pdfsam.i18n.GettextResource;

public class JPodThmbnailCallable
implements Callable<Boolean> {
    private static final Logger log = Logger.getLogger((String)JPodThmbnailCallable.class.getPackage().getName());
    private PDPage pdPage;
    private JVisualPdfPageSelectionPanel panel;
    private VisualPageListItem pageItem;
    private long id;

    public JPodThmbnailCallable(PDPage pdPage, VisualPageListItem pageItem, JVisualPdfPageSelectionPanel panel, long id) {
        this.pdPage = pdPage;
        this.pageItem = pageItem;
        this.panel = panel;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        Boolean retVal = Boolean.FALSE;
        if (!IdManager.getInstance().isCancelledExecution(this.id)) {
            IGraphicsContext graphics = null;
            try {
                Rectangle2D rect = this.pdPage.getCropBox().toNormalizedRectangle();
                double rectHeight = rect.getHeight();
                double recWidth = rect.getWidth();
                double resizePercentage = this.getResizePercentage(rectHeight, recWidth);
                int height = Math.round((float)((int)rect.getHeight()) * (float)resizePercentage);
                int width = Math.round((float)((int)rect.getWidth()) * (float)resizePercentage);
                BufferedImage imageInstance = new BufferedImage((int)recWidth, (int)rectHeight, 1);
                Graphics2D g2 = (Graphics2D)imageInstance.getGraphics();
                graphics = new CwtAwtGraphicsContext(g2);
                AffineTransform imgTransform = graphics.getTransform();
                imgTransform.scale(1.0, -1.0);
                imgTransform.translate(-rect.getMinX(), -rect.getMaxY());
                graphics.setTransform(imgTransform);
                graphics.setBackgroundColor(Color.WHITE);
                graphics.fill(rect);
                CSContent content = this.pdPage.getContentStream();
                if (content != null) {
                    JPodRenderer renderer = new JPodRenderer(null, graphics);
                    renderer.process(content, this.pdPage.getResources());
                }
                BufferedImage scaledInstance = ImageUtility.getScaledInstance((BufferedImage)imageInstance, (int)width, (int)height);
                this.pageItem.setPaperFormat(recWidth, rectHeight, 72);
                if (this.pdPage.getRotate() != 0) {
                    this.pageItem.setOriginalRotation(Rotation.getRotation((int)this.pdPage.getRotate()));
                }
                if (this.pageItem.isRotated()) {
                    this.pageItem.setThumbnail(ImageUtility.rotateImage((Image)scaledInstance, (int)this.pageItem.getCompleteRotation()));
                } else {
                    this.pageItem.setThumbnail(scaledInstance);
                }
                retVal = Boolean.TRUE;
            }
            catch (Throwable t) {
                this.pageItem.setThumbnail(ImageUtility.getErrorImage());
                log.error((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to generate thumbnail"), t);
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
                this.pdPage = null;
            }
            ((VisualListModel)this.panel.getThumbnailList().getModel()).elementChanged(this.pageItem);
        }
        return retVal;
    }

    private double getResizePercentage(double height, double width) {
        double retVal = 0.0;
        retVal = height >= width ? (double)Math.round((double)Configuration.getInstance().getThumbnailSize() / height * 100.0) / 100.0 : (double)Math.round((double)Configuration.getInstance().getThumbnailSize() / width * 100.0) / 100.0;
        return retVal < 1.0 ? retVal : 1.0;
    }
}

