/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDTransformMethod;
import de.intarsys.pdf.pd.PDTransformParams;

public class PDSignatureReference
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_Type_SigRef = COSName.constant("SigRef");
    public static final COSName DK_TransformMethod = COSName.constant("TransformMethod");
    public static final COSName DK_TransformParams = COSName.constant("TransformParams");
    public static final COSName DK_Data = COSName.constant("Data");
    public static final COSName DK_DigestMethod = COSName.constant("DigestMethod");
    public static final COSName DK_DigestValue = COSName.constant("DigestValue");
    public static final COSName DK_DigestLocation = COSName.constant("DigestLocation");
    public static final String DIGESTMETHOD_MD5 = "MD5";
    public static final String DIGESTMETHOD_SHA1 = "SHA1";
    private static final String DEFAULT_DIGESTMETHOD = "MD5";

    protected PDSignatureReference(COSObject cOSObject) {
        super(cOSObject);
    }

    public COSObject cosGetData() {
        COSObject cOSObject = this.cosGetField(DK_Data);
        return cOSObject.isNull() ? null : cOSObject;
    }

    public COSArray cosGetDigestLocation() {
        return this.cosGetField(DK_DigestLocation).asArray();
    }

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_SigRef;
    }

    public void cosSetData(COSObject cOSObject) {
        this.cosSetField(DK_Data, cOSObject);
    }

    public String getDigestMethod() {
        COSName cOSName = this.cosGetField(DK_DigestMethod).asName();
        if (cOSName == null) {
            return "MD5";
        }
        return cOSName.stringValue();
    }

    public byte[] getDigestValue() {
        COSString cOSString = this.cosGetField(DK_DigestValue).asString();
        if (cOSString == null) {
            return null;
        }
        return cOSString.byteValue();
    }

    public PDTransformMethod getTransformMethod() {
        return (PDTransformMethod)PDTransformMethod.META.createFromCos(this.cosGetField(DK_TransformMethod));
    }

    public PDTransformParams getTransformParams() {
        return (PDTransformParams)PDTransformParams.META.createFromCos(this.cosGetField(DK_TransformParams));
    }

    public void setDigestMethod(String string) {
        COSName cOSName = null;
        if (string != null) {
            cOSName = COSName.create(string);
        }
        this.cosSetField(DK_DigestMethod, cOSName);
    }

    public void setDigestValue(byte[] byArray) {
        COSString cOSString = null;
        if (byArray != null) {
            cOSString = COSString.create(byArray);
        }
        this.cosSetField(DK_DigestValue, cOSString);
    }

    public void setTransformMethod(PDTransformMethod pDTransformMethod) {
        COSObject cOSObject = null;
        if (pDTransformMethod != null) {
            cOSObject = pDTransformMethod.cosGetObject();
        }
        this.cosSetField(DK_TransformMethod, cOSObject);
    }

    public void setTransformParams(PDTransformParams pDTransformParams) {
        COSObject cOSObject = null;
        if (pDTransformParams != null) {
            cOSObject = pDTransformParams.cosGetObject();
        }
        this.cosSetField(DK_TransformParams, cOSObject);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDSignatureReference(cOSObject);
        }
    }
}

