/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.vpagereorder.GUI;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pdfsam.guiclient.business.listeners.EnterDoClickListener;
import org.pdfsam.guiclient.commons.business.listeners.CompressCheckBoxItemListener;
import org.pdfsam.guiclient.commons.components.CommonComponentsFactory;
import org.pdfsam.guiclient.commons.components.JPdfVersionCombo;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.commons.models.VisualListModel;
import org.pdfsam.guiclient.commons.panels.JVisualPdfPageSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.DocumentPage;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.guiclient.dto.VisualPageListItem;
import org.pdfsam.guiclient.exceptions.LoadJobException;
import org.pdfsam.guiclient.exceptions.SaveJobException;
import org.pdfsam.guiclient.gui.components.JHelpLabel;
import org.pdfsam.guiclient.plugins.interfaces.AbstractPlugablePanel;
import org.pdfsam.guiclient.utils.XmlUtility;
import org.pdfsam.i18n.GettextResource;
import org.pdfsam.plugin.vpagereorder.listeners.RunButtonActionListener;

public class VPageReorderMainGUI
extends AbstractPlugablePanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -1965981976755542201L;
    private static final String DEFAULT_OUPUT_NAME = "reordered_file.pdf";
    private static final Logger log = Logger.getLogger((String)VPageReorderMainGUI.class.getPackage().getName());
    private JTextField destinationFileText = CommonComponentsFactory.getInstance().createTextField(1);
    private JHelpLabel destinationHelpLabel;
    private Configuration config;
    private JPdfVersionCombo versionCombo = new JPdfVersionCombo(true);
    private JVisualPdfPageSelectionPanel selectionPanel = new JVisualPdfPageSelectionPanel();
    private final PageReorderPolicy pageReorderFocusPolicy = new PageReorderPolicy();
    private SpringLayout destinationPanelLayout;
    private final JButton browseDestButton = CommonComponentsFactory.getInstance().createButton(2);
    private final JButton runButton = CommonComponentsFactory.getInstance().createButton(1);
    private final JCheckBox overwriteCheckbox = CommonComponentsFactory.getInstance().createCheckBox(1);
    private final JCheckBox outputCompressedCheck = CommonComponentsFactory.getInstance().createCheckBox(2);
    private final EnterDoClickListener browsedEnterkeyListener = new EnterDoClickListener(this.browseDestButton);
    private final EnterDoClickListener runEnterkeyListener = new EnterDoClickListener(this.runButton);
    private final JPanel destinationPanel = new JPanel();
    private JSplitPane splitPanel = null;
    private final JLabel outputVersionLabel = CommonComponentsFactory.getInstance().createLabel(1);
    private final JRadioButton sameAsSourceRadio = new JRadioButton();
    private final JRadioButton chooseAFileRadio = new JRadioButton();
    private static final String PLUGIN_AUTHOR = "Andrea Vacondio";
    private static final String PLUGIN_VERSION = "0.0.7";

    public VPageReorderMainGUI() {
        this.initialize();
    }

    private void initialize() {
        this.config = Configuration.getInstance();
        this.setPanelIcon("/images/vreorder.png");
        this.setPreferredSize(new Dimension(500, 550));
        this.setLayout(new GridBagLayout());
        this.selectionPanel.addPropertyChangeListener((PropertyChangeListener)this);
        this.destinationPanelLayout = new SpringLayout();
        this.destinationPanel.setLayout(this.destinationPanelLayout);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Destination output file"));
        this.destinationPanel.setBorder(titledBorder);
        this.destinationPanel.setPreferredSize(new Dimension(180, 160));
        this.add(this.destinationPanel);
        this.sameAsSourceRadio.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Same as source"));
        this.destinationPanel.add(this.sameAsSourceRadio);
        this.chooseAFileRadio.setSelected(true);
        this.chooseAFileRadio.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Choose a file"));
        this.destinationPanel.add(this.chooseAFileRadio);
        this.destinationPanel.add(this.destinationFileText);
        this.destinationPanel.add(this.overwriteCheckbox);
        this.destinationPanel.add(this.outputCompressedCheck);
        this.outputCompressedCheck.addItemListener((ItemListener)new CompressCheckBoxItemListener(this.versionCombo));
        this.outputCompressedCheck.setSelected(true);
        this.destinationPanel.add((Component)this.versionCombo);
        this.destinationPanel.add(this.outputVersionLabel);
        this.browseDestButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File chosenFile;
                JFileChooser fileChooser = SharedJFileChooser.getInstance((SharedJFileChooserType)SharedJFileChooserType.PDF_FILE, (int)0, (String)VPageReorderMainGUI.this.destinationFileText.getText());
                if (fileChooser.showOpenDialog(VPageReorderMainGUI.this.browseDestButton.getParent()) == 0 && (chosenFile = fileChooser.getSelectedFile()) != null) {
                    VPageReorderMainGUI.this.destinationFileText.setText(chosenFile.getAbsolutePath());
                }
            }
        });
        this.destinationPanel.add(this.browseDestButton);
        String helpTextDest = "<html><body><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Destination output file") + "</b>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Use the same output file name as the input file or choose a file.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"To choose a file browse or enter the full path to the destination output file.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Check the box if you want to overwrite the output files if they already exist.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Check the box if you want compressed output files.") + " " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"PDF version 1.5 or above.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set the pdf version of the ouput document.") + "</p>" + "</body></html>";
        this.destinationHelpLabel = new JHelpLabel(helpTextDest, true);
        this.destinationPanel.add((Component)this.destinationHelpLabel);
        this.splitPanel = new JSplitPane(0, (Component)this.selectionPanel, new JScrollPane(this.destinationPanel, 20, 31));
        this.splitPanel.setOneTouchExpandable(true);
        this.splitPanel.setResizeWeight(1.0);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.gridheight = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 10, 0);
        this.add(this.splitPanel, c);
        ButtonGroup outputRadioGroup = new ButtonGroup();
        outputRadioGroup.add(this.sameAsSourceRadio);
        outputRadioGroup.add(this.chooseAFileRadio);
        this.sameAsSourceRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VPageReorderMainGUI.this.destinationFileText.setEnabled(false);
                VPageReorderMainGUI.this.browseDestButton.setEnabled(false);
            }
        });
        this.chooseAFileRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VPageReorderMainGUI.this.destinationFileText.setEnabled(true);
                VPageReorderMainGUI.this.browseDestButton.setEnabled(true);
            }
        });
        this.browseDestButton.addKeyListener((KeyListener)this.browsedEnterkeyListener);
        this.runButton.addKeyListener((KeyListener)this.runEnterkeyListener);
        this.runButton.addActionListener((ActionListener)((Object)new RunButtonActionListener(this)));
        this.runButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Execute pages reorder"));
        this.runButton.setSize(new Dimension(88, 25));
        c.fill = 0;
        c.ipadx = 5;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 26;
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 2;
        c.insets = new Insets(10, 10, 10, 10);
        this.add(this.runButton, c);
        this.setLayout();
    }

    private void setLayout() {
        this.destinationPanelLayout.putConstraint("South", (Component)this.sameAsSourceRadio, 25, "North", (Component)this.sameAsSourceRadio);
        this.destinationPanelLayout.putConstraint("North", (Component)this.sameAsSourceRadio, 1, "North", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("West", (Component)this.sameAsSourceRadio, 10, "West", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.chooseAFileRadio, 0, "South", (Component)this.sameAsSourceRadio);
        this.destinationPanelLayout.putConstraint("North", (Component)this.chooseAFileRadio, 0, "North", (Component)this.sameAsSourceRadio);
        this.destinationPanelLayout.putConstraint("West", (Component)this.chooseAFileRadio, 20, "East", (Component)this.sameAsSourceRadio);
        this.destinationPanelLayout.putConstraint("South", (Component)this.destinationFileText, 50, "North", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.destinationFileText, 30, "North", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("East", (Component)this.destinationFileText, -105, "East", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("West", (Component)this.destinationFileText, 5, "West", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.overwriteCheckbox, 17, "North", (Component)this.overwriteCheckbox);
        this.destinationPanelLayout.putConstraint("North", (Component)this.overwriteCheckbox, 5, "South", (Component)this.destinationFileText);
        this.destinationPanelLayout.putConstraint("West", (Component)this.overwriteCheckbox, 0, "West", (Component)this.destinationFileText);
        this.destinationPanelLayout.putConstraint("South", (Component)this.outputCompressedCheck, 17, "North", (Component)this.outputCompressedCheck);
        this.destinationPanelLayout.putConstraint("North", (Component)this.outputCompressedCheck, 5, "South", (Component)this.overwriteCheckbox);
        this.destinationPanelLayout.putConstraint("West", (Component)this.outputCompressedCheck, 0, "West", (Component)this.destinationFileText);
        this.destinationPanelLayout.putConstraint("South", (Component)this.outputVersionLabel, 17, "North", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.outputVersionLabel, 8, "South", (Component)this.outputCompressedCheck);
        this.destinationPanelLayout.putConstraint("West", (Component)this.outputVersionLabel, 0, "West", (Component)this.destinationFileText);
        this.destinationPanelLayout.putConstraint("South", (Component)this.versionCombo, 0, "South", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("West", (Component)this.versionCombo, 2, "East", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.browseDestButton, 0, "South", (Component)this.destinationFileText);
        this.destinationPanelLayout.putConstraint("East", (Component)this.browseDestButton, -10, "East", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.browseDestButton, -25, "South", (Component)this.destinationFileText);
        this.destinationPanelLayout.putConstraint("West", (Component)this.browseDestButton, -98, "East", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.destinationHelpLabel, -1, "South", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("East", (Component)this.destinationHelpLabel, -1, "East", (Component)this.destinationPanel);
    }

    public FocusTraversalPolicy getFocusPolicy() {
        return this.pageReorderFocusPolicy;
    }

    public Node getJobNode(Node arg0, boolean savePasswords) throws SaveJobException {
        try {
            if (arg0 != null) {
                Element fileSource = ((Element)arg0).addElement("source");
                File item = this.selectionPanel.getSelectedPdfDocument();
                if (item != null) {
                    fileSource.addAttribute("value", item.getAbsolutePath());
                    if (savePasswords) {
                        fileSource.addAttribute("password", this.selectionPanel.getSelectedPdfDocumentPassword() != null ? this.selectionPanel.getSelectedPdfDocumentPassword() : "");
                        VisualPageListItem[] pages = ((VisualListModel)this.selectionPanel.getThumbnailList().getModel()).getElements();
                        if (pages != null && pages.length > 0) {
                            for (VisualPageListItem page : pages) {
                                Element currentPage = fileSource.addElement("page");
                                currentPage.addAttribute("number", Integer.toString(page.getPageNumber()));
                                currentPage.addAttribute("deleted", String.valueOf(page.isDeleted()));
                                currentPage.addAttribute("rotation", Integer.toString(page.getRotation().getDegrees()));
                            }
                        }
                    }
                }
                Element fileDestination = ((Element)arg0).addElement("destination");
                fileDestination.addAttribute("value", this.destinationFileText.getText());
                Element fileOverwrite = ((Element)arg0).addElement("overwrite");
                fileOverwrite.addAttribute("value", this.overwriteCheckbox.isSelected() ? TRUE : FALSE);
                Element fileCompress = ((Element)arg0).addElement("compressed");
                fileCompress.addAttribute("value", this.outputCompressedCheck.isSelected() ? TRUE : FALSE);
                Element pdfVersion = ((Element)arg0).addElement("pdfversion");
                pdfVersion.addAttribute("value", ((StringItem)this.versionCombo.getSelectedItem()).getId());
            }
            return arg0;
        }
        catch (Exception ex) {
            throw new SaveJobException((Throwable)ex);
        }
    }

    public String getPluginAuthor() {
        return PLUGIN_AUTHOR;
    }

    public String getPluginName() {
        return GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Visual reorder");
    }

    public String getVersion() {
        return PLUGIN_VERSION;
    }

    public void loadJobNode(Node arg0) throws LoadJobException {
        try {
            Node pdfVersion;
            Node fileCompressed;
            Node fileDestination;
            Node fileSource = arg0.selectSingleNode("source/@value");
            if (fileSource != null && fileSource.getText().length() > 0) {
                Node filePwd = arg0.selectSingleNode("source/@password");
                String password = null;
                if (filePwd != null && filePwd.getText().length() > 0) {
                    password = filePwd.getText();
                }
                ArrayList<DocumentPage> template = null;
                List pages = arg0.selectNodes("source/page");
                if (pages != null && pages.size() > 0) {
                    for (Node pageNode : pages) {
                        DocumentPage currentPage = XmlUtility.getDocumentPage((Node)pageNode);
                        if (currentPage == null) continue;
                        if (template == null) {
                            template = new ArrayList<DocumentPage>();
                        }
                        template.add(currentPage);
                    }
                }
                this.selectionPanel.getPdfLoader().addFile(new File(fileSource.getText()), password, template);
            }
            if ((fileDestination = arg0.selectSingleNode("destination/@value")) != null && fileDestination.getText().length() > 0) {
                this.destinationFileText.setText(fileDestination.getText());
                this.chooseAFileRadio.doClick();
            } else {
                this.sameAsSourceRadio.doClick();
            }
            Node fileOverwrite = arg0.selectSingleNode("overwrite/@value");
            if (fileOverwrite != null) {
                this.overwriteCheckbox.setSelected(TRUE.equals(fileOverwrite.getText()));
            }
            if ((fileCompressed = arg0.selectSingleNode("compressed/@value")) != null && TRUE.equals(fileCompressed.getText())) {
                this.outputCompressedCheck.doClick();
            }
            if ((pdfVersion = arg0.selectSingleNode("pdfversion/@value")) != null) {
                for (int i = 0; i < this.versionCombo.getItemCount(); ++i) {
                    if (!((StringItem)this.versionCombo.getItemAt(i)).getId().equals(pdfVersion.getText())) continue;
                    this.versionCombo.setSelectedIndex(i);
                    break;
                }
            }
            log.info((Object)GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Visual Reorder section loaded."));
        }
        catch (Exception ex) {
            log.error((Object)GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Error: "), (Throwable)ex);
        }
    }

    public void resetPanel() {
        this.selectionPanel.resetPanel();
        this.destinationFileText.setText("");
        this.versionCombo.resetComponent();
        this.outputCompressedCheck.setSelected(false);
        this.overwriteCheckbox.setSelected(false);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("defaultOutputPath".equals(evt.getPropertyName())) {
            this.chooseAFileRadio.doClick();
            this.destinationFileText.setText((String)evt.getNewValue() + File.separatorChar + DEFAULT_OUPUT_NAME);
        }
    }

    public JTextField getDestinationFileText() {
        return this.destinationFileText;
    }

    public JPdfVersionCombo getVersionCombo() {
        return this.versionCombo;
    }

    public JVisualPdfPageSelectionPanel getSelectionPanel() {
        return this.selectionPanel;
    }

    public JCheckBox getOverwriteCheckbox() {
        return this.overwriteCheckbox;
    }

    public JCheckBox getOutputCompressedCheck() {
        return this.outputCompressedCheck;
    }

    public JRadioButton getSameAsSourceRadio() {
        return this.sameAsSourceRadio;
    }

    public class PageReorderPolicy
    extends FocusTraversalPolicy {
        public Component getComponentAfter(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getLoadFileButton())) {
                if (VPageReorderMainGUI.this.selectionPanel.getClearButton() != null) {
                    return VPageReorderMainGUI.this.selectionPanel.getClearButton();
                }
                return VPageReorderMainGUI.this.selectionPanel.getZoomInButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getClearButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getZoomInButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getZoomInButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getZoomOutButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getZoomOutButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getMoveUpButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getMoveUpButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getMoveDownButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getMoveDownButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getRemoveButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getRemoveButton())) {
                if (VPageReorderMainGUI.this.selectionPanel.getUndeleteButton() != null) {
                    return VPageReorderMainGUI.this.selectionPanel.getUndeleteButton();
                }
                return VPageReorderMainGUI.this.selectionPanel.getRotateButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getUndeleteButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getRotateButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getRotateButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getRotateAntiButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getRotateAntiButton())) {
                return VPageReorderMainGUI.this.sameAsSourceRadio;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.sameAsSourceRadio)) {
                return VPageReorderMainGUI.this.chooseAFileRadio;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.chooseAFileRadio)) {
                if (VPageReorderMainGUI.this.destinationFileText.isEnabled()) {
                    return VPageReorderMainGUI.this.destinationFileText;
                }
                return VPageReorderMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.destinationFileText)) {
                return VPageReorderMainGUI.this.browseDestButton;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.browseDestButton)) {
                return VPageReorderMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.overwriteCheckbox)) {
                return VPageReorderMainGUI.this.outputCompressedCheck;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.outputCompressedCheck)) {
                return VPageReorderMainGUI.this.versionCombo;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.versionCombo)) {
                return VPageReorderMainGUI.this.runButton;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.runButton)) {
                return VPageReorderMainGUI.this.selectionPanel.getLoadFileButton();
            }
            return VPageReorderMainGUI.this.selectionPanel.getLoadFileButton();
        }

        public Component getComponentBefore(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getLoadFileButton())) {
                return VPageReorderMainGUI.this.runButton;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getClearButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getLoadFileButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getZoomInButton())) {
                if (VPageReorderMainGUI.this.selectionPanel.getClearButton() != null) {
                    return VPageReorderMainGUI.this.selectionPanel.getClearButton();
                }
                return VPageReorderMainGUI.this.selectionPanel.getLoadFileButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getZoomOutButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getZoomInButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getMoveUpButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getZoomOutButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getMoveDownButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getMoveUpButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getRemoveButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getMoveDownButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getUndeleteButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getRemoveButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getRotateButton())) {
                if (VPageReorderMainGUI.this.selectionPanel.getUndeleteButton() != null) {
                    return VPageReorderMainGUI.this.selectionPanel.getUndeleteButton();
                }
                return VPageReorderMainGUI.this.selectionPanel.getRemoveButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.selectionPanel.getRotateAntiButton())) {
                return VPageReorderMainGUI.this.selectionPanel.getRotateButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.sameAsSourceRadio)) {
                return VPageReorderMainGUI.this.selectionPanel.getRotateAntiButton();
            }
            if (aComponent.equals(VPageReorderMainGUI.this.chooseAFileRadio)) {
                return VPageReorderMainGUI.this.sameAsSourceRadio;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.destinationFileText)) {
                return VPageReorderMainGUI.this.chooseAFileRadio;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.browseDestButton)) {
                return VPageReorderMainGUI.this.destinationFileText;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.overwriteCheckbox)) {
                if (VPageReorderMainGUI.this.destinationFileText.isEnabled()) {
                    return VPageReorderMainGUI.this.browseDestButton;
                }
                return VPageReorderMainGUI.this.chooseAFileRadio;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.outputCompressedCheck)) {
                return VPageReorderMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.versionCombo)) {
                return VPageReorderMainGUI.this.outputCompressedCheck;
            }
            if (aComponent.equals(VPageReorderMainGUI.this.runButton)) {
                return VPageReorderMainGUI.this.versionCombo;
            }
            return VPageReorderMainGUI.this.selectionPanel.getLoadFileButton();
        }

        public Component getDefaultComponent(Container CycleRootComp) {
            return VPageReorderMainGUI.this.selectionPanel.getLoadFileButton();
        }

        public Component getLastComponent(Container CycleRootComp) {
            return VPageReorderMainGUI.this.runButton;
        }

        public Component getFirstComponent(Container CycleRootComp) {
            return VPageReorderMainGUI.this.selectionPanel.getLoadFileButton();
        }
    }
}

