/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.dto.commands;

import java.io.File;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;

public class EncryptParsedCommand
extends AbstractParsedCommand {
    private static final long serialVersionUID = -4179486767271521110L;
    public static final String F_ARG = "f";
    public static final String UPWD_ARG = "upwd";
    public static final String APWD_ARG = "apwd";
    public static final String P_ARG = "p";
    public static final String O_ARG = "o";
    public static final String ALLOW_ARG = "allow";
    public static final String ETYPE_ARG = "etype";
    public static final String D_ARG = "d";
    public static final String E_PRINT = "print";
    public static final String E_MODIFY = "modify";
    public static final String E_COPY = "copy";
    public static final String E_ANNOTATION = "modifyannotations";
    public static final String E_SCREEN = "screenreaders";
    public static final String E_FILL = "fill";
    public static final String E_ASSEMBLY = "assembly";
    public static final String E_DPRINT = "degradedprinting";
    public static final String E_RC4_40 = "rc4_40";
    public static final String E_RC4_128 = "rc4_128";
    public static final String E_AES_128 = "aes_128";
    private File outputFile;
    private String outputFilesPrefix = "";
    private String ownerPwd = "";
    private String userPwd = "";
    private int permissions;
    private String encryptionType = "rc4_40";
    private PdfFile[] inputFileList;
    private File inputDirectory;

    public EncryptParsedCommand() {
    }

    public EncryptParsedCommand(File outputFile, String outputFilesPrefix, String ownerPwd, String userPwd, int permissions, String encryptionType, PdfFile[] inputFileList, File inputDirectory) {
        this.outputFile = outputFile;
        this.outputFilesPrefix = outputFilesPrefix;
        this.ownerPwd = ownerPwd;
        this.userPwd = userPwd;
        this.permissions = permissions;
        this.encryptionType = encryptionType;
        this.inputFileList = inputFileList;
        this.inputDirectory = inputDirectory;
    }

    public EncryptParsedCommand(File outputFile, String outputFilesPrefix, String ownerPwd, String userPwd, int permissions, String encryptionType, PdfFile[] inputFileList, File inputDirectory, boolean overwrite, boolean compress, File logFile, char outputPdfVersion) {
        super(overwrite, compress, logFile, outputPdfVersion);
        this.outputFile = outputFile;
        this.outputFilesPrefix = outputFilesPrefix;
        this.ownerPwd = ownerPwd;
        this.userPwd = userPwd;
        this.permissions = permissions;
        this.encryptionType = encryptionType;
        this.inputFileList = inputFileList;
        this.inputDirectory = inputDirectory;
    }

    public EncryptParsedCommand(File outputFile, String outputFilesPrefix, String ownerPwd, String userPwd, int permissions, String encryptionType, PdfFile[] inputFileList, File inputDirectory, boolean overwrite, boolean compress, char outputPdfVersion) {
        super(overwrite, compress, outputPdfVersion);
        this.outputFile = outputFile;
        this.outputFilesPrefix = outputFilesPrefix;
        this.ownerPwd = ownerPwd;
        this.userPwd = userPwd;
        this.permissions = permissions;
        this.encryptionType = encryptionType;
        this.inputFileList = inputFileList;
        this.inputDirectory = inputDirectory;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public String getOutputFilesPrefix() {
        return this.outputFilesPrefix;
    }

    public void setOutputFilesPrefix(String outputFilesPrefix) {
        this.outputFilesPrefix = outputFilesPrefix;
    }

    public String getOwnerPwd() {
        return this.ownerPwd;
    }

    public void setOwnerPwd(String ownerPwd) {
        this.ownerPwd = ownerPwd;
    }

    public String getUserPwd() {
        return this.userPwd;
    }

    public void setUserPwd(String userPwd) {
        this.userPwd = userPwd;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public void setPermissions(int permissions) {
        this.permissions = permissions;
    }

    public String getEncryptionType() {
        return this.encryptionType;
    }

    public void setEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
    }

    public PdfFile[] getInputFileList() {
        return this.inputFileList;
    }

    public void setInputFileList(PdfFile[] inputFileList) {
        this.inputFileList = inputFileList;
    }

    public String getCommand() {
        return "encrypt";
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer();
        retVal.append(super.toString());
        retVal.append(this.outputFile == null ? "" : "[outputDir=" + this.outputFile.getAbsolutePath() + "]");
        if (this.inputFileList != null) {
            for (int i = 0; i < this.inputFileList.length; ++i) {
                retVal.append(this.inputFileList[i] == null ? "" : "[inputFileList[" + i + "]=" + this.inputFileList[i].getFile().getAbsolutePath() + "]");
            }
        }
        retVal.append("[pageSelection=" + this.outputFilesPrefix + "]");
        retVal.append("[ownerPwd=" + this.ownerPwd + "]");
        retVal.append("[userPwd=" + this.userPwd + "]");
        retVal.append("[encryptionType=" + this.encryptionType + "]");
        retVal.append("[permissions=" + this.permissions + "]");
        retVal.append(this.inputDirectory == null ? "" : "[inputDirectory=" + this.inputDirectory.getAbsolutePath() + "]");
        retVal.append("[command=" + this.getCommand() + "]");
        return retVal.toString();
    }

    public File getInputDirectory() {
        return this.inputDirectory;
    }

    public void setInputDirectory(File inputDirectory) {
        this.inputDirectory = inputDirectory;
    }
}

