/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.writers;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfReader;
import java.io.OutputStream;
import java.util.List;
import org.pdfsam.console.business.pdf.writers.interfaces.PdfConcatenator;

public class PdfSimpleConcatenator
implements PdfConcatenator {
    private PdfCopy writer;

    public PdfSimpleConcatenator(Document document, OutputStream os) throws DocumentException {
        this.writer = new PdfCopy(document, os);
    }

    public PdfSimpleConcatenator(Document document, OutputStream os, boolean compressed) throws DocumentException {
        this(document, os);
        if (compressed) {
            this.writer.setFullCompression();
            this.writer.setCompressionLevel(9);
        }
    }

    public void addDocument(PdfReader reader, String ranges) throws Exception {
        if (reader == null) {
            throw new DocumentException("Reader is null");
        }
        reader.selectPages(ranges);
        this.addDocument(reader);
    }

    public void addDocument(PdfReader reader) throws Exception {
        if (reader != null) {
            int numPages = reader.getNumberOfPages();
            for (int count = 1; count <= numPages; ++count) {
                this.writer.addPage(this.writer.getImportedPage(reader, count));
            }
        } else {
            throw new DocumentException("Reader is null");
        }
    }

    public void freeReader(PdfReader reader) throws Exception {
        this.writer.freeReader(reader);
    }

    public void setOutlines(List outlines) {
        this.writer.setOutlines(outlines);
    }

    public void close() {
        this.writer.close();
    }

    public void setPdfVersion(char pdfVersion) {
        this.writer.setPdfVersion(pdfVersion);
    }
}

