/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.logging.DelegatingHandler;
import de.intarsys.tools.logging.IHandlerFactory;
import de.intarsys.tools.logging.ThreadFilter;
import java.io.IOException;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogHandlerSwitcher {
    private Handler handler;
    private boolean handlerPerAttach = false;
    private IHandlerFactory handlerFactory;
    private String loggerName = "";
    private Handler handlerAttached = new DelegatingHandler(){

        @Override
        public Handler getBaseHandler() {
            return LogHandlerSwitcher.this.handler;
        }

        @Override
        public Filter getFilter() {
            return LogHandlerSwitcher.this.filter;
        }

        @Override
        public void publish(LogRecord logRecord) {
            LogHandlerSwitcher.this.basicPublishAttached(logRecord);
        }
    };
    private Handler handlerDetached = new DelegatingHandler(){

        @Override
        public Handler getBaseHandler() {
            return LogHandlerSwitcher.this.handler;
        }

        @Override
        public void publish(LogRecord logRecord) {
            LogHandlerSwitcher.this.basicPublishDetached(logRecord);
        }
    };
    private ThreadFilter filter = new ThreadFilter(false);
    private int attachCounter = 0;

    public void attach() {
        this.getFilter().activate();
        if (this.attachCounter++ == 0) {
            if (this.isHandlerPerAttach() || this.handler == null) {
                this.switchLog();
            }
            Logger.getLogger(this.getLoggerName()).addHandler(this.getHandlerAttached());
        }
    }

    protected void basicPublishAttached(LogRecord logRecord) {
        if (this.handler == null) {
            return;
        }
        if (this.getFilter().isActive()) {
            this.handler.publish(logRecord);
        }
    }

    protected void basicPublishDetached(LogRecord logRecord) {
        if (this.handler == null) {
            return;
        }
        if (!this.getFilter().isActive()) {
            this.handler.publish(logRecord);
        }
    }

    protected Handler createLogHandler() throws IOException {
        if (this.handlerFactory == null) {
            return null;
        }
        return this.handlerFactory.createLogHandler();
    }

    public void destroy() {
        if (this.handler != null) {
            this.handler.close();
            this.handler = null;
        }
    }

    public void detach() {
        this.getFilter().deactivate();
        if (--this.attachCounter == 0) {
            Logger.getLogger(this.getLoggerName()).removeHandler(this.getHandlerAttached());
        }
    }

    protected ThreadFilter getFilter() {
        return this.filter;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public Handler getHandlerAttached() {
        return this.handlerAttached;
    }

    public Handler getHandlerDetached() {
        return this.handlerDetached;
    }

    public IHandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void init() throws IOException {
        if (!this.isHandlerPerAttach()) {
            this.switchLog();
        }
    }

    public boolean isHandlerPerAttach() {
        return this.handlerPerAttach;
    }

    public void setHandlerFactory(IHandlerFactory iHandlerFactory) {
        this.handlerFactory = iHandlerFactory;
    }

    public void setHandlerPerAttach(boolean bl) {
        this.handlerPerAttach = bl;
    }

    public void setLoggerName(String string) {
        this.loggerName = string;
    }

    protected void switchLog() {
        if (this.handler != null) {
            this.handler.close();
        }
        try {
            this.handler = this.createLogHandler();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

