/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.dom.ElementConfigurationException;
import de.intarsys.tools.monitor.AbstractMonitor;
import de.intarsys.tools.monitor.CompositeMonitorTrace;
import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.ITrace;
import de.intarsys.tools.monitor.MonitorFactory;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class CompositeMonitor
extends AbstractMonitor {
    private IMonitor[] children = new IMonitor[0];

    public CompositeMonitor() {
    }

    public CompositeMonitor(String string) {
        super(string);
    }

    public void addMonitor(IMonitor iMonitor) {
        int n = 0;
        n = this.children == null ? 1 : this.children.length + 1;
        IMonitor[] iMonitorArray = new IMonitor[n];
        System.arraycopy(this.children, 0, iMonitorArray, 0, n - 1);
        iMonitorArray[n - 1] = iMonitor;
        this.children = iMonitorArray;
    }

    @Override
    public void configure(Element element) throws ElementConfigurationException {
        super.configure(element);
        try {
            this.children = MonitorFactory.createMonitors(element);
        }
        catch (ObjectCreationException objectCreationException) {
            throw new ElementConfigurationException(objectCreationException);
        }
    }

    @Override
    protected CompositeMonitorTrace createMonitorTrace() {
        ITrace[] iTraceArray = new ITrace[this.getChildren().length];
        int n = 0;
        while (n < this.children.length) {
            iTraceArray[n] = this.children[n].getCurrentTrace();
            ++n;
        }
        CompositeMonitorTrace compositeMonitorTrace = new CompositeMonitorTrace(this, iTraceArray);
        return compositeMonitorTrace;
    }

    public IMonitor[] getChildren() {
        return this.children;
    }

    @Override
    public Map getData() {
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < this.children.length) {
            Map map = this.children[n].getData();
            for (Map.Entry entry : map.entrySet()) {
                hashMap.put(this.children[n].getName() + "." + entry.getKey(), entry.getValue());
            }
            ++n;
        }
        return hashMap;
    }

    @Override
    public Map getFormattedData() {
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < this.children.length) {
            Map map = this.children[n].getFormattedData();
            for (Map.Entry entry : map.entrySet()) {
                hashMap.put(this.children[n].getName() + "." + entry.getKey(), entry.getValue());
            }
            ++n;
        }
        return hashMap;
    }

    @Override
    public void reset() {
        super.reset();
        int n = 0;
        while (n < this.children.length) {
            this.children[n].reset();
            ++n;
        }
    }

    public String toString() {
        return "Composite Monitor " + this.getName();
    }
}

