/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;

final class P11RSAKeyFactory
extends P11KeyFactory {
    P11RSAKeyFactory(Token token, String algorithm) {
        super(token, algorithm);
    }

    @Override
    PublicKey implTranslatePublicKey(PublicKey key) throws InvalidKeyException {
        try {
            if (key instanceof RSAPublicKey) {
                RSAPublicKey rsaKey = (RSAPublicKey)key;
                return this.generatePublic(rsaKey.getModulus(), rsaKey.getPublicExponent());
            }
            if ("X.509".equals(key.getFormat())) {
                byte[] encoded = key.getEncoded();
                key = new RSAPublicKeyImpl(encoded);
                return this.implTranslatePublicKey(key);
            }
            throw new InvalidKeyException("PublicKey must be instance of RSAPublicKey or have X.509 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create RSA public key", e);
        }
    }

    @Override
    PrivateKey implTranslatePrivateKey(PrivateKey key) throws InvalidKeyException {
        try {
            if (key instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rsaKey = (RSAPrivateCrtKey)key;
                return this.generatePrivate(rsaKey.getModulus(), rsaKey.getPublicExponent(), rsaKey.getPrivateExponent(), rsaKey.getPrimeP(), rsaKey.getPrimeQ(), rsaKey.getPrimeExponentP(), rsaKey.getPrimeExponentQ(), rsaKey.getCrtCoefficient());
            }
            if (key instanceof RSAPrivateKey) {
                RSAPrivateKey rsaKey = (RSAPrivateKey)key;
                return this.generatePrivate(rsaKey.getModulus(), rsaKey.getPrivateExponent());
            }
            if ("PKCS#8".equals(key.getFormat())) {
                byte[] encoded = key.getEncoded();
                key = RSAPrivateCrtKeyImpl.newKey((byte[])encoded);
                return this.implTranslatePrivateKey(key);
            }
            throw new InvalidKeyException("Private key must be instance of RSAPrivate(Crt)Key or have PKCS#8 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create RSA private key", e);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                byte[] encoded = ((X509EncodedKeySpec)keySpec).getEncoded();
                RSAPublicKeyImpl key = new RSAPublicKeyImpl(encoded);
                return this.implTranslatePublicKey(key);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Could not create RSA public key", e);
            }
        }
        if (!(keySpec instanceof RSAPublicKeySpec)) {
            throw new InvalidKeySpecException("Only RSAPublicKeySpec and X509EncodedKeySpec supported for RSA public keys");
        }
        try {
            RSAPublicKeySpec rs = (RSAPublicKeySpec)keySpec;
            return this.generatePublic(rs.getModulus(), rs.getPublicExponent());
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeySpecException("Could not create RSA public key", e);
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Could not create RSA public key", e);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                byte[] encoded = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                RSAPrivateKey key = RSAPrivateCrtKeyImpl.newKey((byte[])encoded);
                return this.implTranslatePrivateKey(key);
            }
            catch (GeneralSecurityException e) {
                throw new InvalidKeySpecException("Could not create RSA private key", e);
            }
        }
        try {
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rs = (RSAPrivateCrtKeySpec)keySpec;
                return this.generatePrivate(rs.getModulus(), rs.getPublicExponent(), rs.getPrivateExponent(), rs.getPrimeP(), rs.getPrimeQ(), rs.getPrimeExponentP(), rs.getPrimeExponentQ(), rs.getCrtCoefficient());
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec rs = (RSAPrivateKeySpec)keySpec;
                return this.generatePrivate(rs.getModulus(), rs.getPrivateExponent());
            }
            throw new InvalidKeySpecException("Only RSAPrivate(Crt)KeySpec and PKCS8EncodedKeySpec supported for RSA private keys");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeySpecException("Could not create RSA private key", e);
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Could not create RSA private key", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey generatePublic(BigInteger n, BigInteger e) throws PKCS11Exception, InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(n.bitLength(), e, -1, 65536);
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(256L, 0L), new CK_ATTRIBUTE(288L, n), new CK_ATTRIBUTE(290L, e)};
        attributes = this.token.getAttributes("import", 2L, 0L, attributes);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long keyID = this.token.p11.C_CreateObject(session.id(), attributes);
            PublicKey publicKey = P11Key.publicKey(session, keyID, "RSA", n.bitLength(), attributes);
            return publicKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey generatePrivate(BigInteger n, BigInteger d) throws PKCS11Exception, InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(n.bitLength(), null, -1, 65536);
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 0L), new CK_ATTRIBUTE(288L, n), new CK_ATTRIBUTE(291L, d)};
        attributes = this.token.getAttributes("import", 3L, 0L, attributes);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long keyID = this.token.p11.C_CreateObject(session.id(), attributes);
            PrivateKey privateKey = P11Key.privateKey(session, keyID, "RSA", n.bitLength(), attributes);
            return privateKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey generatePrivate(BigInteger n, BigInteger e, BigInteger d, BigInteger p, BigInteger q, BigInteger pe, BigInteger qe, BigInteger coeff) throws PKCS11Exception, InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(n.bitLength(), e, -1, 65536);
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 0L), new CK_ATTRIBUTE(288L, n), new CK_ATTRIBUTE(290L, e), new CK_ATTRIBUTE(291L, d), new CK_ATTRIBUTE(292L, p), new CK_ATTRIBUTE(293L, q), new CK_ATTRIBUTE(294L, pe), new CK_ATTRIBUTE(295L, qe), new CK_ATTRIBUTE(296L, coeff)};
        attributes = this.token.getAttributes("import", 3L, 0L, attributes);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long keyID = this.token.p11.C_CreateObject(session.id(), attributes);
            PrivateKey privateKey = P11Key.privateKey(session, keyID, "RSA", n.bitLength(), attributes);
            return privateKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    @Override
    KeySpec implGetPublicKeySpec(P11Key key, Class keySpec, Session[] session) throws PKCS11Exception, InvalidKeySpecException {
        if (RSAPublicKeySpec.class.isAssignableFrom(keySpec)) {
            session[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(290L)};
            this.token.p11.C_GetAttributeValue(session[0].id(), key.keyID, attributes);
            RSAPublicKeySpec spec = new RSAPublicKeySpec(attributes[0].getBigInteger(), attributes[1].getBigInteger());
            return spec;
        }
        throw new InvalidKeySpecException("Only RSAPublicKeySpec and X509EncodedKeySpec supported for RSA public keys");
    }

    @Override
    KeySpec implGetPrivateKeySpec(P11Key key, Class keySpec, Session[] session) throws PKCS11Exception, InvalidKeySpecException {
        if (RSAPrivateCrtKeySpec.class.isAssignableFrom(keySpec)) {
            session[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(290L), new CK_ATTRIBUTE(291L), new CK_ATTRIBUTE(292L), new CK_ATTRIBUTE(293L), new CK_ATTRIBUTE(294L), new CK_ATTRIBUTE(295L), new CK_ATTRIBUTE(296L)};
            this.token.p11.C_GetAttributeValue(session[0].id(), key.keyID, attributes);
            RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(attributes[0].getBigInteger(), attributes[1].getBigInteger(), attributes[2].getBigInteger(), attributes[3].getBigInteger(), attributes[4].getBigInteger(), attributes[5].getBigInteger(), attributes[6].getBigInteger(), attributes[7].getBigInteger());
            return spec;
        }
        if (RSAPrivateKeySpec.class.isAssignableFrom(keySpec)) {
            session[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(291L)};
            this.token.p11.C_GetAttributeValue(session[0].id(), key.keyID, attributes);
            RSAPrivateKeySpec spec = new RSAPrivateKeySpec(attributes[0].getBigInteger(), attributes[1].getBigInteger());
            return spec;
        }
        throw new InvalidKeySpecException("Only RSAPrivate(Crt)KeySpec and PKCS8EncodedKeySpec supported for RSA private keys");
    }

    @Override
    KeyFactory implGetSoftwareFactory() throws GeneralSecurityException {
        return KeyFactory.getInstance("RSA", P11Util.getSunRsaSignProvider());
    }
}

