/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.deps;

import net.adaptivebox.deps.behavior.AbsGTBehavior;
import net.adaptivebox.deps.behavior.DEGTBehavior;
import net.adaptivebox.deps.behavior.PSGTBehavior;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.ILibEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;
import net.adaptivebox.space.BasicPoint;

public class DEPSAgent
implements ILibEngine {
    private ProblemEncoder problemEncoder;
    private IGoodnessCompareEngine qualityComparator;
    private SearchPoint trailPoint;
    private AbsGTBehavior selectGTBehavior;
    private BasicPoint pold_t;
    private BasicPoint pcurrent_t;
    private SearchPoint pbest_t;
    private DEGTBehavior deGTBehavior;
    private PSGTBehavior psGTBehavior;
    public double switchP = 0.5;

    public void setLibrary(Library library) {
        this.deGTBehavior.setLibrary(library);
        this.psGTBehavior.setLibrary(library);
    }

    public void setProblemEncoder(ProblemEncoder problemEncoder) {
        this.problemEncoder = problemEncoder;
        this.trailPoint = this.problemEncoder.getFreshSearchPoint();
        this.pold_t = this.problemEncoder.getFreshSearchPoint();
        this.pcurrent_t = this.problemEncoder.getFreshSearchPoint();
    }

    public void setSpecComparator(IGoodnessCompareEngine iGoodnessCompareEngine) {
        this.qualityComparator = iGoodnessCompareEngine;
    }

    public void setPbest(SearchPoint searchPoint) {
        this.pbest_t = searchPoint;
    }

    private AbsGTBehavior getGTBehavior() {
        if (Math.random() < this.switchP) {
            return this.deGTBehavior;
        }
        return this.psGTBehavior;
    }

    public void setGTBehavior(AbsGTBehavior absGTBehavior) {
        if (absGTBehavior instanceof DEGTBehavior) {
            this.deGTBehavior = (DEGTBehavior)absGTBehavior;
            this.deGTBehavior.setPbest(this.pbest_t);
            return;
        }
        if (absGTBehavior instanceof PSGTBehavior) {
            this.psGTBehavior = (PSGTBehavior)absGTBehavior;
            this.psGTBehavior.setMemPoints(this.pbest_t, this.pcurrent_t, this.pold_t);
            return;
        }
    }

    public void generatePoint() {
        this.selectGTBehavior = this.getGTBehavior();
        this.selectGTBehavior.generateBehavior(this.trailPoint, this.problemEncoder);
        this.problemEncoder.evaluate(this.trailPoint);
    }

    public void learn() {
        this.selectGTBehavior.testBehavior(this.trailPoint, this.qualityComparator);
    }

    public SearchPoint getMGState() {
        return this.trailPoint;
    }
}

