/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.deps.behavior;

import net.adaptivebox.deps.behavior.AbsGTBehavior;
import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.ILibEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;

public class DEGTBehavior
extends AbsGTBehavior
implements ILibEngine {
    private final int DVNum = 2;
    public double FACTOR = 0.5;
    public double CR = 0.9;
    private SearchPoint pbest_t;

    public void setPbest(SearchPoint searchPoint) {
        this.pbest_t = searchPoint;
    }

    public void generateBehavior(SearchPoint searchPoint, ProblemEncoder problemEncoder) {
        SearchPoint searchPoint2 = this.socialLib.getGbest();
        SearchPoint[] searchPointArray = this.getReferPoints();
        int n = problemEncoder.getDesignSpace().getDimension();
        int n2 = RandomGenerator.intRangeRandom(0, n - 1);
        for (int i = 0; i < n; ++i) {
            if (Math.random() < this.CR || i == n - 1) {
                double d = 0.0;
                for (int j = 0; j < searchPointArray.length; ++j) {
                    d += Math.pow(-1.0, j % 2) * searchPointArray[j].getLocation()[n2];
                }
                searchPoint.getLocation()[n2] = searchPoint2.getLocation()[n2] + this.FACTOR * d;
            } else {
                searchPoint.getLocation()[n2] = this.pbest_t.getLocation()[n2];
            }
            n2 = (n2 + 1) % n;
        }
    }

    public void testBehavior(SearchPoint searchPoint, IGoodnessCompareEngine iGoodnessCompareEngine) {
        Library.replace(iGoodnessCompareEngine, searchPoint, this.pbest_t);
    }

    private SearchPoint[] getReferPoints() {
        SearchPoint[] searchPointArray = new SearchPoint[4];
        for (int i = 0; i < searchPointArray.length; ++i) {
            searchPointArray[i] = this.socialLib.getSelectedPoint(RandomGenerator.intRangeRandom(0, this.socialLib.getPopSize() - 1));
        }
        return searchPointArray;
    }
}

