/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.ExecutionEvent;
import com.oracle.truffle.api.debug.LineBreakpointFactory;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.debug.TagBreakpointFactory;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.instrument.Instrumenter;
import com.oracle.truffle.api.instrument.KillException;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.StandardAfterInstrumentListener;
import com.oracle.truffle.api.instrument.StandardBeforeInstrumentListener;
import com.oracle.truffle.api.instrument.StandardSyntaxTag;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.instrument.TagInstrument;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Debugger {
    private static final boolean TRACE = false;
    private static final String TRACE_PREFIX = "Debugger: ";
    private static final PrintStream OUT = System.out;
    private static final SyntaxTag STEPPING_TAG = StandardSyntaxTag.STATEMENT;
    private static final SyntaxTag CALL_TAG = StandardSyntaxTag.CALL;
    private final Instrumenter instrumenter;
    private final Object vm;
    private Source lastSource;
    private final BreakpointCallback breakpointCallback;
    private final WarningLog warningLog;
    private final LineBreakpointFactory lineBreaks;
    private final TagBreakpointFactory tagBreaks;
    private DebugExecutionContext debugContext;
    static final AccessorDebug ACCESSOR = new AccessorDebug();

    private static void trace(String format, Object ... args) {
    }

    Debugger(Object vm, Instrumenter instrumenter) {
        this.vm = vm;
        this.instrumenter = instrumenter;
        Source.setFileCaching(true);
        this.debugContext = new DebugExecutionContext(null, null, 0);
        this.debugContext.setStrategy(0, new Continue());
        this.debugContext.contextTrace("START EXEC DEFAULT", new Object[0]);
        this.breakpointCallback = new BreakpointCallback(){

            @Override
            @CompilerDirectives.TruffleBoundary
            public void haltedAt(Node astNode, MaterializedFrame mFrame, String haltReason) {
                Debugger.this.debugContext.halt(astNode, mFrame, true, haltReason);
            }
        };
        this.warningLog = new WarningLog(){

            @Override
            public void addWarning(String warning) {
                assert (Debugger.this.debugContext != null);
                Debugger.this.debugContext.logWarning(warning);
            }
        };
        this.lineBreaks = new LineBreakpointFactory(this, this.breakpointCallback, this.warningLog);
        this.tagBreaks = new TagBreakpointFactory(this, this.breakpointCallback, this.warningLog);
    }

    @CompilerDirectives.TruffleBoundary
    public Breakpoint setLineBreakpoint(int ignoreCount, LineLocation lineLocation, boolean oneShot) throws IOException {
        return this.lineBreaks.create(ignoreCount, lineLocation, oneShot);
    }

    @CompilerDirectives.TruffleBoundary
    public Breakpoint setTagBreakpoint(int ignoreCount, SyntaxTag tag, boolean oneShot) throws IOException {
        return this.tagBreaks.create(ignoreCount, tag, oneShot);
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<Breakpoint> getBreakpoints() {
        ArrayList<Breakpoint> result = new ArrayList<Breakpoint>();
        result.addAll(this.lineBreaks.getAll());
        result.addAll(this.tagBreaks.getAll());
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    void prepareContinue(int depth) {
        this.debugContext.setStrategy(depth, new Continue());
    }

    @CompilerDirectives.TruffleBoundary
    void prepareStepInto(int stepCount) {
        if (stepCount <= 0) {
            throw new IllegalArgumentException();
        }
        this.debugContext.setStrategy(new StepInto(stepCount));
    }

    @CompilerDirectives.TruffleBoundary
    void prepareStepOut() {
        this.debugContext.setStrategy(new StepOut());
    }

    @CompilerDirectives.TruffleBoundary
    void prepareStepOver(int stepCount) {
        if (stepCount <= 0) {
            throw new IllegalArgumentException();
        }
        this.debugContext.setStrategy(new StepOver(stepCount));
    }

    Instrumenter getInstrumenter() {
        return this.instrumenter;
    }

    @CompilerDirectives.TruffleBoundary
    private static int currentStackDepth() {
        final int[] count = new int[]{0};
        Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<Void>(){

            @Override
            public Void visitFrame(FrameInstance frameInstance) {
                count[0] = count[0] + 1;
                return null;
            }
        });
        return count[0] == 0 ? 0 : count[0] + 1;
    }

    void executionStarted(int depth, Source source) {
        Source execSource = source;
        if (execSource == null) {
            execSource = this.lastSource;
        } else {
            this.lastSource = execSource;
        }
        this.debugContext = new DebugExecutionContext(execSource, this.debugContext, depth);
        this.prepareContinue(depth);
        this.debugContext.contextTrace("START EXEC ", new Object[0]);
        ACCESSOR.dispatchEvent(this.vm, new ExecutionEvent(this));
    }

    void executionEnded() {
        this.lineBreaks.disposeOneShots();
        this.tagBreaks.disposeOneShots();
        this.debugContext.clearStrategy();
        this.debugContext.contextTrace("END EXEC ", new Object[0]);
        this.debugContext = this.debugContext.predecessor;
    }

    Object evalInContext(SuspendedEvent ev, String code, FrameInstance frameInstance) throws IOException {
        if (frameInstance == null) {
            return ACCESSOR.evalInContext(this.vm, ev, code, this.debugContext.haltedNode, this.debugContext.haltedFrame);
        }
        return ACCESSOR.evalInContext(this.vm, ev, code, frameInstance.getCallNode(), frameInstance.getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize());
    }

    static final class AccessorDebug
    extends Accessor {
        AccessorDebug() {
        }

        @Override
        protected Closeable executionStart(Object vm, int currentDepth, final Debugger debugger, Source s) {
            debugger.executionStarted(currentDepth, s);
            return new Closeable(){

                @Override
                public void close() throws IOException {
                    debugger.executionEnded();
                }
            };
        }

        @Override
        protected Debugger createDebugger(Object vm, Instrumenter instrumenter) {
            return new Debugger(vm, instrumenter);
        }

        @Override
        protected Class<? extends TruffleLanguage> findLanguage(Probe probe) {
            return super.findLanguage(probe);
        }

        @Override
        protected void dispatchEvent(Object vm, Object event) {
            super.dispatchEvent(vm, event);
        }

        @Override
        protected Object evalInContext(Object vm, SuspendedEvent ev, String code, Node node, MaterializedFrame frame) throws IOException {
            return super.evalInContext(vm, ev, code, node, frame);
        }
    }

    private final class DebugExecutionContext {
        private final DebugExecutionContext predecessor;
        private final int level;
        private final Source source;
        private final int contextStackBase;
        private final List<String> warnings = new ArrayList<String>();
        private boolean running;
        private StepStrategy strategy;
        private Node haltedNode;
        private MaterializedFrame haltedFrame;
        private List<FrameInstance> contextStack;

        private DebugExecutionContext(Source executionSource, DebugExecutionContext previousContext) {
            this(executionSource, previousContext, -1);
        }

        private DebugExecutionContext(Source executionSource, DebugExecutionContext previousContext, int depth) {
            this.source = executionSource;
            this.predecessor = previousContext;
            this.level = previousContext == null ? 0 : previousContext.level + 1;
            this.contextStackBase = depth == -1 ? Debugger.currentStackDepth() : depth;
            this.running = true;
            this.contextTrace("NEW CONTEXT", new Object[0]);
        }

        void setStrategy(StepStrategy stepStrategy) {
            this.setStrategy(Debugger.currentStackDepth(), stepStrategy);
        }

        void setStrategy(int depth, StepStrategy stepStrategy) {
            if (this.strategy == null) {
                this.strategy = stepStrategy;
                this.strategy.enable(this, depth);
            } else {
                this.strategy.disable();
                this.strategy = stepStrategy;
                this.strategy.enable(this, Debugger.currentStackDepth());
                this.contextTrace("SWITCH MODE %s-->%s", this.strategy.getName(), stepStrategy.getName());
            }
        }

        void clearStrategy() {
            if (this.strategy != null) {
                StepStrategy oldStrategy = this.strategy;
                this.strategy.disable();
                this.strategy = null;
                this.contextTrace("CLEAR MODE %s--><none>", oldStrategy.getName());
            }
        }

        @CompilerDirectives.TruffleBoundary
        void halt(Node astNode, MaterializedFrame mFrame, boolean before, String haltReason) {
            assert (this.running);
            assert (this.haltedNode == null);
            assert (this.haltedFrame == null);
            this.haltedNode = astNode;
            this.haltedFrame = mFrame;
            this.running = false;
            this.clearStrategy();
            Debugger.this.lineBreaks.disposeOneShots();
            final int contextStackDepth = Debugger.currentStackDepth() - this.contextStackBase + 1;
            ArrayList<String> recentWarnings = new ArrayList<String>(this.warnings);
            this.warnings.clear();
            final ArrayList frames = new ArrayList();
            Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<FrameInstance>(){
                int stackIndex = 1;

                @Override
                public FrameInstance visitFrame(FrameInstance frameInstance) {
                    if (this.stackIndex < contextStackDepth) {
                        SourceSection sourceSection;
                        Node callNode = frameInstance.getCallNode();
                        if (callNode != null && (sourceSection = callNode.getEncapsulatingSourceSection()) != null && !sourceSection.getIdentifier().equals("<unknown>")) {
                            frames.add(frameInstance);
                        }
                        ++this.stackIndex;
                        return null;
                    }
                    return frameInstance;
                }
            });
            this.contextStack = Collections.unmodifiableList(frames);
            try {
                ACCESSOR.dispatchEvent(Debugger.this.vm, new SuspendedEvent(Debugger.this, this.haltedNode, this.haltedFrame, this.contextStack, recentWarnings));
                this.running = true;
            }
            catch (KillException e) {
                this.contextTrace("KILL", new Object[0]);
                throw e;
            }
            finally {
                this.haltedNode = null;
                this.haltedFrame = null;
            }
        }

        void logWarning(String warning) {
            this.warnings.add(warning);
        }

        void contextTrace(String format, Object ... args) {
        }
    }

    private final class StepOverNested
    extends StepStrategy {
        private TagInstrument beforeTagInstrument;
        private int unfinishedStepCount;
        private final int startStackDepth;

        StepOverNested(int stepCount, int startStackDepth) {
            this.unfinishedStepCount = stepCount;
            this.startStackDepth = startStackDepth;
        }

        @Override
        protected void setStrategy(final int stackDepth) {
            this.beforeTagInstrument = Debugger.this.instrumenter.attach(STEPPING_TAG, new StandardBeforeInstrumentListener(){

                @Override
                @CompilerDirectives.TruffleBoundary
                public void onEnter(Probe probe, Node node, VirtualFrame vFrame) {
                    int currentStackDepth = Debugger.currentStackDepth();
                    if (currentStackDepth <= StepOverNested.this.startStackDepth) {
                        --StepOverNested.this.unfinishedStepCount;
                        StepOverNested.this.strategyTrace("HALT AFTER", "unfinished steps=%d stackDepth start=%d current=%d", StepOverNested.this.unfinishedStepCount, stackDepth, currentStackDepth);
                        if (StepOverNested.this.unfinishedStepCount <= 0) {
                            StepOverNested.this.halt(node, vFrame.materialize(), false);
                        }
                        StepOverNested.this.strategyTrace("RESUME BEFORE", "", new Object[0]);
                    }
                }
            }, "Debuger StepOverNested");
        }

        @Override
        protected void unsetStrategy() {
            this.beforeTagInstrument.dispose();
        }
    }

    private final class StepOver
    extends StepStrategy {
        private TagInstrument beforeTagInstrument;
        private TagInstrument afterTagInstrument;
        private int unfinishedStepCount;

        StepOver(int stepCount) {
            this.unfinishedStepCount = stepCount;
        }

        @Override
        protected void setStrategy(final int stackDepth) {
            this.beforeTagInstrument = Debugger.this.instrumenter.attach(STEPPING_TAG, new StandardBeforeInstrumentListener(){

                @Override
                @CompilerDirectives.TruffleBoundary
                public void onEnter(Probe probe, Node node, VirtualFrame vFrame) {
                    int currentStackDepth = Debugger.currentStackDepth();
                    if (currentStackDepth <= stackDepth) {
                        --StepOver.this.unfinishedStepCount;
                        if (StepOver.this.unfinishedStepCount <= 0) {
                            StepOver.this.halt(node, vFrame.materialize(), true);
                        }
                    } else {
                        StepOver.this.strategyTrace("STEP INTO", "unfinished steps=%d stackDepth start=%d current=%d", StepOver.this.unfinishedStepCount, stackDepth, currentStackDepth);
                        StepOver.this.replaceStrategy(new StepOverNested(StepOver.this.unfinishedStepCount, stackDepth));
                    }
                    StepOver.this.strategyTrace("RESUME BEFORE", "", new Object[0]);
                }
            }, "Debugger StepOver");
            this.afterTagInstrument = Debugger.this.instrumenter.attach(CALL_TAG, new StandardAfterInstrumentListener(){

                @Override
                public void onReturnVoid(Probe probe, Node node, VirtualFrame vFrame) {
                    this.doHalt(node, vFrame.materialize());
                }

                @Override
                public void onReturnValue(Probe probe, Node node, VirtualFrame vFrame, Object result) {
                    this.doHalt(node, vFrame.materialize());
                }

                @Override
                public void onReturnExceptional(Probe probe, Node node, VirtualFrame vFrame, Throwable exception) {
                    this.doHalt(node, vFrame.materialize());
                }

                @CompilerDirectives.TruffleBoundary
                private void doHalt(Node node, MaterializedFrame mFrame) {
                    int currentStackDepth = Debugger.currentStackDepth();
                    if (currentStackDepth < stackDepth) {
                        --StepOver.this.unfinishedStepCount;
                        StepOver.this.strategyTrace("HALT AFTER", "unfinished steps=%d stackDepth: start=%d current=%d", StepOver.this.unfinishedStepCount, stackDepth, currentStackDepth);
                        if (StepOver.this.unfinishedStepCount <= 0) {
                            StepOver.this.halt(node, mFrame, false);
                        }
                        StepOver.this.strategyTrace("RESUME AFTER", "", new Object[0]);
                    }
                }
            }, "Debugger StepOver");
        }

        @Override
        protected void unsetStrategy() {
            this.beforeTagInstrument.dispose();
            this.afterTagInstrument.dispose();
        }
    }

    private final class StepOut
    extends StepStrategy {
        private TagInstrument afterTagInstrument;

        private StepOut() {
        }

        @Override
        protected void setStrategy(final int stackDepth) {
            this.afterTagInstrument = Debugger.this.instrumenter.attach(CALL_TAG, new StandardAfterInstrumentListener(){

                @Override
                public void onReturnVoid(Probe probe, Node node, VirtualFrame vFrame) {
                    this.doHalt(node, vFrame.materialize());
                }

                @Override
                public void onReturnValue(Probe probe, Node node, VirtualFrame vFrame, Object result) {
                    this.doHalt(node, vFrame.materialize());
                }

                @Override
                public void onReturnExceptional(Probe probe, Node node, VirtualFrame vFrame, Throwable exception) {
                    this.doHalt(node, vFrame.materialize());
                }

                @CompilerDirectives.TruffleBoundary
                private void doHalt(Node node, MaterializedFrame mFrame) {
                    int currentStackDepth = Debugger.currentStackDepth();
                    StepOut.this.strategyTrace("HALT AFTER", "stackDepth: start=%d current=%d", stackDepth, currentStackDepth);
                    if (currentStackDepth < stackDepth) {
                        StepOut.this.halt(node, mFrame, false);
                    }
                    StepOut.this.strategyTrace("RESUME AFTER", "", new Object[0]);
                }
            }, "Debugger StepOut");
        }

        @Override
        protected void unsetStrategy() {
            this.afterTagInstrument.dispose();
        }
    }

    private final class StepInto
    extends StepStrategy {
        private TagInstrument beforeTagInstrument;
        private TagInstrument afterTagInstrument;
        private int unfinishedStepCount;

        StepInto(int stepCount) {
            this.unfinishedStepCount = stepCount;
        }

        @Override
        protected void setStrategy(final int stackDepth) {
            this.beforeTagInstrument = Debugger.this.instrumenter.attach(STEPPING_TAG, new StandardBeforeInstrumentListener(){

                @Override
                @CompilerDirectives.TruffleBoundary
                public void onEnter(Probe probe, Node node, VirtualFrame vFrame) {
                    --StepInto.this.unfinishedStepCount;
                    StepInto.this.strategyTrace("HALT BEFORE", "unfinished steps=%d", StepInto.this.unfinishedStepCount);
                    if (StepInto.this.unfinishedStepCount <= 0) {
                        StepInto.this.halt(node, vFrame.materialize(), true);
                    }
                    StepInto.this.strategyTrace("RESUME BEFORE", "", new Object[0]);
                }
            }, "Debugger StepInto");
            this.afterTagInstrument = Debugger.this.instrumenter.attach(CALL_TAG, new StandardAfterInstrumentListener(){

                @Override
                public void onReturnVoid(Probe probe, Node node, VirtualFrame vFrame) {
                    this.doHalt(node, vFrame.materialize());
                }

                @Override
                public void onReturnValue(Probe probe, Node node, VirtualFrame vFrame, Object result) {
                    this.doHalt(node, vFrame.materialize());
                }

                @Override
                public void onReturnExceptional(Probe probe, Node node, VirtualFrame vFrame, Throwable exception) {
                    this.doHalt(node, vFrame.materialize());
                }

                @CompilerDirectives.TruffleBoundary
                private void doHalt(Node node, MaterializedFrame mFrame) {
                    --StepInto.this.unfinishedStepCount;
                    StepInto.this.strategyTrace(null, "HALT AFTER unfinished steps=%d", StepInto.this.unfinishedStepCount);
                    if (Debugger.currentStackDepth() < stackDepth && StepInto.this.unfinishedStepCount <= 0) {
                        StepInto.this.halt(node, mFrame, false);
                    }
                    StepInto.this.strategyTrace("RESUME AFTER", "", new Object[0]);
                }
            }, "Debugger StepInto");
        }

        @Override
        protected void unsetStrategy() {
            this.beforeTagInstrument.dispose();
            this.afterTagInstrument.dispose();
        }
    }

    private final class Continue
    extends StepStrategy {
        private Continue() {
        }

        @Override
        protected void setStrategy(int stackDepth) {
        }

        @Override
        protected void unsetStrategy() {
        }
    }

    private abstract class StepStrategy {
        private DebugExecutionContext context;
        protected final String strategyName = this.getClass().getSimpleName();

        protected StepStrategy() {
        }

        final String getName() {
            return this.strategyName;
        }

        final void enable(DebugExecutionContext c, int stackDepth) {
            this.context = c;
            this.setStrategy(stackDepth);
        }

        final void disable() {
            this.unsetStrategy();
        }

        @CompilerDirectives.TruffleBoundary
        final void halt(Node astNode, MaterializedFrame mFrame, boolean before) {
            this.context.halt(astNode, mFrame, before, this.getClass().getSimpleName());
        }

        @CompilerDirectives.TruffleBoundary
        final void replaceStrategy(StepStrategy newStrategy) {
            this.context.setStrategy(newStrategy);
        }

        @CompilerDirectives.TruffleBoundary
        protected final void strategyTrace(String action, String format, Object ... args) {
        }

        @CompilerDirectives.TruffleBoundary
        protected final void suspendUserBreakpoints() {
            Debugger.this.lineBreaks.setActive(false);
            Debugger.this.tagBreaks.setActive(false);
        }

        protected final void restoreUserBreakpoints() {
            Debugger.this.lineBreaks.setActive(true);
            Debugger.this.tagBreaks.setActive(true);
        }

        protected abstract void setStrategy(int var1);

        protected abstract void unsetStrategy();
    }

    static interface WarningLog {
        public void addWarning(String var1);
    }

    static interface BreakpointCallback {
        public void haltedAt(Node var1, MaterializedFrame var2, String var3);
    }
}

