/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class ClassLoaderResourceLocator
extends CommonLocator {
    private final ClassLoader classLoader;
    private final String name;
    private String encoding;
    private ILocator tempFileLocator;

    public ClassLoaderResourceLocator(ClassLoader classLoader, String string) {
        this.classLoader = classLoader;
        this.name = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClassLoaderResourceLocator)) {
            return false;
        }
        return this.name.equals(((ClassLoaderResourceLocator)object).name) && this.classLoader.equals(((ClassLoaderResourceLocator)object).classLoader);
    }

    @Override
    public boolean exists() {
        return this.getClassLoader().getResource(this.getName()) != null;
    }

    @Override
    public ILocator getChild(String string) {
        String string2 = String.valueOf(this.getName()) + "/" + string;
        ClassLoaderResourceLocator classLoaderResourceLocator = new ClassLoaderResourceLocator(this.getClassLoader(), string2);
        return classLoaderResourceLocator;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getClassLoader().getResourceAsStream(this.getName());
    }

    @Override
    public String getLocalName() {
        if (this.getName() == null) {
            return "unknown";
        }
        return FileTools.getBaseName(this.getName());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public ILocator getParent() {
        int n = this.getName().lastIndexOf("/");
        if (n > -1) {
            String string = this.getName().substring(0, n);
            return new ClassLoaderResourceLocator(this.getClassLoader(), string);
        }
        return null;
    }

    @Override
    public synchronized IRandomAccess getRandomAccess() throws IOException {
        if (this.tempFileLocator == null) {
            this.tempFileLocator = this.createTempFileLocator();
        }
        return this.tempFileLocator.getRandomAccess();
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.getEncoding() == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getEncoding());
    }

    @Override
    public Reader getReader(String string) throws IOException {
        if (string == null || string.equals("")) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), string);
    }

    @Override
    public String getType() {
        if (this.getName() == null) {
            return "<unknown>";
        }
        return FileTools.getExtension(new File(this.getName()));
    }

    @Override
    public String getTypedName() {
        if (this.getName() == null) {
            return "<unknown>";
        }
        return new File(this.getName()).getName();
    }

    @Override
    public Writer getWriter() throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public Writer getWriter(String string) throws IOException {
        throw new IOException("locator is read only");
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter iLocatorNameFilter) throws IOException {
        return new ILocator[0];
    }

    protected void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public void synch() {
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public URL toURL() {
        return null;
    }
}

