/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocatorFactory;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class FileLocatorFactory
extends CommonLocatorFactory {
    public static final String PATH_SEPARATOR = ";";
    private String searchPathDefinition;
    private List searchPaths;
    private boolean synchSynchronous = true;

    public FileLocatorFactory() {
        this.setSearchPathDefinition("./");
    }

    @Override
    public ILocator createLocator(String string) {
        FileLocator fileLocator = null;
        Iterator iterator = this.getSearchPaths().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            File file = new File(string2.trim());
            File file2 = FileTools.resolvePath(file, string.trim());
            fileLocator = new FileLocator(file2);
            if (!iterator.hasNext() || fileLocator.exists()) break;
        }
        if (fileLocator != null) {
            fileLocator.setSynchSynchronous(this.isSynchSynchronous());
        }
        return fileLocator;
    }

    public String getSearchPathDefinition() {
        return this.searchPathDefinition;
    }

    public List getSearchPaths() {
        return this.searchPaths;
    }

    public boolean isSynchSynchronous() {
        return this.synchSynchronous;
    }

    public void setSearchPathDefinition(String string) {
        this.searchPathDefinition = string;
        this.searchPaths = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(this.searchPathDefinition, PATH_SEPARATOR);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2 == null || string2.trim().length() <= 0 || this.searchPaths.contains(string2)) continue;
            this.searchPaths.add(string2.trim());
        }
    }

    public void setSearchPaths(List list) {
        this.searchPaths = list;
    }

    public void setSynchSynchronous(boolean bl) {
        this.synchSynchronous = bl;
    }
}

