/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ThisReference
extends Reference {
    public static ThisReference implicitThis() {
        ThisReference thisReference = new ThisReference(0, 0);
        thisReference.bits |= 4;
        return thisReference;
    }

    public ThisReference(int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    @Override
    public FlowInfo analyseAssignment(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean bl) {
        return flowInfo;
    }

    public boolean checkAccess(BlockScope blockScope, ReferenceBinding referenceBinding) {
        TypeDeclaration typeDeclaration;
        MethodScope methodScope = blockScope.methodScope();
        if (methodScope.isConstructorCall) {
            methodScope.problemReporter().fieldsOrThisBeforeConstructorInvocation(this);
            return false;
        }
        if (methodScope.isStatic) {
            methodScope.problemReporter().errorThisSuperInStatic(this);
            return false;
        }
        if (this.isUnqualifiedSuper() && (typeDeclaration = methodScope.referenceType()) != null && TypeDeclaration.kind(typeDeclaration.modifiers) == 2) {
            methodScope.problemReporter().errorNoSuperInInterface(this);
            return false;
        }
        if (referenceBinding != null) {
            blockScope.tagAsAccessingEnclosingInstanceStateOf(referenceBinding, false);
        }
        return true;
    }

    @Override
    public boolean checkNPE(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return true;
    }

    @Override
    public void generateAssignment(BlockScope blockScope, CodeStream codeStream, Assignment assignment, boolean bl) {
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.aload_0();
        }
        if ((this.bits & 4) == 0) {
            codeStream.recordPositionsFrom(n, this.sourceStart);
        }
    }

    @Override
    public void generateCompoundAssignment(BlockScope blockScope, CodeStream codeStream, Expression expression, int n, int n2, boolean bl) {
    }

    @Override
    public void generatePostIncrement(BlockScope blockScope, CodeStream codeStream, CompoundAssignment compoundAssignment, boolean bl) {
    }

    @Override
    public boolean isImplicitThis() {
        return (this.bits & 4) != 0;
    }

    @Override
    public boolean isThis() {
        return true;
    }

    @Override
    public int nullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        return 4;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        if (this.isImplicitThis()) {
            return stringBuffer;
        }
        return stringBuffer.append("this");
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        MethodBinding methodBinding;
        this.constant = Constant.NotAConstant;
        ReferenceBinding referenceBinding = blockScope.enclosingReceiverType();
        if (!this.isImplicitThis() && !this.checkAccess(blockScope, referenceBinding)) {
            return null;
        }
        this.resolvedType = referenceBinding;
        MethodScope methodScope = blockScope.namedMethodScope();
        if (methodScope != null && (methodBinding = methodScope.referenceMethodBinding()) != null && methodBinding.receiver != null && TypeBinding.equalsEquals(methodBinding.receiver, this.resolvedType)) {
            this.resolvedType = methodBinding.receiver;
        }
        return this.resolvedType;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }
}

