/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Method;
import org.GNOME.Accessibility.AccessUtil;
import org.GNOME.Accessibility.Accessible;
import org.GNOME.Accessibility.Action;
import org.GNOME.Accessibility.DeviceEvent;
import org.GNOME.Accessibility.DeviceEventListener;
import org.GNOME.Accessibility.Event;
import org.GNOME.Accessibility.EventListener;
import org.GNOME.Accessibility.EventListenerHelper;
import org.GNOME.Accessibility.EventListenerImpl;
import org.GNOME.Accessibility.EventListenerMode;
import org.GNOME.Accessibility.KeyDefinition;
import org.GNOME.Accessibility.KeyMask;
import org.GNOME.Accessibility.ListenerUtil;
import org.GNOME.Accessibility.Registry;
import org.GNOME.Accessibility.Role;
import org.GNOME.Accessibility.Selection;
import org.GNOME.Accessibility.TEXT_BOUNDARY_TYPE;
import org.GNOME.Accessibility.Text;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;

public class JNav
extends EventListenerImpl
implements AccessUtil.EventCallback {
    private Accessible current;
    private Object tts;
    private static Class synthesisDriverHelperClass;
    private TextListener theTextListener;

    private void run() {
        if (AccessUtil.requiredJREVersionFound()) {
            System.out.println("Starting JNav.");
            Registry registry = AccessUtil.getRegistryObject();
            EventListener eventListener = EventListenerHelper.narrow((Object)this.tie());
            registry.registerGlobalEventListener(eventListener, "focus:");
            EventListener eventListener2 = EventListenerHelper.narrow((Object)this.getTextListener().tie());
            registry.registerGlobalEventListener(eventListener2, "object:text-caret-moved");
            registry.registerGlobalEventListener(eventListener2, "object:text-changed");
            ListenerUtil.KeyListener keyListener = new ListenerUtil.KeyListener((AccessUtil.EventCallback)this);
            KeyDefinition[] keyDefinitionArray = new KeyDefinition[]{new KeyDefinition(0, 0, "Up", 0), new KeyDefinition(0, 0, "Down", 0), new KeyDefinition(0, 0, "Left", 0), new KeyDefinition(0, 0, "Right", 0), new KeyDefinition(0, 0, "Home", 0), new KeyDefinition(0, 0, "F1", 0), new KeyDefinition(0, 0, "F2", 0), new KeyDefinition(0, 0, "Page_Up", 0), new KeyDefinition(0, 0, "Page_Down", 0), new KeyDefinition(0, 0, "Escape", 0)};
            AccessUtil.registerKeyListener((DeviceEventListener)keyListener.objRef(), (KeyDefinition[])keyDefinitionArray, (KeyMask)KeyMask.SHIFT, (boolean)false, (EventListenerMode)new EventListenerMode(true, true, true));
            this.tts = this.getSpeechService();
            this.message("J Navigator ready.");
            AccessUtil.getORB().run();
        }
    }

    public static void main(String[] stringArray) {
        new JNav().run();
    }

    public void notifyEvent(Event event) {
        if (event.source != this.current) {
            this.current = event.source;
            this.announce(this.current);
        }
    }

    public boolean notifyDeviceEvent(DeviceEvent deviceEvent) {
        System.out.println("Key " + new KeyMask((int)deviceEvent.modifiers) + "-" + new Character((char)deviceEvent.id) + " (" + deviceEvent.event_string + ")");
        if (deviceEvent.event_string != null && deviceEvent.event_string.length() > 0) {
            if (deviceEvent.event_string.equals("Up")) {
                this.navigateUp();
            } else if (deviceEvent.event_string.equals("Down")) {
                this.navigateDown();
            } else if (deviceEvent.event_string.equals("Left")) {
                this.navigatePrev();
            } else if (deviceEvent.event_string.equals("Right")) {
                this.navigateNext();
            } else if (deviceEvent.event_string.equals("Page_Up")) {
                this.navigateTop();
            } else if (deviceEvent.event_string.equals("F1")) {
                this.help();
            } else if (deviceEvent.event_string.equals("F2")) {
                this.toggleCharacterEcho();
            } else if (deviceEvent.event_string.equals("Page_Down")) {
                this.shutup();
            } else if (deviceEvent.event_string.equals("Home")) {
                this.describeCurrent();
            } else if (deviceEvent.event_string.equals("Escape")) {
                this.quit();
            }
        }
        return true;
    }

    private TextListener getTextListener() {
        if (this.theTextListener == null) {
            this.theTextListener = new TextListener();
        }
        return this.theTextListener;
    }

    private void navigateNext() {
        Accessible accessible;
        int n;
        System.out.println("prev");
        Accessible accessible2 = null;
        if (this.current != null && (n = this.current.getIndexInParent()) >= 0 && (accessible = this.current.parent()) != null) {
            accessible2 = accessible.getChildAtIndex(++n);
        }
        if (accessible2 != null) {
            this.moveTo(accessible2);
        } else {
            this.message("Can't move to next sibling");
        }
    }

    private void navigatePrev() {
        Accessible accessible;
        int n;
        System.out.println("prev");
        Accessible accessible2 = null;
        if (this.current != null && (n = this.current.getIndexInParent()) > 0 && (accessible = this.current.parent()) != null) {
            accessible2 = accessible.getChildAtIndex(--n);
        }
        if (accessible2 != null) {
            this.moveTo(accessible2);
        } else {
            this.message("Can't move to previous sibling");
        }
    }

    private void navigateUp() {
        System.out.println("parent");
        Accessible accessible = null;
        if (this.current != null) {
            accessible = this.current.parent();
        }
        if (accessible != null) {
            this.moveTo(accessible);
        } else {
            this.message("Can't move to parent");
        }
    }

    private void navigateDown() {
        System.out.println("first child");
        Accessible accessible = null;
        if (this.current != null) {
            accessible = this.current.getChildAtIndex(0);
        }
        if (accessible != null) {
            this.moveTo(accessible);
        } else {
            this.message("Can't move to first child.");
        }
    }

    private void navigateTop() {
        Accessible accessible = this.current;
        while (this.current.getRole() != Role.ROLE_FRAME && accessible != null) {
            accessible = this.current.parent();
            this.current.unref();
            this.current = accessible;
        }
        this.announce(this.current);
    }

    private void describeCurrent() {
        this.shutup();
        this.announce(this.current);
        if (this.current != null) {
            Action action;
            int n;
            Selection selection;
            String string = "";
            Text text = AccessUtil.getTextInterface((Accessible)this.current);
            if (text != null) {
                string = text.getText(0, -1);
                this.message("Text content: " + string);
                text.unref();
            }
            if ((selection = AccessUtil.getSelectionInterface((Accessible)this.current)) != null) {
                int n2 = selection.nSelectedChildren();
                this.message("selectable, " + n2 + " children selected: ");
                for (n = 0; n < n2; ++n) {
                    Accessible accessible = selection.getSelectedChild(n);
                    if (accessible == null) continue;
                    this.message(accessible.name());
                    accessible.unref();
                }
                selection.unref();
            }
            if ((action = AccessUtil.getActionInterface((Accessible)this.current)) != null) {
                n = action.nActions();
                this.message("actions:");
                for (int i = 0; i < n; ++i) {
                    this.message(action.getName(i) + ", " + action.getDescription(i));
                }
                action.unref();
            }
        } else {
            this.message("No currently focussed object!");
        }
    }

    private void shutup() {
        try {
            Method method = this.tts.getClass().getMethod("stop", null);
            method.invoke((java.lang.Object)this.tts, null);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void toggleCharacterEcho() {
        boolean bl = !this.getTextListener().getCharacterEcho();
        this.getTextListener().setCharacterEcho(bl);
        this.message("character echo " + (bl ? "on" : "off"));
    }

    private void help() {
        this.message("Sorry, help isn't implemented yet.");
    }

    private void quit() {
        this.message("J Navigator exiting. Goodbye.");
        AccessUtil.getORB().shutdown(false);
    }

    private void message(String string) {
        System.out.println("saying \"" + string + "\"");
        try {
            Class[] classArray = new Class[]{Class.forName("java.lang.String")};
            Method method = this.tts.getClass().getMethod("say", classArray);
            java.lang.Object[] objectArray = new java.lang.Object[]{string};
            method.invoke((java.lang.Object)this.tts, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void moveTo(Accessible accessible) {
        this.current = accessible;
        this.announce(this.current);
    }

    private void announce(Accessible accessible) {
        this.shutup();
        if (accessible != null) {
            String string = accessible.name();
            if (string.length() < 1) {
                string = "nameless";
            }
            this.message(string + " " + accessible.getRoleName() + ", " + accessible.description());
        }
    }

    private Object getSpeechService() {
        if (this.tts == null) {
            try {
                this.tts = AccessUtil.activationObjectReference((String)"IDL:GNOME/Speech/SynthesisDriver:1.0");
            }
            catch (Throwable throwable) {
                System.err.println("Can't find speech service!");
            }
            if (synthesisDriverHelperClass != null) {
                try {
                    Class[] classArray = new Class[]{Class.forName("org.omg.CORBA.Object")};
                    Method method = synthesisDriverHelperClass.getMethod("narrow", classArray);
                    java.lang.Object[] objectArray = new java.lang.Object[]{this.tts};
                    this.tts = (Object)method.invoke(null, objectArray);
                    Method method2 = this.tts.getClass().getMethod("driverInit", null);
                    method2.invoke((java.lang.Object)this.tts, null);
                }
                catch (Exception exception) {
                    System.out.println("reflection error " + exception);
                }
            }
        }
        return this.tts;
    }

    public void unImplemented_() {
    }

    public void unImplemented2_() {
    }

    public void unImplemented3_() {
    }

    public void unImplemented4_() {
    }

    static {
        try {
            synthesisDriverHelperClass = Class.forName("org.GNOME.Speech.SynthesisDriverHelper");
        }
        catch (Exception exception) {
            System.out.println("TTS driver not found.");
            System.out.println(exception);
        }
    }

    public class TextListener
    extends EventListenerImpl {
        private int pOffset = -1;
        private Object pText = null;
        private IntHolder wordEndHolder = new IntHolder();
        private int prevEnd = 0;
        private boolean echoChars = false;

        public void notifyEvent(Event event) {
            Text text = AccessUtil.getTextInterface((Accessible)event.source);
            if (event.type.equals("object:text-caret-moved")) {
                this.notifyCaretEvent(text, event);
            } else if (event.type.equals("object:text-changed")) {
                this.notifyChangeEvent(text, event);
            }
        }

        public void notifyCaretEvent(Text text, Event event) {
            int n = this.previousOffset(event.source, event.detail1);
            if (n >= 0 && Math.abs(event.detail1 - n) == 1) {
                JNav.this.message(new Character((char)text.getCharacterAtOffset(event.detail1)).toString());
            } else {
                IntHolder intHolder = new IntHolder();
                IntHolder intHolder2 = new IntHolder();
                text.getCharacterExtents(event.detail1, new IntHolder(), intHolder, new IntHolder(), new IntHolder(), (short)0);
                text.getCharacterExtents(n, new IntHolder(), intHolder2, new IntHolder(), new IntHolder(), (short)0);
                TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE = intHolder.value != intHolder2.value ? TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_START : TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_WORD_START;
                String string = text.getTextAtOffset(event.detail1, tEXT_BOUNDARY_TYPE, new IntHolder(), new IntHolder());
                JNav.this.message(string);
            }
        }

        public void notifyChangeEvent(Text text, Event event) {
            if (event.detail2 == 1 && event.detail1 == text.caretOffset() - 1) {
                if (this.echoChars) {
                    JNav.this.message(text.getText(event.detail1, event.detail1 + event.detail2 + 1));
                } else {
                    String string = text.getTextAtOffset(event.detail1 - 1, TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_WORD_END, new IntHolder(), this.wordEndHolder);
                    if (this.wordEndHolder.value == this.prevEnd) {
                        JNav.this.message(string);
                    }
                    this.prevEnd = this.wordEndHolder.value;
                }
            } else {
                JNav.this.message(text.getTextAtOffset(event.detail1, TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_SENTENCE_START, new IntHolder(), new IntHolder()));
            }
        }

        public int previousOffset(Accessible accessible, int n) {
            int n2 = -1;
            if (accessible._is_equivalent(this.pText)) {
                n2 = this.pOffset;
            }
            this.pOffset = n;
            this.pText = accessible;
            return n2;
        }

        public void setCharacterEcho(boolean bl) {
            this.echoChars = bl;
        }

        public boolean getCharacterEcho() {
            return this.echoChars;
        }

        public void unImplemented_() {
        }

        public void unImplemented2_() {
        }

        public void unImplemented3_() {
        }

        public void unImplemented4_() {
        }
    }
}

