/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.ctx;

import com.sun.jndi.toolkit.ctx.Continuation;
import com.sun.jndi.toolkit.ctx.HeadTail;
import com.sun.jndi.toolkit.ctx.PartialCompositeContext;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ResolveResult;

public abstract class ComponentContext
extends PartialCompositeContext {
    private static int debug = 0;
    protected static final byte USE_CONTINUATION = 1;
    protected static final byte TERMINAL_COMPONENT = 2;
    protected static final byte TERMINAL_NNS_COMPONENT = 3;

    protected ComponentContext() {
        this._contextType = 2;
    }

    protected abstract Object c_lookup(Name var1, Continuation var2) throws NamingException;

    protected abstract Object c_lookupLink(Name var1, Continuation var2) throws NamingException;

    protected abstract NamingEnumeration c_list(Name var1, Continuation var2) throws NamingException;

    protected abstract NamingEnumeration c_listBindings(Name var1, Continuation var2) throws NamingException;

    protected abstract void c_bind(Name var1, Object var2, Continuation var3) throws NamingException;

    protected abstract void c_rebind(Name var1, Object var2, Continuation var3) throws NamingException;

    protected abstract void c_unbind(Name var1, Continuation var2) throws NamingException;

    protected abstract void c_destroySubcontext(Name var1, Continuation var2) throws NamingException;

    protected abstract Context c_createSubcontext(Name var1, Continuation var2) throws NamingException;

    protected abstract void c_rename(Name var1, Name var2, Continuation var3) throws NamingException;

    protected abstract NameParser c_getNameParser(Name var1, Continuation var2) throws NamingException;

    protected HeadTail p_parseComponent(Name name, Continuation cont) throws NamingException {
        Name tail;
        Name head;
        int separator = name.isEmpty() || name.get(0).equals("") ? 0 : 1;
        if (name instanceof CompositeName) {
            head = name.getPrefix(separator);
            tail = name.getSuffix(separator);
        } else {
            head = new CompositeName().add(name.toString());
            tail = null;
        }
        if (debug > 2) {
            System.err.println("ORIG: " + name);
            System.err.println("PREFIX: " + name);
            System.err.println("SUFFIX: " + null);
        }
        return new HeadTail(head, tail);
    }

    protected Object c_resolveIntermediate_nns(Name name, Continuation cont) throws NamingException {
        try {
            final Object obj = this.c_lookup(name, cont);
            if (obj != null && this.getClass().isInstance(obj)) {
                cont.setContinueNNS(obj, name, (Context)this);
                return null;
            }
            if (obj != null && !(obj instanceof Context)) {
                RefAddr addr = new RefAddr("nns"){
                    private static final long serialVersionUID = -8831204798861786362L;

                    @Override
                    public Object getContent() {
                        return obj;
                    }
                };
                Reference ref = new Reference("java.lang.Object", addr);
                CompositeName resName = (CompositeName)name.clone();
                resName.add("");
                cont.setContinue(ref, resName, this);
                return null;
            }
            return obj;
        }
        catch (NamingException e) {
            e.appendRemainingComponent("");
            throw e;
        }
    }

    protected Object c_lookup_nns(Name name, Continuation cont) throws NamingException {
        this.c_processJunction_nns(name, cont);
        return null;
    }

    protected Object c_lookupLink_nns(Name name, Continuation cont) throws NamingException {
        this.c_processJunction_nns(name, cont);
        return null;
    }

    protected NamingEnumeration c_list_nns(Name name, Continuation cont) throws NamingException {
        this.c_processJunction_nns(name, cont);
        return null;
    }

    protected NamingEnumeration c_listBindings_nns(Name name, Continuation cont) throws NamingException {
        this.c_processJunction_nns(name, cont);
        return null;
    }

    protected void c_bind_nns(Name name, Object obj, Continuation cont) throws NamingException {
        this.c_processJunction_nns(name, cont);
    }

    protected void c_rebind_nns(Name name, Object obj, Continuation cont) throws NamingException {
        this.c_processJunction_nns(name, cont);
    }

    protected void c_unbind_nns(Name name, Continuation cont) throws NamingException {
        this.c_processJunction_nns(name, cont);
    }

    protected Context c_createSubcontext_nns(Name name, Continuation cont) throws NamingException {
        this.c_processJunction_nns(name, cont);
        return null;
    }

    protected void c_destroySubcontext_nns(Name name, Continuation cont) throws NamingException {
        this.c_processJunction_nns(name, cont);
    }

    protected void c_rename_nns(Name oldname, Name newname, Continuation cont) throws NamingException {
        this.c_processJunction_nns(oldname, cont);
    }

    protected NameParser c_getNameParser_nns(Name name, Continuation cont) throws NamingException {
        this.c_processJunction_nns(name, cont);
        return null;
    }

    protected void c_processJunction_nns(Name name, Continuation cont) throws NamingException {
        if (name.isEmpty()) {
            RefAddr addr = new RefAddr("nns"){
                private static final long serialVersionUID = -1389472957988053402L;

                @Override
                public Object getContent() {
                    return ComponentContext.this;
                }
            };
            Reference ref = new Reference("java.lang.Object", addr);
            cont.setContinue(ref, _NNS_NAME, this);
            return;
        }
        try {
            Object target = this.c_lookup(name, cont);
            if (cont.isContinue()) {
                cont.appendRemainingComponent("");
            } else {
                cont.setContinueNNS(target, name, (Context)this);
            }
        }
        catch (NamingException e) {
            e.appendRemainingComponent("");
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected HeadTail p_resolveIntermediate(Name name, Continuation cont) throws NamingException {
        ret = 1;
        cont.setSuccess();
        p = this.p_parseComponent(name, cont);
        tail = p.getTail();
        head = p.getHead();
        if (tail == null || tail.isEmpty()) {
            ret = 2;
        } else if (!tail.get(0).equals("")) {
            try {
                obj = this.c_resolveIntermediate_nns(head, cont);
                if (obj != null) {
                    cont.setContinue(obj, head, (Context)this, tail);
                }
                if (!cont.isContinue()) ** GOTO lbl52
                this.checkAndAdjustRemainingName(cont.getRemainingName());
                cont.appendRemainingName(tail);
            }
            catch (NamingException e) {
                this.checkAndAdjustRemainingName(e.getRemainingName());
                e.appendRemainingName(tail);
                throw e;
            }
        } else if (tail.size() == 1) {
            ret = 3;
        } else if (head.isEmpty() || this.isAllEmpty(tail)) {
            newTail = tail.getSuffix(1);
            try {
                obj = this.c_lookup_nns(head, cont);
                if (obj != null) {
                    cont.setContinue(obj, head, (Context)this, newTail);
                }
                if (!cont.isContinue()) ** GOTO lbl52
                cont.appendRemainingName(newTail);
            }
            catch (NamingException e) {
                e.appendRemainingName(newTail);
                throw e;
            }
        } else {
            try {
                obj = this.c_resolveIntermediate_nns(head, cont);
                if (obj != null) {
                    cont.setContinue(obj, head, (Context)this, tail);
                } else if (cont.isContinue()) {
                    this.checkAndAdjustRemainingName(cont.getRemainingName());
                    cont.appendRemainingName(tail);
                }
            }
            catch (NamingException e) {
                this.checkAndAdjustRemainingName(e.getRemainingName());
                e.appendRemainingName(tail);
                throw e;
            }
        }
lbl52:
        // 10 sources

        p.setStatus(ret);
        return p;
    }

    void checkAndAdjustRemainingName(Name rname) throws InvalidNameException {
        int count;
        if (rname != null && (count = rname.size()) > 1 && rname.get(count - 1).equals("")) {
            rname.remove(count - 1);
        }
    }

    protected boolean isAllEmpty(Name n) {
        int count = n.size();
        for (int i = 0; i < count; ++i) {
            if (n.get(i).equals("")) continue;
            return false;
        }
        return true;
    }

    @Override
    protected ResolveResult p_resolveToClass(Name name, Class contextType, Continuation cont) throws NamingException {
        if (contextType.isInstance(this)) {
            cont.setSuccess();
            return new ResolveResult((Object)this, name);
        }
        ResolveResult ret = null;
        HeadTail res = this.p_resolveIntermediate(name, cont);
        switch (res.getStatus()) {
            case 3: {
                Object obj = this.p_lookup(name, cont);
                if (cont.isContinue() || !contextType.isInstance(obj)) break;
                ret = new ResolveResult(obj, _EMPTY_NAME);
                break;
            }
            case 2: {
                cont.setSuccess();
                break;
            }
        }
        return ret;
    }

    @Override
    protected Object p_lookup(Name name, Continuation cont) throws NamingException {
        Object ret = null;
        HeadTail res = this.p_resolveIntermediate(name, cont);
        switch (res.getStatus()) {
            case 3: {
                ret = this.c_lookup_nns(res.getHead(), cont);
                if (!(ret instanceof LinkRef)) break;
                cont.setContinue(ret, res.getHead(), this);
                ret = null;
                break;
            }
            case 2: {
                ret = this.c_lookup(res.getHead(), cont);
                if (!(ret instanceof LinkRef)) break;
                cont.setContinue(ret, res.getHead(), this);
                ret = null;
                break;
            }
        }
        return ret;
    }

    @Override
    protected NamingEnumeration p_list(Name name, Continuation cont) throws NamingException {
        NamingEnumeration ret = null;
        HeadTail res = this.p_resolveIntermediate(name, cont);
        switch (res.getStatus()) {
            case 3: {
                if (debug > 0) {
                    System.out.println("c_list_nns(" + res.getHead() + ")");
                }
                ret = this.c_list_nns(res.getHead(), cont);
                break;
            }
            case 2: {
                if (debug > 0) {
                    System.out.println("c_list(" + res.getHead() + ")");
                }
                ret = this.c_list(res.getHead(), cont);
                break;
            }
        }
        return ret;
    }

    @Override
    protected NamingEnumeration p_listBindings(Name name, Continuation cont) throws NamingException {
        NamingEnumeration ret = null;
        HeadTail res = this.p_resolveIntermediate(name, cont);
        switch (res.getStatus()) {
            case 3: {
                ret = this.c_listBindings_nns(res.getHead(), cont);
                break;
            }
            case 2: {
                ret = this.c_listBindings(res.getHead(), cont);
                break;
            }
        }
        return ret;
    }

    @Override
    protected void p_bind(Name name, Object obj, Continuation cont) throws NamingException {
        HeadTail res = this.p_resolveIntermediate(name, cont);
        switch (res.getStatus()) {
            case 3: {
                this.c_bind_nns(res.getHead(), obj, cont);
                break;
            }
            case 2: {
                this.c_bind(res.getHead(), obj, cont);
                break;
            }
        }
    }

    @Override
    protected void p_rebind(Name name, Object obj, Continuation cont) throws NamingException {
        HeadTail res = this.p_resolveIntermediate(name, cont);
        switch (res.getStatus()) {
            case 3: {
                this.c_rebind_nns(res.getHead(), obj, cont);
                break;
            }
            case 2: {
                this.c_rebind(res.getHead(), obj, cont);
                break;
            }
        }
    }

    @Override
    protected void p_unbind(Name name, Continuation cont) throws NamingException {
        HeadTail res = this.p_resolveIntermediate(name, cont);
        switch (res.getStatus()) {
            case 3: {
                this.c_unbind_nns(res.getHead(), cont);
                break;
            }
            case 2: {
                this.c_unbind(res.getHead(), cont);
                break;
            }
        }
    }

    @Override
    protected void p_destroySubcontext(Name name, Continuation cont) throws NamingException {
        HeadTail res = this.p_resolveIntermediate(name, cont);
        switch (res.getStatus()) {
            case 3: {
                this.c_destroySubcontext_nns(res.getHead(), cont);
                break;
            }
            case 2: {
                this.c_destroySubcontext(res.getHead(), cont);
                break;
            }
        }
    }

    @Override
    protected Context p_createSubcontext(Name name, Continuation cont) throws NamingException {
        Context ret = null;
        HeadTail res = this.p_resolveIntermediate(name, cont);
        switch (res.getStatus()) {
            case 3: {
                ret = this.c_createSubcontext_nns(res.getHead(), cont);
                break;
            }
            case 2: {
                ret = this.c_createSubcontext(res.getHead(), cont);
                break;
            }
        }
        return ret;
    }

    @Override
    protected void p_rename(Name oldName, Name newName, Continuation cont) throws NamingException {
        HeadTail res = this.p_resolveIntermediate(oldName, cont);
        switch (res.getStatus()) {
            case 3: {
                this.c_rename_nns(res.getHead(), newName, cont);
                break;
            }
            case 2: {
                this.c_rename(res.getHead(), newName, cont);
                break;
            }
        }
    }

    @Override
    protected NameParser p_getNameParser(Name name, Continuation cont) throws NamingException {
        NameParser ret = null;
        HeadTail res = this.p_resolveIntermediate(name, cont);
        switch (res.getStatus()) {
            case 3: {
                ret = this.c_getNameParser_nns(res.getHead(), cont);
                break;
            }
            case 2: {
                ret = this.c_getNameParser(res.getHead(), cont);
                break;
            }
        }
        return ret;
    }

    @Override
    protected Object p_lookupLink(Name name, Continuation cont) throws NamingException {
        Object ret = null;
        HeadTail res = this.p_resolveIntermediate(name, cont);
        switch (res.getStatus()) {
            case 3: {
                ret = this.c_lookupLink_nns(res.getHead(), cont);
                break;
            }
            case 2: {
                ret = this.c_lookupLink(res.getHead(), cont);
                break;
            }
        }
        return ret;
    }
}

