/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import sun.font.XRTextRenderer;
import sun.java2d.SunGraphics2D;
import sun.java2d.jules.TrapezoidList;
import sun.java2d.loops.XORComposite;
import sun.java2d.xr.GrowableEltArray;
import sun.java2d.xr.GrowableRectArray;
import sun.java2d.xr.MaskTileManager;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRBackendNative;
import sun.java2d.xr.XRColor;
import sun.java2d.xr.XRMaskImage;
import sun.java2d.xr.XRPaints;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

public class XRCompositeManager {
    private static boolean enableGradCache = true;
    private static XRCompositeManager instance;
    XRSurfaceData src;
    XRSurfaceData texture;
    XRSurfaceData gradient;
    int alphaMask = 0;
    XRColor solidColor = new XRColor();
    float extraAlpha = 1.0f;
    byte compRule = (byte)3;
    XRColor alphaColor = new XRColor();
    XRSurfaceData solidSrcPict;
    int alphaMaskPict;
    int gradCachePixmap;
    int gradCachePicture;
    boolean xorEnabled = false;
    int validatedPixel = 0;
    Composite validatedComp;
    Paint validatedPaint;
    float validatedExtraAlpha = 1.0f;
    XRBackend con = new XRBackendNative();
    MaskTileManager maskBuffer;
    XRTextRenderer textRenderer;
    XRMaskImage maskImage;

    public static synchronized XRCompositeManager getInstance(XRSurfaceData surface) {
        if (instance == null) {
            instance = new XRCompositeManager(surface);
        }
        return instance;
    }

    private XRCompositeManager(XRSurfaceData surface) {
        String gradProp = System.getProperty("sun.java2d.xrgradcache");
        enableGradCache = gradProp == null || !gradProp.equalsIgnoreCase("false") && !gradProp.equalsIgnoreCase("f");
        XRPaints.register(this);
        this.initResources(surface);
        this.maskBuffer = new MaskTileManager(this, surface.getXid());
        this.textRenderer = new XRTextRenderer(this);
        this.maskImage = new XRMaskImage(this, surface.getXid());
    }

    public void initResources(XRSurfaceData surface) {
        int parentXid = surface.getXid();
        int solidPixmap = this.con.createPixmap(parentXid, 32, 1, 1);
        int solidSrcPictXID = this.con.createPicture(solidPixmap, 0);
        this.con.setPictureRepeat(solidSrcPictXID, 1);
        this.con.renderRectangle(solidSrcPictXID, (byte)1, XRColor.FULL_ALPHA, 0, 0, 1, 1);
        this.solidSrcPict = new XRSurfaceData.XRInternalSurfaceData(this.con, solidSrcPictXID, null);
        this.setForeground(0);
        int extraAlphaMask = this.con.createPixmap(parentXid, 8, 1, 1);
        this.alphaMaskPict = this.con.createPicture(extraAlphaMask, 2);
        this.con.setPictureRepeat(this.alphaMaskPict, 1);
        this.con.renderRectangle(this.alphaMaskPict, (byte)0, XRColor.NO_ALPHA, 0, 0, 1, 1);
        if (enableGradCache) {
            this.gradCachePixmap = this.con.createPixmap(parentXid, 32, 256, 256);
            this.gradCachePicture = this.con.createPicture(this.gradCachePixmap, 0);
        }
    }

    public void setForeground(int pixel) {
        this.solidColor.setColorValues(pixel, false);
        this.con.renderRectangle(this.solidSrcPict.picture, (byte)1, this.solidColor, 0, 0, 1, 1);
    }

    public void setGradientPaint(XRSurfaceData gradient) {
        if (this.gradient != null) {
            this.con.freePicture(this.gradient.picture);
        }
        this.gradient = gradient;
        this.src = gradient;
    }

    public void setTexturePaint(XRSurfaceData texture) {
        this.texture = texture;
        this.src = texture;
    }

    public void XRResetPaint() {
        this.src = this.solidSrcPict;
    }

    public void validateCompositeState(Composite comp, AffineTransform xform, Paint paint, SunGraphics2D sg2d) {
        boolean updatePaint;
        boolean bl = updatePaint = paint != this.validatedPaint || paint == null;
        if (comp != this.validatedComp) {
            if (comp != null) {
                this.setComposite(comp);
            } else {
                comp = AlphaComposite.getInstance(3);
                this.setComposite(comp);
            }
            updatePaint = true;
            this.validatedComp = comp;
        }
        if (sg2d != null && this.validatedPixel != sg2d.pixel) {
            this.validatedPixel = sg2d.pixel;
            this.setForeground(this.validatedPixel);
        }
        if (updatePaint) {
            if (paint != null && sg2d != null && sg2d.paintState >= 2) {
                XRPaints.setPaint(sg2d, paint);
            } else {
                this.XRResetPaint();
            }
            this.validatedPaint = paint;
        }
        if (this.src != this.solidSrcPict) {
            AffineTransform at = (AffineTransform)xform.clone();
            try {
                at.invert();
            }
            catch (NoninvertibleTransformException e) {
                at.setToIdentity();
            }
            this.src.validateAsSource(at, -1, -1);
        }
    }

    private void setComposite(Composite comp) {
        if (comp instanceof AlphaComposite) {
            AlphaComposite aComp = (AlphaComposite)comp;
            this.validatedExtraAlpha = aComp.getAlpha();
            this.compRule = XRUtils.j2dAlphaCompToXR(aComp.getRule());
            this.extraAlpha = this.validatedExtraAlpha;
            if (this.extraAlpha == 1.0f) {
                this.alphaMask = 0;
                this.alphaColor.alpha = XRColor.FULL_ALPHA.alpha;
            } else {
                this.alphaColor.alpha = XRColor.byteToXRColorValue((int)(this.extraAlpha * 255.0f));
                this.alphaMask = this.alphaMaskPict;
                this.con.renderRectangle(this.alphaMaskPict, (byte)1, this.alphaColor, 0, 0, 1, 1);
            }
            this.xorEnabled = false;
        } else if (comp instanceof XORComposite) {
            this.xorEnabled = true;
        } else {
            throw new InternalError("Composite accaleration not implemented for: " + comp.getClass().getName());
        }
    }

    public boolean maskRequired() {
        return !this.xorEnabled && (this.src != this.solidSrcPict || this.src == this.solidSrcPict && this.solidColor.alpha != 65535 || this.extraAlpha != 1.0f);
    }

    public void XRComposite(int src, int mask, int dst, int srcX, int srcY, int maskX, int maskY, int dstX, int dstY, int width, int height) {
        int cachedSrc = src == 0 ? this.src.picture : src;
        int cachedX = srcX;
        int cachedY = srcY;
        if (enableGradCache && this.gradient != null && cachedSrc == this.gradient.picture) {
            this.con.renderComposite((byte)1, this.gradient.picture, 0, this.gradCachePicture, srcX, srcY, 0, 0, 0, 0, width, height);
            cachedX = 0;
            cachedY = 0;
            cachedSrc = this.gradCachePicture;
        }
        this.con.renderComposite(this.compRule, cachedSrc, mask, dst, cachedX, cachedY, maskX, maskY, dstX, dstY, width, height);
    }

    public void XRCompositeTraps(int dst, int srcX, int srcY, TrapezoidList trapList) {
        int renderReferenceX = 0;
        int renderReferenceY = 0;
        if (trapList.getP1YLeft(0) < trapList.getP2YLeft(0)) {
            renderReferenceX = trapList.getP1XLeft(0);
            renderReferenceY = trapList.getP1YLeft(0);
        } else {
            renderReferenceX = trapList.getP2XLeft(0);
            renderReferenceY = trapList.getP2YLeft(0);
        }
        renderReferenceX = (int)Math.floor(XRUtils.XFixedToDouble(renderReferenceX));
        renderReferenceY = (int)Math.floor(XRUtils.XFixedToDouble(renderReferenceY));
        this.con.renderCompositeTrapezoids(this.compRule, this.src.picture, 2, dst, renderReferenceX, renderReferenceY, trapList);
    }

    public void XRRenderRectangles(XRSurfaceData dst, GrowableRectArray rects) {
        if (this.xorEnabled) {
            this.con.GCRectangles(dst.getXid(), dst.getGC(), rects);
        } else {
            this.con.renderRectangles(dst.getPicture(), this.compRule, this.solidColor, rects);
        }
    }

    public void compositeBlit(XRSurfaceData src, XRSurfaceData dst, int sx, int sy, int dx, int dy, int w, int h) {
        this.con.renderComposite(this.compRule, src.picture, this.alphaMask, dst.picture, sx, sy, 0, 0, dx, dy, w, h);
    }

    public void compositeText(int dst, int glyphSet, int maskFormat, GrowableEltArray elts) {
        this.con.XRenderCompositeText(this.compRule, this.src.picture, dst, maskFormat, 0, 0, 0, 0, glyphSet, elts);
    }

    public XRColor getMaskColor() {
        return !this.isTexturePaintActive() ? XRColor.FULL_ALPHA : this.getAlphaColor();
    }

    public int getExtraAlphaMask() {
        return this.alphaMask;
    }

    public boolean isTexturePaintActive() {
        return this.src == this.texture;
    }

    public XRColor getAlphaColor() {
        return this.alphaColor;
    }

    public XRBackend getBackend() {
        return this.con;
    }

    public float getExtraAlpha() {
        return this.validatedExtraAlpha;
    }

    public byte getCompRule() {
        return this.compRule;
    }

    public XRTextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public MaskTileManager getMaskBuffer() {
        return this.maskBuffer;
    }

    public XRMaskImage getMaskImage() {
        return this.maskImage;
    }
}

