/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.protocol;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.httpclient.util.LangUtils;

public class Protocol {
    private static final Map PROTOCOLS = Collections.synchronizedMap(new HashMap());
    private String scheme;
    private ProtocolSocketFactory socketFactory;
    private int defaultPort;
    private boolean secure;

    public static void registerProtocol(String string, Protocol protocol) {
        if (string == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is null");
        }
        PROTOCOLS.put(string, protocol);
    }

    public static void unregisterProtocol(String string) {
        if (string == null) {
            throw new IllegalArgumentException("id is null");
        }
        PROTOCOLS.remove(string);
    }

    public static Protocol getProtocol(String string) throws IllegalStateException {
        if (string == null) {
            throw new IllegalArgumentException("id is null");
        }
        Protocol protocol = (Protocol)PROTOCOLS.get(string);
        if (protocol == null) {
            protocol = Protocol.lazyRegisterProtocol(string);
        }
        return protocol;
    }

    private static Protocol lazyRegisterProtocol(String string) throws IllegalStateException {
        if ("http".equals(string)) {
            Protocol protocol = new Protocol("http", DefaultProtocolSocketFactory.getSocketFactory(), 80);
            Protocol.registerProtocol("http", protocol);
            return protocol;
        }
        if ("https".equals(string)) {
            Protocol protocol = new Protocol("https", SSLProtocolSocketFactory.getSocketFactory(), 443);
            Protocol.registerProtocol("https", protocol);
            return protocol;
        }
        throw new IllegalStateException("unsupported protocol: '" + string + "'");
    }

    public Protocol(String string, ProtocolSocketFactory protocolSocketFactory, int n) {
        if (string == null) {
            throw new IllegalArgumentException("scheme is null");
        }
        if (protocolSocketFactory == null) {
            throw new IllegalArgumentException("socketFactory is null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("port is invalid: " + n);
        }
        this.scheme = string;
        this.socketFactory = protocolSocketFactory;
        this.defaultPort = n;
        this.secure = protocolSocketFactory instanceof SecureProtocolSocketFactory;
    }

    public Protocol(String string, SecureProtocolSocketFactory secureProtocolSocketFactory, int n) {
        this(string, (ProtocolSocketFactory)secureProtocolSocketFactory, n);
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public ProtocolSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public int resolvePort(int n) {
        return n <= 0 ? this.getDefaultPort() : n;
    }

    public String toString() {
        return this.scheme + ":" + this.defaultPort;
    }

    public boolean equals(Object object) {
        if (object instanceof Protocol) {
            Protocol protocol = (Protocol)object;
            return this.defaultPort == protocol.getDefaultPort() && this.scheme.equalsIgnoreCase(protocol.getScheme()) && this.secure == protocol.isSecure() && this.socketFactory.equals(protocol.getSocketFactory());
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = LangUtils.hashCode(n, this.defaultPort);
        n = LangUtils.hashCode(n, this.scheme.toLowerCase());
        n = LangUtils.hashCode(n, this.secure);
        n = LangUtils.hashCode(n, this.socketFactory);
        return n;
    }
}

