/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import org.apache.subversion.javahl.types.Revision;

public class RevisionRange
implements Comparable<RevisionRange>,
Serializable {
    private static final long serialVersionUID = 2L;
    private Revision from;
    private Revision to;
    private boolean inheritable;

    protected RevisionRange(long l, long l2, boolean bl) {
        this.from = Revision.getInstance(l);
        this.to = Revision.getInstance(l2);
        this.inheritable = bl;
    }

    public RevisionRange(Revision revision, Revision revision2, boolean bl) {
        this.from = revision;
        this.to = revision2;
        this.inheritable = bl;
    }

    public RevisionRange(Revision revision, Revision revision2) {
        this.from = revision;
        this.to = revision2;
        this.inheritable = true;
    }

    public RevisionRange(String string) {
        int n;
        if (string == null) {
            return;
        }
        boolean bl = this.inheritable = !string.endsWith("*");
        if (!this.inheritable) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = string.indexOf(45)) > 0) {
            try {
                long l = Long.parseLong(string.substring(0, n));
                long l2 = Long.parseLong(string.substring(n + 1));
                this.from = new Revision.Number(l);
                this.to = new Revision.Number(l2);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        try {
            long l = Long.parseLong(string.trim());
            if (l <= 0L) {
                return;
            }
            this.to = new Revision.Number(l);
            this.from = new Revision.Number(l - 1L);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public Revision getFromRevision() {
        return this.from;
    }

    public Revision getToRevision() {
        return this.to;
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public String toString() {
        if (this.from != null && this.to != null) {
            String string = this.from.getKind() == Revision.Kind.number && this.to.getKind() == Revision.Kind.number && ((Revision.Number)this.from).getNumber() + 1L == ((Revision.Number)this.to).getNumber() ? this.to.toString() : (this.from.equals(this.to) ? this.from.toString() : this.from.toString() + '-' + this.to.toString());
            if (!this.inheritable) {
                return string + '*';
            }
            return string;
        }
        return super.toString();
    }

    public static Long getRevisionAsLong(Revision revision) {
        long l = 0L;
        if (revision != null && revision instanceof Revision.Number) {
            l = ((Revision.Number)revision).getNumber();
        }
        return new Long(l);
    }

    public int hashCode() {
        int n = this.inheritable ? 1 : 2;
        n = 31 * n + (this.from == null ? 0 : this.from.hashCode());
        n = 31 * n + (this.to == null ? 0 : this.to.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RevisionRange revisionRange = (RevisionRange)object;
        if (this.from == null ? revisionRange.from != null : !this.from.equals(revisionRange.from)) {
            return false;
        }
        if (this.to == null ? revisionRange.to != null : !this.to.equals(revisionRange.to)) {
            return false;
        }
        return this.inheritable == revisionRange.inheritable;
    }

    @Override
    public int compareTo(RevisionRange revisionRange) {
        if (this == revisionRange) {
            return 0;
        }
        Revision revision = revisionRange.getFromRevision();
        return RevisionRange.getRevisionAsLong(this.getFromRevision()).compareTo(RevisionRange.getRevisionAsLong(revision));
    }
}

