/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.io;

import java.util.LinkedList;
import org.apache.catalina.tribes.io.BufferPool;
import org.apache.catalina.tribes.io.XByteBuffer;

class BufferPool14Impl
implements BufferPool.BufferPoolAPI {
    protected int maxSize;
    protected int size = 0;
    protected LinkedList queue = new LinkedList();

    BufferPool14Impl() {
    }

    public void setMaxSize(int bytes) {
        this.maxSize = bytes;
    }

    public synchronized int addAndGet(int val) {
        this.size += val;
        return this.size;
    }

    public synchronized XByteBuffer getBuffer(int minSize, boolean discard) {
        XByteBuffer buffer = this.queue.size() > 0 ? this.queue.remove(0) : null;
        if (buffer != null) {
            this.addAndGet(-buffer.getCapacity());
        }
        if (buffer == null) {
            buffer = new XByteBuffer(minSize, discard);
        } else if (buffer.getCapacity() <= minSize) {
            buffer.expand(minSize);
        }
        buffer.setDiscard(discard);
        buffer.reset();
        return buffer;
    }

    public synchronized void returnBuffer(XByteBuffer buffer) {
        if (this.size + buffer.getCapacity() <= this.maxSize) {
            this.addAndGet(buffer.getCapacity());
            this.queue.add(buffer);
        }
    }

    public synchronized void clear() {
        this.queue.clear();
        this.size = 0;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

