/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiling.snapshot;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceRepository;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.ui.DataSourceWindowManager;
import com.sun.tools.visualvm.profiling.snapshot.ProfilerSnapshot;
import com.sun.tools.visualvm.profiling.snapshot.ProfilerSnapshotsSupport;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.util.RequestProcessor;

final class ProfilerSnapshotProvider {
    ProfilerSnapshotProvider() {
    }

    void createSnapshot(File snapshotFile, Application application, boolean openView) {
        final ProfilerSnapshot snapshot = ProfilerSnapshot.createSnapshot(snapshotFile, (DataSource)application);
        application.getRepository().addDataSource((DataSource)snapshot);
        if (openView) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataSourceWindowManager.sharedInstance().openDataSource((DataSource)snapshot);
                }
            });
        }
    }

    void initialize() {
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new SnapshotListener(), Snapshot.class);
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new ApplicationListener(), Application.class);
    }

    private void processNewSnapshot(Snapshot snapshot) {
        if (snapshot instanceof ProfilerSnapshot) {
            return;
        }
        File snapshotFile = snapshot.getFile();
        if (snapshotFile != null && snapshotFile.isDirectory()) {
            Set<ProfilerSnapshot> snapshots = this.findSnapshots(snapshotFile, (DataSource)snapshot);
            snapshot.getRepository().addDataSources(snapshots);
        }
    }

    private void processNewApplication(Application application) {
        Storage storage = application.getStorage();
        if (storage.directoryExists()) {
            Set<ProfilerSnapshot> snapshots = this.findSnapshots(storage.getDirectory(), (DataSource)application);
            application.getRepository().addDataSources(snapshots);
        }
    }

    private Set<ProfilerSnapshot> findSnapshots(File directory, DataSource app) {
        File[] files = directory.listFiles(ProfilerSnapshotsSupport.getInstance().getCategory().getFilenameFilter());
        if (files == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<ProfilerSnapshot> snapshots = new HashSet<ProfilerSnapshot>(files.length);
        for (File file : files) {
            snapshots.add(ProfilerSnapshot.createSnapshot(file, app));
        }
        return snapshots;
    }

    private class ApplicationListener
    implements DataChangeListener<Application> {
        private ApplicationListener() {
        }

        public void dataChanged(DataChangeEvent<Application> event) {
            final Set applications = event.getAdded();
            if (!applications.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        for (Application application : applications) {
                            ProfilerSnapshotProvider.this.processNewApplication(application);
                        }
                    }
                });
            }
        }
    }

    private class SnapshotListener
    implements DataChangeListener<Snapshot> {
        private SnapshotListener() {
        }

        public void dataChanged(DataChangeEvent<Snapshot> event) {
            final Set snapshots = event.getAdded();
            if (!snapshots.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        for (Snapshot snapshot : snapshots) {
                            ProfilerSnapshotProvider.this.processNewSnapshot(snapshot);
                        }
                    }
                });
            }
        }
    }
}

