/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyString;
import org.jruby.ast.Node;
import org.jruby.lexer.ByteListLexerSource;
import org.jruby.lexer.GetsLexerSource;
import org.jruby.lexer.LexerSource;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.RubyParser;
import org.jruby.parser.RubyParserResult;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadServiceResourceInputStream;
import org.jruby.util.ByteList;

public class Parser {
    private final Ruby runtime;
    private volatile long totalTime;
    private volatile int totalBytes;

    public Parser(Ruby runtime) {
        this.runtime = runtime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public int getTotalBytes() {
        return this.totalBytes;
    }

    public Node parse(String file2, ByteList content, DynamicScope blockScope, ParserConfiguration configuration) {
        configuration.setDefaultEncoding(content.getEncoding());
        RubyArray list2 = this.getLines(configuration, this.runtime, file2);
        ByteListLexerSource lexerSource = new ByteListLexerSource(file2, configuration.getLineNumber(), content, list2);
        return this.parse(file2, lexerSource, blockScope, configuration);
    }

    public Node parse(String file2, byte[] content, DynamicScope blockScope, ParserConfiguration configuration) {
        RubyArray list2 = this.getLines(configuration, this.runtime, file2);
        ByteList in = new ByteList(content, configuration.getDefaultEncoding());
        ByteListLexerSource lexerSource = new ByteListLexerSource(file2, configuration.getLineNumber(), in, list2);
        return this.parse(file2, lexerSource, blockScope, configuration);
    }

    public Node parse(String file2, InputStream content, DynamicScope blockScope, ParserConfiguration configuration) {
        if (content instanceof LoadServiceResourceInputStream) {
            return this.parse(file2, ((LoadServiceResourceInputStream)content).getBytes(), blockScope, configuration);
        }
        RubyArray list2 = this.getLines(configuration, this.runtime, file2);
        RubyIO io2 = content instanceof FileInputStream ? new RubyFile(this.runtime, file2, ((FileInputStream)content).getChannel()) : RubyIO.newIO(this.runtime, Channels.newChannel(content));
        GetsLexerSource lexerSource = new GetsLexerSource(file2, configuration.getLineNumber(), io2, list2, configuration.getDefaultEncoding());
        return this.parse(file2, lexerSource, blockScope, configuration);
    }

    public Node parse(String file2, LexerSource lexerSource, DynamicScope blockScope, ParserConfiguration configuration) {
        if (blockScope != null) {
            configuration.parseAsBlock(blockScope);
        }
        long startTime = System.nanoTime();
        RubyParser parser = new RubyParser(lexerSource);
        RubyParserResult result2 = null;
        parser.setWarnings(this.runtime.getWarnings());
        try {
            result2 = parser.parse(configuration);
            if (parser.lexer.isEndSeen() && configuration.isSaveData()) {
                IRubyObject verbose = this.runtime.getVerbose();
                this.runtime.setVerbose(this.runtime.getNil());
                this.runtime.defineGlobalConstant("DATA", lexerSource.getRemainingAsIO());
                this.runtime.setVerbose(verbose);
            }
        }
        catch (IOException e) {
            throw this.runtime.newSyntaxError("Problem reading source: " + e);
        }
        catch (SyntaxException e) {
            switch (e.getPid()) {
                case UNKNOWN_ENCODING: 
                case NOT_ASCII_COMPATIBLE: {
                    throw this.runtime.newArgumentError(e.getMessage());
                }
            }
            StringBuilder buffer = new StringBuilder(100);
            buffer.append(e.getFile()).append(':');
            buffer.append(e.getLine() + 1).append(": ");
            buffer.append(e.getMessage());
            throw this.runtime.newSyntaxError(buffer.toString());
        }
        if (result2.getScope() != null) {
            result2.getScope().growIfNeeded();
        }
        Node ast = result2.getAST();
        this.totalTime += System.nanoTime() - startTime;
        this.totalBytes += lexerSource.getOffset();
        if (this.runtime.getCoverageData().isCoverageEnabled()) {
            this.runtime.getCoverageData().prepareCoverage(file2, configuration.getCoverage());
        }
        return ast;
    }

    private RubyArray getLines(ParserConfiguration configuration, Ruby runtime, String file2) {
        RubyArray list2 = null;
        IRubyObject scriptLines = runtime.getObject().getConstantAt("SCRIPT_LINES__");
        if (!configuration.isEvalParse() && scriptLines != null && scriptLines instanceof RubyHash) {
            RubyString filename2 = runtime.newString(file2);
            ThreadContext context = runtime.getCurrentContext();
            IRubyObject object = ((RubyHash)scriptLines).op_aref(context, filename2);
            list2 = (RubyArray)(object instanceof RubyArray ? object : runtime.newArray());
            ((RubyHash)scriptLines).op_aset(context, filename2, list2);
        }
        return list2;
    }
}

