/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.StringCachingGuards;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;

@GeneratedBy(value=KernelNodes.class)
public final class KernelNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(BacktickNodeFactory.getInstance(), SameOrEqualNodeFactory.getInstance(), MatchNodeFactory.getInstance(), NotMatchNodeFactory.getInstance(), CompareNodeFactory.getInstance(), BindingNodeFactory.getInstance(), BlockGivenNodeFactory.getInstance(), CalleeNameNodeFactory.getInstance(), CallerLocationsNodeFactory.getInstance(), KernelClassNodeFactory.getInstance(), CopyNodeFactory.getInstance(), CloneNodeFactory.getInstance(), DupNodeFactory.getInstance(), EvalNodeFactory.getInstance(), ExecNodeFactory.getInstance(), ForkNodeFactory.getInstance(), KernelFreezeNodeFactory.getInstance(), KernelFrozenNodeFactory.getInstance(), GetsNodeFactory.getInstance(), HashNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), InitializeDupCloneNodeFactory.getInstance(), InstanceOfNodeFactory.getInstance(), InstanceVariableDefinedNodeFactory.getInstance(), InstanceVariableGetNodeFactory.getInstance(), InstanceVariableSetNodeFactory.getInstance(), RemoveInstanceVariableNodeFactory.getInstance(), InstanceVariablesNodeFactory.getInstance(), KernelIsANodeFactory.getInstance(), LambdaNodeFactory.getInstance(), LocalVariablesNodeFactory.getInstance(), MethodNameNodeFactory.getInstance(), MethodNodeFactory.getInstance(), MethodsNodeFactory.getInstance(), NilNodeFactory.getInstance(), PrivateMethodsNodeFactory.getInstance(), ProcNodeFactory.getInstance(), ProtectedMethodsNodeFactory.getInstance(), PublicMethodsNodeFactory.getInstance(), PublicSendNodeFactory.getInstance(), RandNodeFactory.getInstance(), RequireNodeFactory.getInstance(), RequireRelativeNodeFactory.getInstance(), RespondToNodeFactory.getInstance(), RespondToMissingNodeFactory.getInstance(), SetTraceFuncNodeFactory.getInstance(), SingletonClassMethodNodeFactory.getInstance(), SingletonMethodsNodeFactory.getInstance(), StringNodeFactory.getInstance(), SleepNodeFactory.getInstance(), SprintfNodeFactory.getInstance(), KernelTaintNodeFactory.getInstance(), KernelIsTaintedNodeFactory.getInstance(), ToHexStringNodeFactory.getInstance(), ToSNodeFactory.getInstance(), UntaintNodeFactory.getInstance());
    }

    @GeneratedBy(value=KernelNodes.UntaintNode.class)
    public static final class UntaintNodeFactory
    extends NodeFactoryBase<KernelNodes.UntaintNode> {
        private static UntaintNodeFactory untaintNodeFactoryInstance;

        private UntaintNodeFactory() {
            super(KernelNodes.UntaintNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.UntaintNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UntaintNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.UntaintNode> getInstance() {
            if (untaintNodeFactoryInstance == null) {
                untaintNodeFactoryInstance = new UntaintNodeFactory();
            }
            return untaintNodeFactoryInstance;
        }

        public static KernelNodes.UntaintNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new UntaintNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.UntaintNode.class)
        public static final class UntaintNodeGen
        extends KernelNodes.UntaintNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private UntaintNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.taint(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<KernelNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(KernelNodes.ToSNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static KernelNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToSNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends KernelNodes.ToSNode {
            @Node.Child
            private RubyNode arguments0_;

            private ToSNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public DynamicObject executeToS(VirtualFrame frameValue, Object arguments0Value) {
                return this.toS(frameValue, arguments0Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.toS(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
    public static final class ToHexStringNodeFactory
    extends NodeFactoryBase<KernelNodes.ToHexStringNode> {
        private static ToHexStringNodeFactory toHexStringNodeFactoryInstance;

        private ToHexStringNodeFactory() {
            super(KernelNodes.ToHexStringNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.ToHexStringNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToHexStringNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ToHexStringNode> getInstance() {
            if (toHexStringNodeFactoryInstance == null) {
                toHexStringNodeFactoryInstance = new ToHexStringNodeFactory();
            }
            return toHexStringNodeFactoryInstance;
        }

        public static KernelNodes.ToHexStringNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ToHexStringNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
        public static final class ToHexStringNodeGen
        extends KernelNodes.ToHexStringNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ToHexStringNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public String executeToHexString(VirtualFrame frameValue, Object arguments0Value) {
                return this.specialization_.executeString(frameValue, arguments0Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="toHexString(DynamicObject)", value=KernelNodes.ToHexStringNode.class)
            private static final class ToHexString2Node_
            extends BaseNode_ {
                ToHexString2Node_(ToHexStringNodeGen root) {
                    super(root, 3);
                }

                @Override
                public String executeString(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.toHexString(arguments0Value_);
                    }
                    return this.getNext().executeString(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToHexStringNodeGen root) {
                    return new ToHexString2Node_(root);
                }
            }

            @GeneratedBy(methodName="toHexString(long)", value=KernelNodes.ToHexStringNode.class)
            private static final class ToHexString1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                ToHexString1Node_(ToHexStringNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((ToHexString1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeString(frameValue, ex.getResult());
                    }
                    return this.root.toHexString(arguments0Value_);
                }

                @Override
                public String executeString(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.toHexString(arguments0Value_);
                    }
                    return this.getNext().executeString(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToHexStringNodeGen root, Object arguments0Value) {
                    return new ToHexString1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="toHexString(int)", value=KernelNodes.ToHexStringNode.class)
            private static final class ToHexString0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                ToHexString0Node_(ToHexStringNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((ToHexString0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeString(frameValue, ex.getResult());
                    }
                    return this.root.toHexString(arguments0Value_);
                }

                @Override
                public String executeString(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.toHexString(arguments0Value_);
                    }
                    return this.getNext().executeString(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToHexStringNodeGen root, Object arguments0Value) {
                    return new ToHexString0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ToHexStringNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public String executeString(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeString(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToHexStringNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ToHexStringNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public String executeString(VirtualFrame frameValue, Object arguments0Value) {
                    return (String)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ToHexStringNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ToHexStringNodeGen root;

                BaseNode_(ToHexStringNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ToHexStringNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeString((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract String executeString(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeString(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return ToHexString0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return ToHexString1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return ToHexString2Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelIsTaintedNode.class)
    public static final class KernelIsTaintedNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelIsTaintedNode> {
        private static KernelIsTaintedNodeFactory kernelIsTaintedNodeFactoryInstance;

        private KernelIsTaintedNodeFactory() {
            super(KernelNodes.KernelIsTaintedNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.KernelIsTaintedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelIsTaintedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.KernelIsTaintedNode> getInstance() {
            if (kernelIsTaintedNodeFactoryInstance == null) {
                kernelIsTaintedNodeFactoryInstance = new KernelIsTaintedNodeFactory();
            }
            return kernelIsTaintedNodeFactoryInstance;
        }

        public static KernelNodes.KernelIsTaintedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new KernelIsTaintedNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.KernelIsTaintedNode.class)
        public static final class KernelIsTaintedNodeGen
        extends KernelNodes.KernelIsTaintedNode {
            @Node.Child
            private RubyNode arguments0_;

            private KernelIsTaintedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.isTainted(arguments0Value_);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelTaintNode.class)
    public static final class KernelTaintNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelTaintNode> {
        private static KernelTaintNodeFactory kernelTaintNodeFactoryInstance;

        private KernelTaintNodeFactory() {
            super(KernelNodes.KernelTaintNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.KernelTaintNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelTaintNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.KernelTaintNode> getInstance() {
            if (kernelTaintNodeFactoryInstance == null) {
                kernelTaintNodeFactoryInstance = new KernelTaintNodeFactory();
            }
            return kernelTaintNodeFactoryInstance;
        }

        public static KernelNodes.KernelTaintNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new KernelTaintNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.KernelTaintNode.class)
        public static final class KernelTaintNodeGen
        extends KernelNodes.KernelTaintNode {
            @Node.Child
            private RubyNode arguments0_;

            private KernelTaintNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.taint(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SprintfNode.class)
    public static final class SprintfNodeFactory
    extends NodeFactoryBase<KernelNodes.SprintfNode> {
        private static SprintfNodeFactory sprintfNodeFactoryInstance;

        private SprintfNodeFactory() {
            super(KernelNodes.SprintfNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.SprintfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SprintfNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.SprintfNode> getInstance() {
            if (sprintfNodeFactoryInstance == null) {
                sprintfNodeFactoryInstance = new SprintfNodeFactory();
            }
            return sprintfNodeFactoryInstance;
        }

        public static KernelNodes.SprintfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SprintfNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.SprintfNode.class)
        public static final class SprintfNodeGen
        extends KernelNodes.SprintfNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeFormatCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private SprintfNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="formatUncached(VirtualFrame, DynamicObject, Object[], IndirectCallNode)", value=KernelNodes.SprintfNode.class)
            private static final class FormatUncachedNode_
            extends BaseNode_ {
                @Node.Child
                private IndirectCallNode callPackNode;

                FormatUncachedNode_(SprintfNodeGen root, IndirectCallNode callPackNode) {
                    super(root, 2);
                    this.callPackNode = callPackNode;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_)) {
                            return this.root.formatUncached(frameValue, arguments0Value_, arguments1Value_, this.callPackNode);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SprintfNodeGen root, IndirectCallNode callPackNode) {
                    return new FormatUncachedNode_(root, callPackNode);
                }
            }

            @GeneratedBy(methodName="formatCached(VirtualFrame, DynamicObject, Object[], ByteList, int, DirectCallNode)", value=KernelNodes.SprintfNode.class)
            private static final class FormatCachedNode_
            extends BaseNode_ {
                private final ByteList cachedFormat;
                private final int cachedFormatLength;
                @Node.Child
                private DirectCallNode callPackNode;

                FormatCachedNode_(SprintfNodeGen root, ByteList cachedFormat, int cachedFormatLength, DirectCallNode callPackNode) {
                    super(root, 1);
                    this.cachedFormat = cachedFormat;
                    this.cachedFormatLength = cachedFormatLength;
                    this.callPackNode = callPackNode;
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == FormatUncachedNode_.class) {
                        this.removeSame("Contained by formatUncached(VirtualFrame, DynamicObject, Object[], IndirectCallNode)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    return arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[] && RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value) && StringCachingGuards.byteListsEqual(arguments0Value_, this.cachedFormat);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_) && StringCachingGuards.byteListsEqual(arguments0Value_, this.cachedFormat)) {
                            return this.root.formatCached(frameValue, arguments0Value_, arguments1Value_, this.cachedFormat, this.cachedFormatLength, this.callPackNode);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SprintfNodeGen root, ByteList cachedFormat, int cachedFormatLength, DirectCallNode callPackNode) {
                    return new FormatCachedNode_(root, cachedFormat, cachedFormatLength, callPackNode);
                }
            }

            @GeneratedBy(value=KernelNodes.SprintfNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SprintfNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SprintfNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SprintfNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SprintfNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SprintfNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SprintfNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SprintfNodeGen root;

                BaseNode_(SprintfNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SprintfNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof Object[]) {
                        DirectCallNode callPackNode1;
                        int cachedFormatLength1;
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        ByteList cachedFormat1 = StringCachingGuards.privatizeByteList(arguments0Value_);
                        if (RubyGuards.isRubyString(arguments0Value_) && StringCachingGuards.byteListsEqual(arguments0Value_, cachedFormat1) && !this.root.excludeFormatCached_ && this.countSame(s = FormatCachedNode_.create(this.root, cachedFormat1, cachedFormatLength1 = StringCachingGuards.byteListLength(cachedFormat1), callPackNode1 = DirectCallNode.create(this.root.compileFormat(arguments0Value_)))) < 3) {
                            return s;
                        }
                        if (RubyGuards.isRubyString(arguments0Value_)) {
                            IndirectCallNode callPackNode2 = IndirectCallNode.create();
                            this.root.excludeFormatCached_ = true;
                            return FormatUncachedNode_.create(this.root, callPackNode2);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SleepNode.class)
    public static final class SleepNodeFactory
    extends NodeFactoryBase<KernelNodes.SleepNode> {
        private static SleepNodeFactory sleepNodeFactoryInstance;

        private SleepNodeFactory() {
            super(KernelNodes.SleepNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.SleepNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SleepNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.SleepNode> getInstance() {
            if (sleepNodeFactoryInstance == null) {
                sleepNodeFactoryInstance = new SleepNodeFactory();
            }
            return sleepNodeFactoryInstance;
        }

        public static KernelNodes.SleepNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SleepNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.SleepNode.class)
        public static final class SleepNodeGen
        extends KernelNodes.SleepNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SleepNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="sleep(VirtualFrame, DynamicObject)", value=KernelNodes.SleepNode.class)
            private static final class Sleep5Node_
            extends BaseNode_ {
                Sleep5Node_(SleepNodeGen root) {
                    super(root, 6);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    if (!this.root.isRubiniusUndefined(arguments0Value_)) {
                        return this.root.sleep(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && !this.root.isRubiniusUndefined(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.sleep(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new Sleep5Node_(root);
                }
            }

            @GeneratedBy(methodName="sleep(DynamicObject)", value=KernelNodes.SleepNode.class)
            private static final class Sleep4Node_
            extends BaseNode_ {
                Sleep4Node_(SleepNodeGen root) {
                    super(root, 5);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    if (this.root.isRubiniusUndefined(arguments0Value_)) {
                        return this.root.sleep(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && this.root.isRubiniusUndefined(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.sleep(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new Sleep4Node_(root);
                }
            }

            @GeneratedBy(methodName="sleep(double)", value=KernelNodes.SleepNode.class)
            private static final class Sleep3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Sleep3Node_(SleepNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Sleep3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    return this.root.sleep(arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.sleep(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root, Object arguments0Value) {
                    return new Sleep3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="sleep(long)", value=KernelNodes.SleepNode.class)
            private static final class Sleep2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Sleep2Node_(SleepNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Sleep2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    return this.root.sleep(arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.sleep(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root, Object arguments0Value) {
                    return new Sleep2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="sleep(int)", value=KernelNodes.SleepNode.class)
            private static final class Sleep1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Sleep1Node_(SleepNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Sleep1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    return this.root.sleep(arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.sleep(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root, Object arguments0Value) {
                    return new Sleep1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="sleep(NotProvided)", value=KernelNodes.SleepNode.class)
            private static final class Sleep0Node_
            extends BaseNode_ {
                Sleep0Node_(SleepNodeGen root) {
                    super(root, 1);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    NotProvided arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    return this.root.sleep(arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        return this.root.sleep(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new Sleep0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SleepNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SleepNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeLong_(frameValue, arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SleepNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SleepNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Long)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SleepNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SleepNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SleepNodeGen root;

                BaseNode_(SleepNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SleepNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeLong_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract long executeLong_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeLong_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public long executeLong(VirtualFrame frameValue) {
                    return (Long)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        return Sleep0Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Sleep1Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Sleep2Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Sleep3Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (this.root.isRubiniusUndefined(arguments0Value_)) {
                            return Sleep4Node_.create(this.root);
                        }
                        return Sleep5Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.StringNode.class)
    public static final class StringNodeFactory
    extends NodeFactoryBase<KernelNodes.StringNode> {
        private static StringNodeFactory stringNodeFactoryInstance;

        private StringNodeFactory() {
            super(KernelNodes.StringNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.StringNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.StringNode> getInstance() {
            if (stringNodeFactoryInstance == null) {
                stringNodeFactoryInstance = new StringNodeFactory();
            }
            return stringNodeFactoryInstance;
        }

        public static KernelNodes.StringNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new StringNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.StringNode.class)
        public static final class StringNodeGen
        extends KernelNodes.StringNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private StringNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="string(VirtualFrame, Object)", value=KernelNodes.StringNode.class)
            private static final class String1Node_
            extends BaseNode_ {
                String1Node_(StringNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (!RubyGuards.isRubyString(arguments0Value)) {
                        return this.root.string(frameValue, arguments0Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(StringNodeGen root) {
                    return new String1Node_(root);
                }
            }

            @GeneratedBy(methodName="string(DynamicObject)", value=KernelNodes.StringNode.class)
            private static final class String0Node_
            extends BaseNode_ {
                String0Node_(StringNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.string(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(StringNodeGen root) {
                    return new String0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.StringNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(StringNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(StringNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.StringNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(StringNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(StringNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.StringNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected StringNodeGen root;

                BaseNode_(StringNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (StringNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return String0Node_.create(this.root);
                    }
                    if (!RubyGuards.isRubyString(arguments0Value)) {
                        return String1Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SingletonMethodsNode.class)
    public static final class SingletonMethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.SingletonMethodsNode> {
        private static SingletonMethodsNodeFactory singletonMethodsNodeFactoryInstance;

        private SingletonMethodsNodeFactory() {
            super(KernelNodes.SingletonMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.SingletonMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return SingletonMethodsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.SingletonMethodsNode> getInstance() {
            if (singletonMethodsNodeFactoryInstance == null) {
                singletonMethodsNodeFactoryInstance = new SingletonMethodsNodeFactory();
            }
            return singletonMethodsNodeFactoryInstance;
        }

        public static KernelNodes.SingletonMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
            return new SingletonMethodsNodeGen(context, sourceSection, object, includeAncestors);
        }

        @GeneratedBy(value=KernelNodes.SingletonMethodsNode.class)
        public static final class SingletonMethodsNodeGen
        extends KernelNodes.SingletonMethodsNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode includeAncestors_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SingletonMethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
                super(context, sourceSection);
                this.object_ = object;
                this.includeAncestors_ = this.coerceToBoolean(includeAncestors);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public DynamicObject executeSingletonMethods(VirtualFrame frameValue, Object objectValue, boolean includeAncestorsValue) {
                return this.singletonMethods(objectValue, includeAncestorsValue);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDynamicObject(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                boolean includeAncestorsValue_;
                Object objectValue_ = this.object_.execute(frameValue);
                try {
                    includeAncestorsValue_ = this.includeAncestors_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(objectValue_, ex.getResult());
                }
                return this.singletonMethods(objectValue_, includeAncestorsValue_);
            }

            private UnsupportedSpecializationException unsupported(Object objectValue, Object includeAncestorsValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.object_, this.includeAncestors_}, objectValue, includeAncestorsValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SingletonClassMethodNode.class)
    public static final class SingletonClassMethodNodeFactory
    extends NodeFactoryBase<KernelNodes.SingletonClassMethodNode> {
        private static SingletonClassMethodNodeFactory singletonClassMethodNodeFactoryInstance;

        private SingletonClassMethodNodeFactory() {
            super(KernelNodes.SingletonClassMethodNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.SingletonClassMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SingletonClassMethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.SingletonClassMethodNode> getInstance() {
            if (singletonClassMethodNodeFactoryInstance == null) {
                singletonClassMethodNodeFactoryInstance = new SingletonClassMethodNodeFactory();
            }
            return singletonClassMethodNodeFactoryInstance;
        }

        public static KernelNodes.SingletonClassMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SingletonClassMethodNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.SingletonClassMethodNode.class)
        public static final class SingletonClassMethodNodeGen
        extends KernelNodes.SingletonClassMethodNode {
            @Node.Child
            private RubyNode arguments0_;

            private SingletonClassMethodNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.singletonClass(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
    public static final class SetTraceFuncNodeFactory
    extends NodeFactoryBase<KernelNodes.SetTraceFuncNode> {
        private static SetTraceFuncNodeFactory setTraceFuncNodeFactoryInstance;

        private SetTraceFuncNodeFactory() {
            super(KernelNodes.SetTraceFuncNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.SetTraceFuncNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetTraceFuncNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.SetTraceFuncNode> getInstance() {
            if (setTraceFuncNodeFactoryInstance == null) {
                setTraceFuncNodeFactoryInstance = new SetTraceFuncNodeFactory();
            }
            return setTraceFuncNodeFactoryInstance;
        }

        public static KernelNodes.SetTraceFuncNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SetTraceFuncNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
        public static final class SetTraceFuncNodeGen
        extends KernelNodes.SetTraceFuncNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private SetTraceFuncNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="setTraceFunc(DynamicObject)", value=KernelNodes.SetTraceFuncNode.class)
            private static final class SetTraceFunc1Node_
            extends BaseNode_ {
                SetTraceFunc1Node_(SetTraceFuncNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyProc(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.setTraceFunc(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetTraceFuncNodeGen root) {
                    return new SetTraceFunc1Node_(root);
                }
            }

            @GeneratedBy(methodName="setTraceFunc(Object)", value=KernelNodes.SetTraceFuncNode.class)
            private static final class SetTraceFunc0Node_
            extends BaseNode_ {
                SetTraceFunc0Node_(SetTraceFuncNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.root.isNil(arguments0Value)) {
                        return this.root.setTraceFunc(arguments0Value);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetTraceFuncNodeGen root) {
                    return new SetTraceFunc0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SetTraceFuncNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetTraceFuncNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SetTraceFuncNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SetTraceFuncNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SetTraceFuncNodeGen root;

                BaseNode_(SetTraceFuncNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SetTraceFuncNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (this.root.isNil(arguments0Value)) {
                        return SetTraceFunc0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyProc(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return SetTraceFunc1Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
    public static final class RespondToMissingNodeFactory
    extends NodeFactoryBase<KernelNodes.RespondToMissingNode> {
        private static RespondToMissingNodeFactory respondToMissingNodeFactoryInstance;

        private RespondToMissingNodeFactory() {
            super(KernelNodes.RespondToMissingNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.RespondToMissingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RespondToMissingNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.RespondToMissingNode> getInstance() {
            if (respondToMissingNodeFactoryInstance == null) {
                respondToMissingNodeFactoryInstance = new RespondToMissingNodeFactory();
            }
            return respondToMissingNodeFactoryInstance;
        }

        public static KernelNodes.RespondToMissingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RespondToMissingNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
        public static final class RespondToMissingNodeGen
        extends KernelNodes.RespondToMissingNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private BaseNode_ specialization_;

            private RespondToMissingNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="doesRespondToMissingSymbol(Object, DynamicObject, Object)", value=KernelNodes.RespondToMissingNode.class)
            private static final class EsRespondToMissingSymbolNode_
            extends BaseNode_ {
                EsRespondToMissingSymbolNode_(RespondToMissingNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    if (RubyGuards.isRubySymbol(arguments1Value_)) {
                        return this.root.doesRespondToMissingSymbol(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    DynamicObject arguments1Value_;
                    if (arguments1Value instanceof DynamicObject && RubyGuards.isRubySymbol(arguments1Value_ = (DynamicObject)arguments1Value)) {
                        return this.root.doesRespondToMissingSymbol(arguments0Value, arguments1Value_, arguments2Value);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RespondToMissingNodeGen root) {
                    return new EsRespondToMissingSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="doesRespondToMissingString(Object, DynamicObject, Object)", value=KernelNodes.RespondToMissingNode.class)
            private static final class EsRespondToMissingStringNode_
            extends BaseNode_ {
                EsRespondToMissingStringNode_(RespondToMissingNodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.root.arguments2_.execute(frameValue);
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    if (RubyGuards.isRubyString(arguments1Value_)) {
                        return this.root.doesRespondToMissingString(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    DynamicObject arguments1Value_;
                    if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value)) {
                        return this.root.doesRespondToMissingString(arguments0Value, arguments1Value_, arguments2Value);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RespondToMissingNodeGen root) {
                    return new EsRespondToMissingStringNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RespondToMissingNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RespondToMissingNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RespondToMissingNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(RespondToMissingNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected RespondToMissingNodeGen root;

                BaseNode_(RespondToMissingNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (RespondToMissingNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return EsRespondToMissingStringNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return EsRespondToMissingSymbolNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RespondToNode.class)
    public static final class RespondToNodeFactory
    extends NodeFactoryBase<KernelNodes.RespondToNode> {
        private static RespondToNodeFactory respondToNodeFactoryInstance;

        private RespondToNodeFactory() {
            super(KernelNodes.RespondToNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.RespondToNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return RespondToNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.RespondToNode> getInstance() {
            if (respondToNodeFactoryInstance == null) {
                respondToNodeFactoryInstance = new RespondToNodeFactory();
            }
            return respondToNodeFactoryInstance;
        }

        public static KernelNodes.RespondToNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name, RubyNode includeProtectedAndPrivate) {
            return new RespondToNodeGen(context, sourceSection, object, name, includeProtectedAndPrivate);
        }

        @GeneratedBy(value=KernelNodes.RespondToNode.class)
        public static final class RespondToNodeGen
        extends KernelNodes.RespondToNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private RubyNode includeProtectedAndPrivate_;
            @CompilerDirectives.CompilationFinal
            private Class<?> includeProtectedAndPrivateType_;
            @Node.Child
            private BaseNode_ specialization_;

            private RespondToNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name, RubyNode includeProtectedAndPrivate) {
                super(context, sourceSection);
                this.object_ = object;
                this.name_ = name;
                this.includeProtectedAndPrivate_ = this.coerceToBoolean(includeProtectedAndPrivate);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public boolean executeDoesRespondTo(VirtualFrame frameValue, Object objectValue, Object nameValue, boolean includeProtectedAndPrivateValue) {
                return this.specialization_.executeBoolean1(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean0(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="doesRespondToSymbol(VirtualFrame, Object, DynamicObject, boolean)", value=KernelNodes.RespondToNode.class)
            private static final class EsRespondToSymbolNode_
            extends BaseNode_ {
                EsRespondToSymbolNode_(RespondToNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean0(frameValue);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    boolean includeProtectedAndPrivateValue_;
                    DynamicObject nameValue_;
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    try {
                        nameValue_ = this.root.name_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object includeProtectedAndPrivateValue = this.executeIncludeProtectedAndPrivate_(frameValue);
                        return this.getNext().executeBoolean_(frameValue, objectValue_, ex.getResult(), includeProtectedAndPrivateValue);
                    }
                    try {
                        includeProtectedAndPrivateValue_ = this.root.includeProtectedAndPrivate_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, objectValue_, nameValue_, ex.getResult());
                    }
                    if (RubyGuards.isRubySymbol(nameValue_)) {
                        return this.root.doesRespondToSymbol(frameValue, objectValue_, nameValue_, includeProtectedAndPrivateValue_);
                    }
                    return this.getNext().executeBoolean_(frameValue, objectValue_, nameValue_, includeProtectedAndPrivateValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object objectValue, Object nameValue, boolean includeProtectedAndPrivateValue) {
                    DynamicObject nameValue_;
                    if (nameValue instanceof DynamicObject && RubyGuards.isRubySymbol(nameValue_ = (DynamicObject)nameValue)) {
                        return this.root.doesRespondToSymbol(frameValue, objectValue, nameValue_, includeProtectedAndPrivateValue);
                    }
                    return this.getNext().executeBoolean1(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    if (nameValue instanceof DynamicObject && includeProtectedAndPrivateValue instanceof Boolean) {
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        boolean includeProtectedAndPrivateValue_ = (Boolean)includeProtectedAndPrivateValue;
                        if (RubyGuards.isRubySymbol(nameValue_)) {
                            return this.root.doesRespondToSymbol(frameValue, objectValue, nameValue_, includeProtectedAndPrivateValue_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                static BaseNode_ create(RespondToNodeGen root) {
                    return new EsRespondToSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="doesRespondToString(VirtualFrame, Object, DynamicObject, boolean)", value=KernelNodes.RespondToNode.class)
            private static final class EsRespondToStringNode_
            extends BaseNode_ {
                EsRespondToStringNode_(RespondToNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean0(frameValue);
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    boolean includeProtectedAndPrivateValue_;
                    DynamicObject nameValue_;
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    try {
                        nameValue_ = this.root.name_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object includeProtectedAndPrivateValue = this.executeIncludeProtectedAndPrivate_(frameValue);
                        return this.getNext().executeBoolean_(frameValue, objectValue_, ex.getResult(), includeProtectedAndPrivateValue);
                    }
                    try {
                        includeProtectedAndPrivateValue_ = this.root.includeProtectedAndPrivate_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, objectValue_, nameValue_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(nameValue_)) {
                        return this.root.doesRespondToString(frameValue, objectValue_, nameValue_, includeProtectedAndPrivateValue_);
                    }
                    return this.getNext().executeBoolean_(frameValue, objectValue_, nameValue_, includeProtectedAndPrivateValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object objectValue, Object nameValue, boolean includeProtectedAndPrivateValue) {
                    DynamicObject nameValue_;
                    if (nameValue instanceof DynamicObject && RubyGuards.isRubyString(nameValue_ = (DynamicObject)nameValue)) {
                        return this.root.doesRespondToString(frameValue, objectValue, nameValue_, includeProtectedAndPrivateValue);
                    }
                    return this.getNext().executeBoolean1(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    if (nameValue instanceof DynamicObject && includeProtectedAndPrivateValue instanceof Boolean) {
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        boolean includeProtectedAndPrivateValue_ = (Boolean)includeProtectedAndPrivateValue;
                        if (RubyGuards.isRubyString(nameValue_)) {
                            return this.root.doesRespondToString(frameValue, objectValue, nameValue_, includeProtectedAndPrivateValue_);
                        }
                    }
                    return this.getNext().executeBoolean_(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                static BaseNode_ create(RespondToNodeGen root) {
                    return new EsRespondToStringNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RespondToNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RespondToNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, objectValue, nameValue, includeProtectedAndPrivateValue));
                }

                @Override
                public boolean executeBoolean0(VirtualFrame frameValue) {
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    Object nameValue_ = this.root.name_.execute(frameValue);
                    Object includeProtectedAndPrivateValue_ = this.executeIncludeProtectedAndPrivate_(frameValue);
                    return this.getNext().executeBoolean_(frameValue, objectValue_, nameValue_, includeProtectedAndPrivateValue_);
                }

                @Override
                public boolean executeBoolean1(VirtualFrame frameValue, Object objectValue, Object nameValue, boolean includeProtectedAndPrivateValue) {
                    return this.getNext().executeBoolean1(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    return this.getNext().executeBoolean_(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                static BaseNode_ create(RespondToNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RespondToNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RespondToNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    return (Boolean)this.uninitialized((Frame)frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                static BaseNode_ create(RespondToNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RespondToNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected RespondToNodeGen root;

                BaseNode_(RespondToNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (RespondToNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.object_, this.root.name_, this.root.includeProtectedAndPrivate_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    return this.executeBoolean_((VirtualFrame)frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public boolean executeBoolean1(VirtualFrame frameValue, Object objectValue, Object nameValue, boolean includeProtectedAndPrivateValue) {
                    return this.executeBoolean_(frameValue, objectValue, nameValue, includeProtectedAndPrivateValue);
                }

                public Object execute(VirtualFrame frameValue) {
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    Object nameValue_ = this.root.name_.execute(frameValue);
                    Object includeProtectedAndPrivateValue_ = this.executeIncludeProtectedAndPrivate_(frameValue);
                    return this.executeBoolean_(frameValue, objectValue_, nameValue_, includeProtectedAndPrivateValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean0(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object objectValue, Object nameValue, Object includeProtectedAndPrivateValue) {
                    if (nameValue instanceof DynamicObject && includeProtectedAndPrivateValue instanceof Boolean) {
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        if (RubyGuards.isRubyString(nameValue_)) {
                            return EsRespondToStringNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(nameValue_)) {
                            return EsRespondToSymbolNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeIncludeProtectedAndPrivate_(Frame frameValue) {
                    Object object;
                    Class includeProtectedAndPrivateType_ = this.root.includeProtectedAndPrivateType_;
                    if (includeProtectedAndPrivateType_ == Boolean.TYPE) {
                        return this.root.includeProtectedAndPrivate_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (includeProtectedAndPrivateType_ != null) return this.root.includeProtectedAndPrivate_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.includeProtectedAndPrivate_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.includeProtectedAndPrivateType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.includeProtectedAndPrivateType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.includeProtectedAndPrivateType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RequireRelativeNode.class)
    public static final class RequireRelativeNodeFactory
    extends NodeFactoryBase<KernelNodes.RequireRelativeNode> {
        private static RequireRelativeNodeFactory requireRelativeNodeFactoryInstance;

        private RequireRelativeNodeFactory() {
            super(KernelNodes.RequireRelativeNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.RequireRelativeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RequireRelativeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.RequireRelativeNode> getInstance() {
            if (requireRelativeNodeFactoryInstance == null) {
                requireRelativeNodeFactoryInstance = new RequireRelativeNodeFactory();
            }
            return requireRelativeNodeFactoryInstance;
        }

        public static KernelNodes.RequireRelativeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RequireRelativeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.RequireRelativeNode.class)
        public static final class RequireRelativeNodeGen
        extends KernelNodes.RequireRelativeNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private RequireRelativeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments0Value_)) {
                    return this.requireRelative(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RequireNode.class)
    public static final class RequireNodeFactory
    extends NodeFactoryBase<KernelNodes.RequireNode> {
        private static RequireNodeFactory requireNodeFactoryInstance;

        private RequireNodeFactory() {
            super(KernelNodes.RequireNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.RequireNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return RequireNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.RequireNode> getInstance() {
            if (requireNodeFactoryInstance == null) {
                requireNodeFactoryInstance = new RequireNodeFactory();
            }
            return requireNodeFactoryInstance;
        }

        public static KernelNodes.RequireNode create(RubyContext context, SourceSection sourceSection, RubyNode feature) {
            return new RequireNodeGen(context, sourceSection, feature);
        }

        @GeneratedBy(value=KernelNodes.RequireNode.class)
        public static final class RequireNodeGen
        extends KernelNodes.RequireNode {
            @Node.Child
            private RubyNode feature_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private RequireNodeGen(RubyContext context, SourceSection sourceSection, RubyNode feature) {
                super(context, sourceSection);
                this.feature_ = this.coerceFeatureToPath(feature);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject featureValue_;
                try {
                    featureValue_ = this.feature_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyString(featureValue_)) {
                    return this.require(featureValue_);
                }
                throw this.unsupported(featureValue_);
            }

            private UnsupportedSpecializationException unsupported(Object featureValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.feature_}, featureValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RandNode.class)
    public static final class RandNodeFactory
    extends NodeFactoryBase<KernelNodes.RandNode> {
        private static RandNodeFactory randNodeFactoryInstance;

        private RandNodeFactory() {
            super(KernelNodes.RandNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.RandNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RandNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.RandNode> getInstance() {
            if (randNodeFactoryInstance == null) {
                randNodeFactoryInstance = new RandNodeFactory();
            }
            return randNodeFactoryInstance;
        }

        public static KernelNodes.RandNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new RandNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.RandNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class RandNodeGen
        extends KernelNodes.RandNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private RandNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="randNonZero(long)", value=KernelNodes.RandNode.class)
            private static final class RandNonZero1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                RandNonZero1Node_(RandNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((RandNonZero1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return RandNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (arguments0Value_ != 0L) {
                        return this.root.randNonZero(arguments0Value_);
                    }
                    return RandNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && (arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType)) != 0L) {
                        return this.root.randNonZero(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root, Object arguments0Value) {
                    return new RandNonZero1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="randZero(long)", value=KernelNodes.RandNode.class)
            private static final class RandZero1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                RandZero1Node_(RandNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((RandZero1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return RandNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (arguments0Value_ == 0L) {
                        return this.root.randZero(arguments0Value_);
                    }
                    return RandNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && (arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType)) == 0L) {
                        return this.root.randZero(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root, Object arguments0Value) {
                    return new RandZero1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="randNonZero(int)", value=KernelNodes.RandNode.class)
            private static final class RandNonZero0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                RandNonZero0Node_(RandNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((RandNonZero0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return RandNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (arguments0Value_ != 0) {
                        return this.root.randNonZero(arguments0Value_);
                    }
                    return RandNodeGen.expectInteger(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    int arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && (arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType)) != 0) {
                        return this.root.randNonZero(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root, Object arguments0Value) {
                    return new RandNonZero0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="randZero(int)", value=KernelNodes.RandNode.class)
            private static final class RandZero0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                RandZero0Node_(RandNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((RandZero0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return RandNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (arguments0Value_ == 0) {
                        return this.root.randZero(arguments0Value_);
                    }
                    return RandNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    int arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && (arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType)) == 0) {
                        return this.root.randZero(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root, Object arguments0Value) {
                    return new RandZero0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="rand(NotProvided)", value=KernelNodes.RandNode.class)
            private static final class RandNode_
            extends BaseNode_ {
                RandNode_(RandNodeGen root) {
                    super(root, 1);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    NotProvided arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return RandNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.rand(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        return this.root.rand(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root) {
                    return new RandNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RandNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(RandNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RandNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(RandNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(RandNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.RandNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected RandNodeGen root;

                BaseNode_(RandNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (RandNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return RandNodeGen.expectDouble(this.execute(frameValue));
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return RandNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return RandNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        return RandNode_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value);
                        if (arguments0Value_ == 0) {
                            return RandZero0Node_.create(this.root, arguments0Value);
                        }
                        if (arguments0Value_ != 0) {
                            return RandNonZero0Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (arguments0Value_ == 0L) {
                            return RandZero1Node_.create(this.root, arguments0Value);
                        }
                        if (arguments0Value_ != 0L) {
                            return RandNonZero1Node_.create(this.root, arguments0Value);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments0Value_, arguments0ImplicitType);
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.PublicSendNode.class)
    public static final class PublicSendNodeFactory
    extends NodeFactoryBase<KernelNodes.PublicSendNode> {
        private static PublicSendNodeFactory publicSendNodeFactoryInstance;

        private PublicSendNodeFactory() {
            super(KernelNodes.PublicSendNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.PublicSendNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicSendNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.PublicSendNode> getInstance() {
            if (publicSendNodeFactoryInstance == null) {
                publicSendNodeFactoryInstance = new PublicSendNodeFactory();
            }
            return publicSendNodeFactoryInstance;
        }

        public static KernelNodes.PublicSendNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PublicSendNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.PublicSendNode.class)
        public static final class PublicSendNodeGen
        extends KernelNodes.PublicSendNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @Node.Child
            private RubyNode arguments3_;
            @Node.Child
            private BaseNode_ specialization_;

            private PublicSendNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="send(VirtualFrame, Object, Object, Object[], DynamicObject)", value=KernelNodes.PublicSendNode.class)
            private static final class Send1Node_
            extends BaseNode_ {
                Send1Node_(PublicSendNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments2Value instanceof Object[] && arguments3Value instanceof DynamicObject) {
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        DynamicObject arguments3Value_ = (DynamicObject)arguments3Value;
                        return this.root.send(frameValue, arguments0Value, arguments1Value, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(PublicSendNodeGen root) {
                    return new Send1Node_(root);
                }
            }

            @GeneratedBy(methodName="send(VirtualFrame, Object, Object, Object[], NotProvided)", value=KernelNodes.PublicSendNode.class)
            private static final class Send0Node_
            extends BaseNode_ {
                Send0Node_(PublicSendNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments2Value instanceof Object[] && arguments3Value instanceof NotProvided) {
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        NotProvided arguments3Value_ = (NotProvided)arguments3Value;
                        return this.root.send(frameValue, arguments0Value, arguments1Value, arguments2Value_, arguments3Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(PublicSendNodeGen root) {
                    return new Send0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.PublicSendNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PublicSendNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(PublicSendNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.PublicSendNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PublicSendNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                static BaseNode_ create(PublicSendNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.PublicSendNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PublicSendNodeGen root;

                BaseNode_(PublicSendNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (PublicSendNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_, this.root.arguments3_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    Object arguments3Value_ = this.root.arguments3_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                    if (arguments2Value instanceof Object[]) {
                        if (arguments3Value instanceof NotProvided) {
                            return Send0Node_.create(this.root);
                        }
                        if (arguments3Value instanceof DynamicObject) {
                            return Send1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.PublicMethodsNode.class)
    public static final class PublicMethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.PublicMethodsNode> {
        private static PublicMethodsNodeFactory publicMethodsNodeFactoryInstance;

        private PublicMethodsNodeFactory() {
            super(KernelNodes.PublicMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.PublicMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return PublicMethodsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.PublicMethodsNode> getInstance() {
            if (publicMethodsNodeFactoryInstance == null) {
                publicMethodsNodeFactoryInstance = new PublicMethodsNodeFactory();
            }
            return publicMethodsNodeFactoryInstance;
        }

        public static KernelNodes.PublicMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
            return new PublicMethodsNodeGen(context, sourceSection, object, includeAncestors);
        }

        @GeneratedBy(value=KernelNodes.PublicMethodsNode.class)
        public static final class PublicMethodsNodeGen
        extends KernelNodes.PublicMethodsNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode includeAncestors_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PublicMethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
                super(context, sourceSection);
                this.object_ = object;
                this.includeAncestors_ = this.coerceToBoolean(includeAncestors);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDynamicObject(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                boolean includeAncestorsValue_;
                Object objectValue_ = this.object_.execute(frameValue);
                try {
                    includeAncestorsValue_ = this.includeAncestors_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(objectValue_, ex.getResult());
                }
                return this.publicMethods(objectValue_, includeAncestorsValue_);
            }

            private UnsupportedSpecializationException unsupported(Object objectValue, Object includeAncestorsValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.object_, this.includeAncestors_}, objectValue, includeAncestorsValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ProtectedMethodsNode.class)
    public static final class ProtectedMethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.ProtectedMethodsNode> {
        private static ProtectedMethodsNodeFactory protectedMethodsNodeFactoryInstance;

        private ProtectedMethodsNodeFactory() {
            super(KernelNodes.ProtectedMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.ProtectedMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ProtectedMethodsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ProtectedMethodsNode> getInstance() {
            if (protectedMethodsNodeFactoryInstance == null) {
                protectedMethodsNodeFactoryInstance = new ProtectedMethodsNodeFactory();
            }
            return protectedMethodsNodeFactoryInstance;
        }

        public static KernelNodes.ProtectedMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
            return new ProtectedMethodsNodeGen(context, sourceSection, object, includeAncestors);
        }

        @GeneratedBy(value=KernelNodes.ProtectedMethodsNode.class)
        public static final class ProtectedMethodsNodeGen
        extends KernelNodes.ProtectedMethodsNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode includeAncestors_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ProtectedMethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
                super(context, sourceSection);
                this.object_ = object;
                this.includeAncestors_ = this.coerceToBoolean(includeAncestors);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDynamicObject(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                boolean includeAncestorsValue_;
                Object objectValue_ = this.object_.execute(frameValue);
                try {
                    includeAncestorsValue_ = this.includeAncestors_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(objectValue_, ex.getResult());
                }
                return this.protectedMethods(objectValue_, includeAncestorsValue_);
            }

            private UnsupportedSpecializationException unsupported(Object objectValue, Object includeAncestorsValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.object_, this.includeAncestors_}, objectValue, includeAncestorsValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ProcNode.class)
    public static final class ProcNodeFactory
    extends NodeFactoryBase<KernelNodes.ProcNode> {
        private static ProcNodeFactory procNodeFactoryInstance;

        private ProcNodeFactory() {
            super(KernelNodes.ProcNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.ProcNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ProcNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ProcNode> getInstance() {
            if (procNodeFactoryInstance == null) {
                procNodeFactoryInstance = new ProcNodeFactory();
            }
            return procNodeFactoryInstance;
        }

        public static KernelNodes.ProcNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ProcNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.ProcNode.class)
        public static final class ProcNodeGen
        extends KernelNodes.ProcNode {
            @Node.Child
            private RubyNode arguments0_;

            private ProcNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.proc(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.PrivateMethodsNode.class)
    public static final class PrivateMethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.PrivateMethodsNode> {
        private static PrivateMethodsNodeFactory privateMethodsNodeFactoryInstance;

        private PrivateMethodsNodeFactory() {
            super(KernelNodes.PrivateMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.PrivateMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return PrivateMethodsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.PrivateMethodsNode> getInstance() {
            if (privateMethodsNodeFactoryInstance == null) {
                privateMethodsNodeFactoryInstance = new PrivateMethodsNodeFactory();
            }
            return privateMethodsNodeFactoryInstance;
        }

        public static KernelNodes.PrivateMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
            return new PrivateMethodsNodeGen(context, sourceSection, object, includeAncestors);
        }

        @GeneratedBy(value=KernelNodes.PrivateMethodsNode.class)
        public static final class PrivateMethodsNodeGen
        extends KernelNodes.PrivateMethodsNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode includeAncestors_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PrivateMethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode includeAncestors) {
                super(context, sourceSection);
                this.object_ = object;
                this.includeAncestors_ = this.coerceToBoolean(includeAncestors);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeDynamicObject(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeDynamicObject(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                boolean includeAncestorsValue_;
                Object objectValue_ = this.object_.execute(frameValue);
                try {
                    includeAncestorsValue_ = this.includeAncestors_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(objectValue_, ex.getResult());
                }
                return this.privateMethods(objectValue_, includeAncestorsValue_);
            }

            private UnsupportedSpecializationException unsupported(Object objectValue, Object includeAncestorsValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.object_, this.includeAncestors_}, objectValue, includeAncestorsValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.NilNode.class)
    public static final class NilNodeFactory
    extends NodeFactoryBase<KernelNodes.NilNode> {
        private static NilNodeFactory nilNodeFactoryInstance;

        private NilNodeFactory() {
            super(KernelNodes.NilNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.NilNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NilNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.NilNode> getInstance() {
            if (nilNodeFactoryInstance == null) {
                nilNodeFactoryInstance = new NilNodeFactory();
            }
            return nilNodeFactoryInstance;
        }

        public static KernelNodes.NilNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new NilNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.NilNode.class)
        public static final class NilNodeGen
        extends KernelNodes.NilNode {
            private NilNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.isNil();
            }
        }
    }

    @GeneratedBy(value=KernelNodes.MethodsNode.class)
    public static final class MethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.MethodsNode> {
        private static MethodsNodeFactory methodsNodeFactoryInstance;

        private MethodsNodeFactory() {
            super(KernelNodes.MethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.MethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return MethodsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.MethodsNode> getInstance() {
            if (methodsNodeFactoryInstance == null) {
                methodsNodeFactoryInstance = new MethodsNodeFactory();
            }
            return methodsNodeFactoryInstance;
        }

        public static KernelNodes.MethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode regular) {
            return new MethodsNodeGen(context, sourceSection, object, regular);
        }

        @GeneratedBy(value=KernelNodes.MethodsNode.class)
        public static final class MethodsNodeGen
        extends KernelNodes.MethodsNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode regular_;
            @CompilerDirectives.CompilationFinal
            private Class<?> regularType_;
            @Node.Child
            private BaseNode_ specialization_;

            private MethodsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode regular) {
                super(context, sourceSection);
                this.object_ = object;
                this.regular_ = this.coerceToBoolean(regular);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="methodsSingleton(VirtualFrame, Object, boolean, SingletonMethodsNode)", value=KernelNodes.MethodsNode.class)
            private static final class MethodsSingletonNode_
            extends BaseNode_ {
                @Node.Child
                private KernelNodes.SingletonMethodsNode singletonMethodsNode;

                MethodsSingletonNode_(MethodsNodeGen root, KernelNodes.SingletonMethodsNode singletonMethodsNode) {
                    super(root, 2);
                    this.singletonMethodsNode = singletonMethodsNode;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    boolean regularValue_;
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    try {
                        regularValue_ = this.root.regular_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, objectValue_, ex.getResult());
                    }
                    if (!regularValue_) {
                        return this.root.methodsSingleton(frameValue, objectValue_, regularValue_, this.singletonMethodsNode);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, objectValue_, regularValue_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object objectValue, Object regularValue) {
                    boolean regularValue_;
                    if (regularValue instanceof Boolean && !(regularValue_ = ((Boolean)regularValue).booleanValue())) {
                        return this.root.methodsSingleton(frameValue, objectValue, regularValue_, this.singletonMethodsNode);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, objectValue, regularValue);
                }

                static BaseNode_ create(MethodsNodeGen root, KernelNodes.SingletonMethodsNode singletonMethodsNode) {
                    return new MethodsSingletonNode_(root, singletonMethodsNode);
                }
            }

            @GeneratedBy(methodName="methodsRegular(Object, boolean, MetaClassNode)", value=KernelNodes.MethodsNode.class)
            private static final class MethodsRegularNode_
            extends BaseNode_ {
                @Node.Child
                private MetaClassNode metaClassNode;

                MethodsRegularNode_(MethodsNodeGen root, MetaClassNode metaClassNode) {
                    super(root, 1);
                    this.metaClassNode = metaClassNode;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    boolean regularValue_;
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    try {
                        regularValue_ = this.root.regular_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, objectValue_, ex.getResult());
                    }
                    if (regularValue_) {
                        return this.root.methodsRegular(objectValue_, regularValue_, this.metaClassNode);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, objectValue_, regularValue_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object objectValue, Object regularValue) {
                    boolean regularValue_;
                    if (regularValue instanceof Boolean && (regularValue_ = ((Boolean)regularValue).booleanValue())) {
                        return this.root.methodsRegular(objectValue, regularValue_, this.metaClassNode);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, objectValue, regularValue);
                }

                static BaseNode_ create(MethodsNodeGen root, MetaClassNode metaClassNode) {
                    return new MethodsRegularNode_(root, metaClassNode);
                }
            }

            @GeneratedBy(value=KernelNodes.MethodsNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(MethodsNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue, Object regularValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, objectValue, regularValue));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object objectValue, Object regularValue) {
                    return this.getNext().executeDynamicObject_(frameValue, objectValue, regularValue);
                }

                static BaseNode_ create(MethodsNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.MethodsNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(MethodsNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object objectValue, Object regularValue) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, objectValue, regularValue);
                }

                static BaseNode_ create(MethodsNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.MethodsNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected MethodsNodeGen root;

                BaseNode_(MethodsNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (MethodsNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.object_, this.root.regular_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object objectValue, Object regularValue) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, objectValue, regularValue);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    Object regularValue_ = this.executeRegular_(frameValue);
                    return this.executeDynamicObject_(frameValue, objectValue_, regularValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object objectValue, Object regularValue) {
                    if (regularValue instanceof Boolean) {
                        boolean regularValue_ = (Boolean)regularValue;
                        if (regularValue_) {
                            MetaClassNode metaClassNode1 = this.root.createMetaClassNode();
                            return MethodsRegularNode_.create(this.root, metaClassNode1);
                        }
                        KernelNodes.SingletonMethodsNode singletonMethodsNode2 = this.root.createSingletonMethodsNode();
                        return MethodsSingletonNode_.create(this.root, singletonMethodsNode2);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeRegular_(Frame frameValue) {
                    Object object;
                    Class regularType_ = this.root.regularType_;
                    if (regularType_ == Boolean.TYPE) {
                        return this.root.regular_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (regularType_ != null) return this.root.regular_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.regular_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.regularType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.regularType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.regularType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.MethodNode.class)
    public static final class MethodNodeFactory
    extends NodeFactoryBase<KernelNodes.MethodNode> {
        private static MethodNodeFactory methodNodeFactoryInstance;

        private MethodNodeFactory() {
            super(KernelNodes.MethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.MethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return MethodNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.MethodNode> getInstance() {
            if (methodNodeFactoryInstance == null) {
                methodNodeFactoryInstance = new MethodNodeFactory();
            }
            return methodNodeFactoryInstance;
        }

        public static KernelNodes.MethodNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name) {
            return new MethodNodeGen(context, sourceSection, object, name);
        }

        @GeneratedBy(value=KernelNodes.MethodNode.class)
        public static final class MethodNodeGen
        extends KernelNodes.MethodNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private MethodNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name) {
                super(context, sourceSection);
                this.object_ = object;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject nameValue_;
                Object objectValue_ = this.object_.execute(frameValue);
                try {
                    nameValue_ = this.name_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(objectValue_, ex.getResult());
                }
                return this.method(frameValue, objectValue_, nameValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object objectValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.object_, this.name_}, objectValue, nameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.MethodNameNode.class)
    public static final class MethodNameNodeFactory
    extends NodeFactoryBase<KernelNodes.MethodNameNode> {
        private static MethodNameNodeFactory methodNameNodeFactoryInstance;

        private MethodNameNodeFactory() {
            super(KernelNodes.MethodNameNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.MethodNameNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MethodNameNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.MethodNameNode> getInstance() {
            if (methodNameNodeFactoryInstance == null) {
                methodNameNodeFactoryInstance = new MethodNameNodeFactory();
            }
            return methodNameNodeFactoryInstance;
        }

        public static KernelNodes.MethodNameNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MethodNameNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.MethodNameNode.class)
        public static final class MethodNameNodeGen
        extends KernelNodes.MethodNameNode {
            private MethodNameNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.methodName();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.LocalVariablesNode.class)
    public static final class LocalVariablesNodeFactory
    extends NodeFactoryBase<KernelNodes.LocalVariablesNode> {
        private static LocalVariablesNodeFactory localVariablesNodeFactoryInstance;

        private LocalVariablesNodeFactory() {
            super(KernelNodes.LocalVariablesNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.LocalVariablesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LocalVariablesNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.LocalVariablesNode> getInstance() {
            if (localVariablesNodeFactoryInstance == null) {
                localVariablesNodeFactoryInstance = new LocalVariablesNodeFactory();
            }
            return localVariablesNodeFactoryInstance;
        }

        public static KernelNodes.LocalVariablesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LocalVariablesNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.LocalVariablesNode.class)
        public static final class LocalVariablesNodeGen
        extends KernelNodes.LocalVariablesNode {
            private LocalVariablesNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.localVariables();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.LambdaNode.class)
    public static final class LambdaNodeFactory
    extends NodeFactoryBase<KernelNodes.LambdaNode> {
        private static LambdaNodeFactory lambdaNodeFactoryInstance;

        private LambdaNodeFactory() {
            super(KernelNodes.LambdaNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.LambdaNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LambdaNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.LambdaNode> getInstance() {
            if (lambdaNodeFactoryInstance == null) {
                lambdaNodeFactoryInstance = new LambdaNodeFactory();
            }
            return lambdaNodeFactoryInstance;
        }

        public static KernelNodes.LambdaNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LambdaNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.LambdaNode.class)
        public static final class LambdaNodeGen
        extends KernelNodes.LambdaNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private LambdaNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="lambda(DynamicObject)", value=KernelNodes.LambdaNode.class)
            private static final class Lambda1Node_
            extends BaseNode_ {
                Lambda1Node_(LambdaNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        return this.root.lambda(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LambdaNodeGen root) {
                    return new Lambda1Node_(root);
                }
            }

            @GeneratedBy(methodName="lambda(NotProvided)", value=KernelNodes.LambdaNode.class)
            private static final class Lambda0Node_
            extends BaseNode_ {
                Lambda0Node_(LambdaNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        return this.root.lambda(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LambdaNodeGen root) {
                    return new Lambda0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.LambdaNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LambdaNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LambdaNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.LambdaNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LambdaNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(LambdaNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.LambdaNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LambdaNodeGen root;

                BaseNode_(LambdaNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (LambdaNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        return Lambda0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof DynamicObject) {
                        return Lambda1Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelIsANode.class)
    public static final class KernelIsANodeFactory
    extends NodeFactoryBase<KernelNodes.KernelIsANode> {
        private static KernelIsANodeFactory kernelIsANodeFactoryInstance;

        private KernelIsANodeFactory() {
            super(KernelNodes.KernelIsANode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.KernelIsANode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelIsANodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.KernelIsANode> getInstance() {
            if (kernelIsANodeFactoryInstance == null) {
                kernelIsANodeFactoryInstance = new KernelIsANodeFactory();
            }
            return kernelIsANodeFactoryInstance;
        }

        public static KernelNodes.KernelIsANode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new KernelIsANodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.KernelIsANode.class)
        public static final class KernelIsANodeGen
        extends KernelNodes.KernelIsANode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private KernelIsANodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="isATypeError(Object, Object)", value=KernelNodes.KernelIsANode.class)
            private static final class IsATypeErrorNode_
            extends BaseNode_ {
                IsATypeErrorNode_(KernelIsANodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    if (!RubyGuards.isRubyModule(arguments1Value_)) {
                        return this.root.isATypeError(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (!RubyGuards.isRubyModule(arguments1Value)) {
                        return this.root.isATypeError(arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(KernelIsANodeGen root) {
                    return new IsATypeErrorNode_(root);
                }
            }

            @GeneratedBy(methodName="isA(Object, DynamicObject)", value=KernelNodes.KernelIsANode.class)
            private static final class IsANode_
            extends BaseNode_ {
                IsANode_(KernelIsANodeGen root) {
                    super(root, 1);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.isA(arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        return this.root.isA(arguments0Value, arguments1Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(KernelIsANodeGen root) {
                    return new IsANode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.KernelIsANode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(KernelIsANodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(KernelIsANodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.KernelIsANode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(KernelIsANodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(KernelIsANodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.KernelIsANode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected KernelIsANodeGen root;

                BaseNode_(KernelIsANodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (KernelIsANodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof DynamicObject) {
                        return IsANode_.create(this.root);
                    }
                    if (!RubyGuards.isRubyModule(arguments1Value)) {
                        return IsATypeErrorNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceVariablesNode.class)
    public static final class InstanceVariablesNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceVariablesNode> {
        private static InstanceVariablesNodeFactory instanceVariablesNodeFactoryInstance;

        private InstanceVariablesNodeFactory() {
            super(KernelNodes.InstanceVariablesNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.InstanceVariablesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceVariablesNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InstanceVariablesNode> getInstance() {
            if (instanceVariablesNodeFactoryInstance == null) {
                instanceVariablesNodeFactoryInstance = new InstanceVariablesNodeFactory();
            }
            return instanceVariablesNodeFactoryInstance;
        }

        public static KernelNodes.InstanceVariablesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InstanceVariablesNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.InstanceVariablesNode.class)
        public static final class InstanceVariablesNodeGen
        extends KernelNodes.InstanceVariablesNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InstanceVariablesNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.instanceVariables(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RemoveInstanceVariableNode.class)
    public static final class RemoveInstanceVariableNodeFactory
    extends NodeFactoryBase<KernelNodes.RemoveInstanceVariableNode> {
        private static RemoveInstanceVariableNodeFactory removeInstanceVariableNodeFactoryInstance;

        private RemoveInstanceVariableNodeFactory() {
            super(KernelNodes.RemoveInstanceVariableNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.RemoveInstanceVariableNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return RemoveInstanceVariableNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.RemoveInstanceVariableNode> getInstance() {
            if (removeInstanceVariableNodeFactoryInstance == null) {
                removeInstanceVariableNodeFactoryInstance = new RemoveInstanceVariableNodeFactory();
            }
            return removeInstanceVariableNodeFactoryInstance;
        }

        public static KernelNodes.RemoveInstanceVariableNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name) {
            return new RemoveInstanceVariableNodeGen(context, sourceSection, object, name);
        }

        @GeneratedBy(value=KernelNodes.RemoveInstanceVariableNode.class)
        public static final class RemoveInstanceVariableNodeGen
        extends KernelNodes.RemoveInstanceVariableNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private RemoveInstanceVariableNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name) {
                super(context, sourceSection);
                this.object_ = object;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject objectValue_;
                try {
                    objectValue_ = this.object_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue);
                }
                try {
                    nameValue_ = RemoveInstanceVariableNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(objectValue_, ex.getResult());
                }
                return this.removeInstanceVariable(objectValue_, nameValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object objectValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.object_, this.name_}, objectValue, nameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
    public static final class InstanceVariableSetNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceVariableSetNode> {
        private static InstanceVariableSetNodeFactory instanceVariableSetNodeFactoryInstance;

        private InstanceVariableSetNodeFactory() {
            super(KernelNodes.InstanceVariableSetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.InstanceVariableSetNode createNode(Object ... arguments) {
            if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
                return InstanceVariableSetNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InstanceVariableSetNode> getInstance() {
            if (instanceVariableSetNodeFactoryInstance == null) {
                instanceVariableSetNodeFactoryInstance = new InstanceVariableSetNodeFactory();
            }
            return instanceVariableSetNodeFactoryInstance;
        }

        public static KernelNodes.InstanceVariableSetNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name, RubyNode value) {
            return new InstanceVariableSetNodeGen(context, sourceSection, object, name, value);
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class InstanceVariableSetNodeGen
        extends KernelNodes.InstanceVariableSetNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private RubyNode value_;
            @Node.Child
            private BaseNode_ specialization_;

            private InstanceVariableSetNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name, RubyNode value) {
                super(context, sourceSection);
                this.object_ = object;
                this.name_ = this.coerceToSymbolOrString(name);
                this.value_ = value;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="instanceVariableSetString(DynamicObject, DynamicObject, Object)", value=KernelNodes.InstanceVariableSetNode.class)
            private static final class InstanceVariableSetStringNode_
            extends BaseNode_ {
                InstanceVariableSetStringNode_(InstanceVariableSetNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object objectValue, Object nameValue, Object valueValue) {
                    if (objectValue instanceof DynamicObject && nameValue instanceof DynamicObject) {
                        DynamicObject objectValue_ = (DynamicObject)objectValue;
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        if (RubyGuards.isRubyString(nameValue_)) {
                            return this.root.instanceVariableSetString(objectValue_, nameValue_, valueValue);
                        }
                    }
                    return this.getNext().execute_(frameValue, objectValue, nameValue, valueValue);
                }

                static BaseNode_ create(InstanceVariableSetNodeGen root) {
                    return new InstanceVariableSetStringNode_(root);
                }
            }

            @GeneratedBy(methodName="instanceVariableSetSymbol(DynamicObject, DynamicObject, Object)", value=KernelNodes.InstanceVariableSetNode.class)
            private static final class InstanceVariableSetSymbolNode_
            extends BaseNode_ {
                InstanceVariableSetSymbolNode_(InstanceVariableSetNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object objectValue, Object nameValue, Object valueValue) {
                    if (objectValue instanceof DynamicObject && nameValue instanceof DynamicObject) {
                        DynamicObject objectValue_ = (DynamicObject)objectValue;
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        if (RubyGuards.isRubySymbol(nameValue_)) {
                            return this.root.instanceVariableSetSymbol(objectValue_, nameValue_, valueValue);
                        }
                    }
                    return this.getNext().execute_(frameValue, objectValue, nameValue, valueValue);
                }

                static BaseNode_ create(InstanceVariableSetNodeGen root) {
                    return new InstanceVariableSetSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="instanceVariableSetSymbolCached(DynamicObject, DynamicObject, Object, DynamicObject, WriteHeadObjectFieldNode)", value=KernelNodes.InstanceVariableSetNode.class)
            private static final class InstanceVariableSetSymbolCachedNode_
            extends BaseNode_ {
                private final DynamicObject cachedName;
                @Node.Child
                private WriteHeadObjectFieldNode writeHeadObjectFieldNode;

                InstanceVariableSetSymbolCachedNode_(InstanceVariableSetNodeGen root, DynamicObject cachedName, WriteHeadObjectFieldNode writeHeadObjectFieldNode) {
                    super(root, 1);
                    this.cachedName = cachedName;
                    this.writeHeadObjectFieldNode = writeHeadObjectFieldNode;
                }

                @Override
                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object objectValue, Object nameValue, Object valueValue) {
                    DynamicObject nameValue_;
                    return objectValue instanceof DynamicObject && nameValue instanceof DynamicObject && RubyGuards.isRubySymbol(nameValue_ = (DynamicObject)nameValue) && nameValue_ == this.cachedName;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object objectValue, Object nameValue, Object valueValue) {
                    if (objectValue instanceof DynamicObject && nameValue instanceof DynamicObject) {
                        DynamicObject objectValue_ = (DynamicObject)objectValue;
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        if (RubyGuards.isRubySymbol(nameValue_) && nameValue_ == this.cachedName) {
                            return this.root.instanceVariableSetSymbolCached(objectValue_, nameValue_, valueValue, this.cachedName, this.writeHeadObjectFieldNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, objectValue, nameValue, valueValue);
                }

                static BaseNode_ create(InstanceVariableSetNodeGen root, DynamicObject cachedName, WriteHeadObjectFieldNode writeHeadObjectFieldNode) {
                    return new InstanceVariableSetSymbolCachedNode_(root, cachedName, writeHeadObjectFieldNode);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InstanceVariableSetNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue, Object nameValue, Object valueValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, objectValue, nameValue, valueValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object objectValue, Object nameValue, Object valueValue) {
                    return this.getNext().execute_(frameValue, objectValue, nameValue, valueValue);
                }

                static BaseNode_ create(InstanceVariableSetNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InstanceVariableSetNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object objectValue, Object nameValue, Object valueValue) {
                    return this.uninitialized((Frame)frameValue, objectValue, nameValue, valueValue);
                }

                static BaseNode_ create(InstanceVariableSetNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InstanceVariableSetNodeGen root;

                BaseNode_(InstanceVariableSetNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (InstanceVariableSetNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.object_, this.root.name_, this.root.value_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object objectValue, Object nameValue, Object valueValue) {
                    return this.execute_((VirtualFrame)frameValue, objectValue, nameValue, valueValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    Object nameValue_ = this.root.name_.execute(frameValue);
                    Object valueValue_ = this.root.value_.execute(frameValue);
                    return this.execute_(frameValue, objectValue_, nameValue_, valueValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object objectValue, Object nameValue, Object valueValue) {
                    if (objectValue instanceof DynamicObject && nameValue instanceof DynamicObject) {
                        WriteHeadObjectFieldNode writeHeadObjectFieldNode1;
                        BaseNode_ s;
                        DynamicObject nameValue_;
                        DynamicObject cachedName1 = nameValue_ = (DynamicObject)nameValue;
                        if (RubyGuards.isRubySymbol(nameValue_) && nameValue_ == cachedName1 && this.countSame(s = InstanceVariableSetSymbolCachedNode_.create(this.root, cachedName1, writeHeadObjectFieldNode1 = this.root.createWriteFieldNode(this.root.checkName(this.root.symbolToString(cachedName1))))) < KernelNodes.InstanceVariableSetNode.LIMIT) {
                            return s;
                        }
                        if (RubyGuards.isRubySymbol(nameValue_)) {
                            return InstanceVariableSetSymbolNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(nameValue_)) {
                            return InstanceVariableSetStringNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
    public static final class InstanceVariableGetNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceVariableGetNode> {
        private static InstanceVariableGetNodeFactory instanceVariableGetNodeFactoryInstance;

        private InstanceVariableGetNodeFactory() {
            super(KernelNodes.InstanceVariableGetNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.InstanceVariableGetNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return InstanceVariableGetNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InstanceVariableGetNode> getInstance() {
            if (instanceVariableGetNodeFactoryInstance == null) {
                instanceVariableGetNodeFactoryInstance = new InstanceVariableGetNodeFactory();
            }
            return instanceVariableGetNodeFactoryInstance;
        }

        public static KernelNodes.InstanceVariableGetNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name) {
            return new InstanceVariableGetNodeGen(context, sourceSection, object, name);
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class InstanceVariableGetNodeGen
        extends KernelNodes.InstanceVariableGetNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode name_;
            @Node.Child
            private BaseNode_ specialization_;

            private InstanceVariableGetNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name) {
                super(context, sourceSection);
                this.object_ = object;
                this.name_ = this.coerceToSymbolOrString(name);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="instanceVariableGetString(DynamicObject, DynamicObject)", value=KernelNodes.InstanceVariableGetNode.class)
            private static final class InstanceVariableGetStringNode_
            extends BaseNode_ {
                InstanceVariableGetStringNode_(InstanceVariableGetNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object objectValue, Object nameValue) {
                    if (objectValue instanceof DynamicObject && nameValue instanceof DynamicObject) {
                        DynamicObject objectValue_ = (DynamicObject)objectValue;
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        if (RubyGuards.isRubyString(nameValue_)) {
                            return this.root.instanceVariableGetString(objectValue_, nameValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, objectValue, nameValue);
                }

                static BaseNode_ create(InstanceVariableGetNodeGen root) {
                    return new InstanceVariableGetStringNode_(root);
                }
            }

            @GeneratedBy(methodName="instanceVariableGetSymbol(DynamicObject, DynamicObject)", value=KernelNodes.InstanceVariableGetNode.class)
            private static final class InstanceVariableGetSymbolNode_
            extends BaseNode_ {
                InstanceVariableGetSymbolNode_(InstanceVariableGetNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object objectValue, Object nameValue) {
                    if (objectValue instanceof DynamicObject && nameValue instanceof DynamicObject) {
                        DynamicObject objectValue_ = (DynamicObject)objectValue;
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        if (RubyGuards.isRubySymbol(nameValue_)) {
                            return this.root.instanceVariableGetSymbol(objectValue_, nameValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, objectValue, nameValue);
                }

                static BaseNode_ create(InstanceVariableGetNodeGen root) {
                    return new InstanceVariableGetSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="instanceVariableGetSymbolCached(DynamicObject, DynamicObject, DynamicObject, ReadHeadObjectFieldNode)", value=KernelNodes.InstanceVariableGetNode.class)
            private static final class InstanceVariableGetSymbolCachedNode_
            extends BaseNode_ {
                private final DynamicObject cachedName;
                @Node.Child
                private ReadHeadObjectFieldNode readHeadObjectFieldNode;

                InstanceVariableGetSymbolCachedNode_(InstanceVariableGetNodeGen root, DynamicObject cachedName, ReadHeadObjectFieldNode readHeadObjectFieldNode) {
                    super(root, 1);
                    this.cachedName = cachedName;
                    this.readHeadObjectFieldNode = readHeadObjectFieldNode;
                }

                @Override
                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object objectValue, Object nameValue) {
                    DynamicObject nameValue_;
                    return objectValue instanceof DynamicObject && nameValue instanceof DynamicObject && RubyGuards.isRubySymbol(nameValue_ = (DynamicObject)nameValue) && nameValue_ == this.cachedName;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object objectValue, Object nameValue) {
                    if (objectValue instanceof DynamicObject && nameValue instanceof DynamicObject) {
                        DynamicObject objectValue_ = (DynamicObject)objectValue;
                        DynamicObject nameValue_ = (DynamicObject)nameValue;
                        if (RubyGuards.isRubySymbol(nameValue_) && nameValue_ == this.cachedName) {
                            return this.root.instanceVariableGetSymbolCached(objectValue_, nameValue_, this.cachedName, this.readHeadObjectFieldNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, objectValue, nameValue);
                }

                static BaseNode_ create(InstanceVariableGetNodeGen root, DynamicObject cachedName, ReadHeadObjectFieldNode readHeadObjectFieldNode) {
                    return new InstanceVariableGetSymbolCachedNode_(root, cachedName, readHeadObjectFieldNode);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InstanceVariableGetNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue, Object nameValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, objectValue, nameValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object objectValue, Object nameValue) {
                    return this.getNext().execute_(frameValue, objectValue, nameValue);
                }

                static BaseNode_ create(InstanceVariableGetNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InstanceVariableGetNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object objectValue, Object nameValue) {
                    return this.uninitialized((Frame)frameValue, objectValue, nameValue);
                }

                static BaseNode_ create(InstanceVariableGetNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InstanceVariableGetNodeGen root;

                BaseNode_(InstanceVariableGetNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (InstanceVariableGetNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.object_, this.root.name_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object objectValue, Object nameValue) {
                    return this.execute_((VirtualFrame)frameValue, objectValue, nameValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object objectValue_ = this.root.object_.execute(frameValue);
                    Object nameValue_ = this.root.name_.execute(frameValue);
                    return this.execute_(frameValue, objectValue_, nameValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object objectValue, Object nameValue) {
                    if (objectValue instanceof DynamicObject && nameValue instanceof DynamicObject) {
                        ReadHeadObjectFieldNode readHeadObjectFieldNode1;
                        BaseNode_ s;
                        DynamicObject nameValue_;
                        DynamicObject cachedName1 = nameValue_ = (DynamicObject)nameValue;
                        if (RubyGuards.isRubySymbol(nameValue_) && nameValue_ == cachedName1 && this.countSame(s = InstanceVariableGetSymbolCachedNode_.create(this.root, cachedName1, readHeadObjectFieldNode1 = this.root.createReadFieldNode(this.root.checkName(this.root.symbolToString(cachedName1))))) < KernelNodes.InstanceVariableGetNode.LIMIT) {
                            return s;
                        }
                        if (RubyGuards.isRubySymbol(nameValue_)) {
                            return InstanceVariableGetSymbolNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(nameValue_)) {
                            return InstanceVariableGetStringNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceVariableDefinedNode.class)
    public static final class InstanceVariableDefinedNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceVariableDefinedNode> {
        private static InstanceVariableDefinedNodeFactory instanceVariableDefinedNodeFactoryInstance;

        private InstanceVariableDefinedNodeFactory() {
            super(KernelNodes.InstanceVariableDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.InstanceVariableDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return InstanceVariableDefinedNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InstanceVariableDefinedNode> getInstance() {
            if (instanceVariableDefinedNodeFactoryInstance == null) {
                instanceVariableDefinedNodeFactoryInstance = new InstanceVariableDefinedNodeFactory();
            }
            return instanceVariableDefinedNodeFactoryInstance;
        }

        public static KernelNodes.InstanceVariableDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name) {
            return new InstanceVariableDefinedNodeGen(context, sourceSection, object, name);
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableDefinedNode.class)
        public static final class InstanceVariableDefinedNodeGen
        extends KernelNodes.InstanceVariableDefinedNode {
            @Node.Child
            private RubyNode object_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InstanceVariableDefinedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object, RubyNode name) {
                super(context, sourceSection);
                this.object_ = object;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject objectValue_;
                try {
                    objectValue_ = this.object_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue);
                }
                try {
                    nameValue_ = InstanceVariableDefinedNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(objectValue_, ex.getResult());
                }
                return this.isInstanceVariableDefined(objectValue_, nameValue_);
            }

            private UnsupportedSpecializationException unsupported(Object objectValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.object_, this.name_}, objectValue, nameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceOfNode.class)
    public static final class InstanceOfNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceOfNode> {
        private static InstanceOfNodeFactory instanceOfNodeFactoryInstance;

        private InstanceOfNodeFactory() {
            super(KernelNodes.InstanceOfNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.InstanceOfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceOfNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InstanceOfNode> getInstance() {
            if (instanceOfNodeFactoryInstance == null) {
                instanceOfNodeFactoryInstance = new InstanceOfNodeFactory();
            }
            return instanceOfNodeFactoryInstance;
        }

        public static KernelNodes.InstanceOfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InstanceOfNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.InstanceOfNode.class)
        public static final class InstanceOfNodeGen
        extends KernelNodes.InstanceOfNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InstanceOfNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isRubyClass(arguments1Value_)) {
                    return this.instanceOf(frameValue, arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InitializeDupCloneNode.class)
    public static final class InitializeDupCloneNodeFactory
    extends NodeFactoryBase<KernelNodes.InitializeDupCloneNode> {
        private static InitializeDupCloneNodeFactory initializeDupCloneNodeFactoryInstance;

        private InitializeDupCloneNodeFactory() {
            super(KernelNodes.InitializeDupCloneNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.InitializeDupCloneNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeDupCloneNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InitializeDupCloneNode> getInstance() {
            if (initializeDupCloneNodeFactoryInstance == null) {
                initializeDupCloneNodeFactoryInstance = new InitializeDupCloneNodeFactory();
            }
            return initializeDupCloneNodeFactoryInstance;
        }

        public static KernelNodes.InitializeDupCloneNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeDupCloneNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.InitializeDupCloneNode.class)
        public static final class InitializeDupCloneNodeGen
        extends KernelNodes.InitializeDupCloneNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InitializeDupCloneNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.initializeDup(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<KernelNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(KernelNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        public static KernelNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new InitializeCopyNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.InitializeCopyNode.class)
        public static final class InitializeCopyNodeGen
        extends KernelNodes.InitializeCopyNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InitializeCopyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.initializeCopy(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.HashNode.class)
    public static final class HashNodeFactory
    extends NodeFactoryBase<KernelNodes.HashNode> {
        private static HashNodeFactory hashNodeFactoryInstance;

        private HashNodeFactory() {
            super(KernelNodes.HashNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.HashNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HashNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.HashNode> getInstance() {
            if (hashNodeFactoryInstance == null) {
                hashNodeFactoryInstance = new HashNodeFactory();
            }
            return hashNodeFactoryInstance;
        }

        public static KernelNodes.HashNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new HashNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.HashNode.class)
        public static final class HashNodeGen
        extends KernelNodes.HashNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private HashNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="hash(DynamicObject)", value=KernelNodes.HashNode.class)
            private static final class Hash4Node_
            extends BaseNode_ {
                Hash4Node_(HashNodeGen root) {
                    super(root, 5);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.hash(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        return this.root.hash(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root) {
                    return new Hash4Node_(root);
                }
            }

            @GeneratedBy(methodName="hash(boolean)", value=KernelNodes.HashNode.class)
            private static final class Hash3Node_
            extends BaseNode_ {
                Hash3Node_(HashNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    boolean arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.hash(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Boolean) {
                        boolean arguments0Value_ = (Boolean)arguments0Value;
                        return this.root.hash(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root) {
                    return new Hash3Node_(root);
                }
            }

            @GeneratedBy(methodName="hash(double)", value=KernelNodes.HashNode.class)
            private static final class Hash2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Hash2Node_(HashNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Hash2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.hash(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.hash(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root, Object arguments0Value) {
                    return new Hash2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="hash(long)", value=KernelNodes.HashNode.class)
            private static final class Hash1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Hash1Node_(HashNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Hash1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.hash(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.hash(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root, Object arguments0Value) {
                    return new Hash1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="hash(int)", value=KernelNodes.HashNode.class)
            private static final class Hash0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Hash0Node_(HashNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Hash0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.hash(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.hash(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root, Object arguments0Value) {
                    return new Hash0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=KernelNodes.HashNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(HashNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.HashNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(HashNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(HashNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.HashNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected HashNodeGen root;

                BaseNode_(HashNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (HashNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Hash0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Hash1Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Hash2Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof Boolean) {
                        return Hash3Node_.create(this.root);
                    }
                    if (arguments0Value instanceof DynamicObject) {
                        return Hash4Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Boolean.TYPE) {
                        return this.root.arguments0_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.GetsNode.class)
    public static final class GetsNodeFactory
    extends NodeFactoryBase<KernelNodes.GetsNode> {
        private static GetsNodeFactory getsNodeFactoryInstance;

        private GetsNodeFactory() {
            super(KernelNodes.GetsNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.GetsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.GetsNode> getInstance() {
            if (getsNodeFactoryInstance == null) {
                getsNodeFactoryInstance = new GetsNodeFactory();
            }
            return getsNodeFactoryInstance;
        }

        public static KernelNodes.GetsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new GetsNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.GetsNode.class)
        public static final class GetsNodeGen
        extends KernelNodes.GetsNode {
            private GetsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.gets(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelFrozenNode.class)
    public static final class KernelFrozenNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelFrozenNode> {
        private static KernelFrozenNodeFactory kernelFrozenNodeFactoryInstance;

        private KernelFrozenNodeFactory() {
            super(KernelNodes.KernelFrozenNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.KernelFrozenNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelFrozenNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.KernelFrozenNode> getInstance() {
            if (kernelFrozenNodeFactoryInstance == null) {
                kernelFrozenNodeFactoryInstance = new KernelFrozenNodeFactory();
            }
            return kernelFrozenNodeFactoryInstance;
        }

        public static KernelNodes.KernelFrozenNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new KernelFrozenNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.KernelFrozenNode.class)
        public static final class KernelFrozenNodeGen
        extends KernelNodes.KernelFrozenNode {
            @Node.Child
            private RubyNode arguments0_;

            private KernelFrozenNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.isFrozen(arguments0Value_);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelFreezeNode.class)
    public static final class KernelFreezeNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelFreezeNode> {
        private static KernelFreezeNodeFactory kernelFreezeNodeFactoryInstance;

        private KernelFreezeNodeFactory() {
            super(KernelNodes.KernelFreezeNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.KernelFreezeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelFreezeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.KernelFreezeNode> getInstance() {
            if (kernelFreezeNodeFactoryInstance == null) {
                kernelFreezeNodeFactoryInstance = new KernelFreezeNodeFactory();
            }
            return kernelFreezeNodeFactoryInstance;
        }

        public static KernelNodes.KernelFreezeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new KernelFreezeNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.KernelFreezeNode.class)
        public static final class KernelFreezeNodeGen
        extends KernelNodes.KernelFreezeNode {
            @Node.Child
            private RubyNode arguments0_;

            private KernelFreezeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.freeze(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ForkNode.class)
    public static final class ForkNodeFactory
    extends NodeFactoryBase<KernelNodes.ForkNode> {
        private static ForkNodeFactory forkNodeFactoryInstance;

        private ForkNodeFactory() {
            super(KernelNodes.ForkNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.ForkNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ForkNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ForkNode> getInstance() {
            if (forkNodeFactoryInstance == null) {
                forkNodeFactoryInstance = new ForkNodeFactory();
            }
            return forkNodeFactoryInstance;
        }

        public static KernelNodes.ForkNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ForkNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.ForkNode.class)
        public static final class ForkNodeGen
        extends KernelNodes.ForkNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ForkNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.fork(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ExecNode.class)
    public static final class ExecNodeFactory
    extends NodeFactoryBase<KernelNodes.ExecNode> {
        private static ExecNodeFactory execNodeFactoryInstance;

        private ExecNodeFactory() {
            super(KernelNodes.ExecNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.ExecNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExecNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.ExecNode> getInstance() {
            if (execNodeFactoryInstance == null) {
                execNodeFactoryInstance = new ExecNodeFactory();
            }
            return execNodeFactoryInstance;
        }

        public static KernelNodes.ExecNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new ExecNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.ExecNode.class)
        public static final class ExecNodeGen
        extends KernelNodes.ExecNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ExecNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.exec(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.EvalNode.class)
    public static final class EvalNodeFactory
    extends NodeFactoryBase<KernelNodes.EvalNode> {
        private static EvalNodeFactory evalNodeFactoryInstance;

        private EvalNodeFactory() {
            super(KernelNodes.EvalNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.EvalNode createNode(Object ... arguments) {
            if (!(arguments.length != 6 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode) || arguments[5] != null && !(arguments[5] instanceof RubyNode))) {
                return EvalNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3], (RubyNode)arguments[4], (RubyNode)arguments[5]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.EvalNode> getInstance() {
            if (evalNodeFactoryInstance == null) {
                evalNodeFactoryInstance = new EvalNodeFactory();
            }
            return evalNodeFactoryInstance;
        }

        public static KernelNodes.EvalNode create(RubyContext context, SourceSection sourceSection, RubyNode source, RubyNode binding, RubyNode filename, RubyNode lineNumber) {
            return new EvalNodeGen(context, sourceSection, source, binding, filename, lineNumber);
        }

        @GeneratedBy(value=KernelNodes.EvalNode.class)
        public static final class EvalNodeGen
        extends KernelNodes.EvalNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode source_;
            @Node.Child
            private RubyNode binding_;
            @Node.Child
            private RubyNode filename_;
            @Node.Child
            private RubyNode lineNumber_;
            @CompilerDirectives.CompilationFinal
            private Class<?> lineNumberType_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeEvalNoBindingCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private EvalNodeGen(RubyContext context, SourceSection sourceSection, RubyNode source, RubyNode binding, RubyNode filename, RubyNode lineNumber) {
                super(context, sourceSection);
                this.source_ = this.coerceSourceToString(source);
                this.binding_ = binding;
                this.filename_ = filename;
                this.lineNumber_ = lineNumber;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="evalBadBinding(DynamicObject, DynamicObject, NotProvided, NotProvided)", value=KernelNodes.EvalNode.class)
            private static final class EvalBadBindingNode_
            extends BaseNode_ {
                EvalBadBindingNode_(EvalNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof DynamicObject && bindingValue instanceof DynamicObject && filenameValue instanceof NotProvided && lineNumberValue instanceof NotProvided) {
                        DynamicObject sourceValue_ = (DynamicObject)sourceValue;
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        NotProvided filenameValue_ = (NotProvided)filenameValue;
                        NotProvided lineNumberValue_ = (NotProvided)lineNumberValue;
                        if (RubyGuards.isRubyString(sourceValue_) && !RubyGuards.isRubyBinding(bindingValue_)) {
                            return this.root.evalBadBinding(sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new EvalBadBindingNode_(root);
                }
            }

            @GeneratedBy(methodName="evalBindingFilenameLine(DynamicObject, DynamicObject, DynamicObject, int)", value=KernelNodes.EvalNode.class)
            private static final class EvalBindingFilenameLineNode_
            extends BaseNode_ {
                private final Class<?> lineNumberImplicitType;

                EvalBindingFilenameLineNode_(EvalNodeGen root, Object lineNumberValue) {
                    super(root, 8);
                    this.lineNumberImplicitType = RubyTypesGen.getImplicitIntegerClass(lineNumberValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.lineNumberImplicitType == ((EvalBindingFilenameLineNode_)other).lineNumberImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int lineNumberValue_;
                    DynamicObject filenameValue_;
                    DynamicObject bindingValue_;
                    DynamicObject sourceValue_;
                    try {
                        sourceValue_ = this.root.source_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bindingValue = this.root.binding_.execute(frameValue);
                        Object filenameValue = this.root.filename_.execute(frameValue);
                        Object lineNumberValue = this.executeLineNumber_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bindingValue, filenameValue, lineNumberValue);
                    }
                    try {
                        bindingValue_ = this.root.binding_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object filenameValue = this.root.filename_.execute(frameValue);
                        Object lineNumberValue = this.executeLineNumber_(frameValue);
                        return this.getNext().execute_(frameValue, sourceValue_, ex.getResult(), filenameValue, lineNumberValue);
                    }
                    try {
                        filenameValue_ = this.root.filename_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object lineNumberValue = this.executeLineNumber_(frameValue);
                        return this.getNext().execute_(frameValue, sourceValue_, bindingValue_, ex.getResult(), lineNumberValue);
                    }
                    try {
                        if (this.lineNumberImplicitType == Integer.TYPE) {
                            lineNumberValue_ = this.root.lineNumber_.executeInteger(frameValue);
                        } else {
                            Object lineNumberValue__ = this.executeLineNumber_(frameValue);
                            lineNumberValue_ = RubyTypesGen.expectImplicitInteger(lineNumberValue__, this.lineNumberImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, sourceValue_, bindingValue_, filenameValue_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(sourceValue_) && RubyGuards.isRubyBinding(bindingValue_) && RubyGuards.isRubyString(filenameValue_)) {
                        return this.root.evalBindingFilenameLine(sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                    }
                    return this.getNext().execute_(frameValue, sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof DynamicObject && bindingValue instanceof DynamicObject && filenameValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(lineNumberValue, this.lineNumberImplicitType)) {
                        DynamicObject sourceValue_ = (DynamicObject)sourceValue;
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        DynamicObject filenameValue_ = (DynamicObject)filenameValue;
                        int lineNumberValue_ = RubyTypesGen.asImplicitInteger(lineNumberValue, this.lineNumberImplicitType);
                        if (RubyGuards.isRubyString(sourceValue_) && RubyGuards.isRubyBinding(bindingValue_) && RubyGuards.isRubyString(filenameValue_)) {
                            return this.root.evalBindingFilenameLine(sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root, Object lineNumberValue) {
                    return new EvalBindingFilenameLineNode_(root, lineNumberValue);
                }
            }

            @GeneratedBy(methodName="evalBindingFilename(DynamicObject, DynamicObject, DynamicObject, DynamicObject)", value=KernelNodes.EvalNode.class)
            private static final class EvalBindingFilename1Node_
            extends BaseNode_ {
                EvalBindingFilename1Node_(EvalNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof DynamicObject && bindingValue instanceof DynamicObject && filenameValue instanceof DynamicObject && lineNumberValue instanceof DynamicObject) {
                        DynamicObject sourceValue_ = (DynamicObject)sourceValue;
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        DynamicObject filenameValue_ = (DynamicObject)filenameValue;
                        DynamicObject lineNumberValue_ = (DynamicObject)lineNumberValue;
                        if (RubyGuards.isRubyString(sourceValue_) && RubyGuards.isRubyBinding(bindingValue_) && RubyGuards.isRubyString(filenameValue_) && this.root.isNil(lineNumberValue_)) {
                            return this.root.evalBindingFilename(sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new EvalBindingFilename1Node_(root);
                }
            }

            @GeneratedBy(methodName="evalBindingFilename(DynamicObject, DynamicObject, DynamicObject, NotProvided)", value=KernelNodes.EvalNode.class)
            private static final class EvalBindingFilename0Node_
            extends BaseNode_ {
                EvalBindingFilename0Node_(EvalNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof DynamicObject && bindingValue instanceof DynamicObject && filenameValue instanceof DynamicObject && lineNumberValue instanceof NotProvided) {
                        DynamicObject sourceValue_ = (DynamicObject)sourceValue;
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        DynamicObject filenameValue_ = (DynamicObject)filenameValue;
                        NotProvided lineNumberValue_ = (NotProvided)lineNumberValue;
                        if (RubyGuards.isRubyString(sourceValue_) && RubyGuards.isRubyBinding(bindingValue_) && RubyGuards.isRubyString(filenameValue_)) {
                            return this.root.evalBindingFilename(sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new EvalBindingFilename0Node_(root);
                }
            }

            @GeneratedBy(methodName="evalBinding(DynamicObject, DynamicObject, DynamicObject, DynamicObject)", value=KernelNodes.EvalNode.class)
            private static final class EvalBinding1Node_
            extends BaseNode_ {
                EvalBinding1Node_(EvalNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof DynamicObject && bindingValue instanceof DynamicObject && filenameValue instanceof DynamicObject && lineNumberValue instanceof DynamicObject) {
                        DynamicObject sourceValue_ = (DynamicObject)sourceValue;
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        DynamicObject filenameValue_ = (DynamicObject)filenameValue;
                        DynamicObject lineNumberValue_ = (DynamicObject)lineNumberValue;
                        if (RubyGuards.isRubyString(sourceValue_) && RubyGuards.isRubyBinding(bindingValue_) && this.root.isNil(filenameValue_) && this.root.isNil(lineNumberValue_)) {
                            return this.root.evalBinding(sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new EvalBinding1Node_(root);
                }
            }

            @GeneratedBy(methodName="evalBinding(DynamicObject, DynamicObject, NotProvided, NotProvided)", value=KernelNodes.EvalNode.class)
            private static final class EvalBinding0Node_
            extends BaseNode_ {
                EvalBinding0Node_(EvalNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof DynamicObject && bindingValue instanceof DynamicObject && filenameValue instanceof NotProvided && lineNumberValue instanceof NotProvided) {
                        DynamicObject sourceValue_ = (DynamicObject)sourceValue;
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        NotProvided filenameValue_ = (NotProvided)filenameValue;
                        NotProvided lineNumberValue_ = (NotProvided)lineNumberValue;
                        if (RubyGuards.isRubyString(sourceValue_) && RubyGuards.isRubyBinding(bindingValue_)) {
                            return this.root.evalBinding(sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new EvalBinding0Node_(root);
                }
            }

            @GeneratedBy(methodName="evalNilBinding(VirtualFrame, DynamicObject, DynamicObject, DynamicObject, int)", value=KernelNodes.EvalNode.class)
            private static final class EvalNilBindingNode_
            extends BaseNode_ {
                private final Class<?> lineNumberImplicitType;

                EvalNilBindingNode_(EvalNodeGen root, Object lineNumberValue) {
                    super(root, 3);
                    this.lineNumberImplicitType = RubyTypesGen.getImplicitIntegerClass(lineNumberValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.lineNumberImplicitType == ((EvalNilBindingNode_)other).lineNumberImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int lineNumberValue_;
                    DynamicObject filenameValue_;
                    DynamicObject bindingValue_;
                    DynamicObject sourceValue_;
                    try {
                        sourceValue_ = this.root.source_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object bindingValue = this.root.binding_.execute(frameValue);
                        Object filenameValue = this.root.filename_.execute(frameValue);
                        Object lineNumberValue = this.executeLineNumber_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), bindingValue, filenameValue, lineNumberValue);
                    }
                    try {
                        bindingValue_ = this.root.binding_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object filenameValue = this.root.filename_.execute(frameValue);
                        Object lineNumberValue = this.executeLineNumber_(frameValue);
                        return this.getNext().execute_(frameValue, sourceValue_, ex.getResult(), filenameValue, lineNumberValue);
                    }
                    try {
                        filenameValue_ = this.root.filename_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object lineNumberValue = this.executeLineNumber_(frameValue);
                        return this.getNext().execute_(frameValue, sourceValue_, bindingValue_, ex.getResult(), lineNumberValue);
                    }
                    try {
                        if (this.lineNumberImplicitType == Integer.TYPE) {
                            lineNumberValue_ = this.root.lineNumber_.executeInteger(frameValue);
                        } else {
                            Object lineNumberValue__ = this.executeLineNumber_(frameValue);
                            lineNumberValue_ = RubyTypesGen.expectImplicitInteger(lineNumberValue__, this.lineNumberImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, sourceValue_, bindingValue_, filenameValue_, ex.getResult());
                    }
                    if (RubyGuards.isRubyString(sourceValue_) && this.root.isNil(bindingValue_) && RubyGuards.isRubyString(filenameValue_)) {
                        return this.root.evalNilBinding(frameValue, sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                    }
                    return this.getNext().execute_(frameValue, sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof DynamicObject && bindingValue instanceof DynamicObject && filenameValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(lineNumberValue, this.lineNumberImplicitType)) {
                        DynamicObject sourceValue_ = (DynamicObject)sourceValue;
                        DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                        DynamicObject filenameValue_ = (DynamicObject)filenameValue;
                        int lineNumberValue_ = RubyTypesGen.asImplicitInteger(lineNumberValue, this.lineNumberImplicitType);
                        if (RubyGuards.isRubyString(sourceValue_) && this.root.isNil(bindingValue_) && RubyGuards.isRubyString(filenameValue_)) {
                            return this.root.evalNilBinding(frameValue, sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root, Object lineNumberValue) {
                    return new EvalNilBindingNode_(root, lineNumberValue);
                }
            }

            @GeneratedBy(methodName="evalNoBindingUncached(VirtualFrame, DynamicObject, NotProvided, NotProvided, NotProvided)", value=KernelNodes.EvalNode.class)
            private static final class EvalNoBindingUncachedNode_
            extends BaseNode_ {
                EvalNoBindingUncachedNode_(EvalNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof DynamicObject && bindingValue instanceof NotProvided && filenameValue instanceof NotProvided && lineNumberValue instanceof NotProvided) {
                        DynamicObject sourceValue_ = (DynamicObject)sourceValue;
                        NotProvided bindingValue_ = (NotProvided)bindingValue;
                        NotProvided filenameValue_ = (NotProvided)filenameValue;
                        NotProvided lineNumberValue_ = (NotProvided)lineNumberValue;
                        if (RubyGuards.isRubyString(sourceValue_)) {
                            return this.root.evalNoBindingUncached(frameValue, sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new EvalNoBindingUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="evalNoBindingCached(VirtualFrame, DynamicObject, NotProvided, NotProvided, NotProvided, ByteList, RootNodeWrapper, CallTarget, DirectCallNode)", value=KernelNodes.EvalNode.class)
            private static final class EvalNoBindingCachedNode_
            extends BaseNode_ {
                private final ByteList cachedSource;
                private final KernelNodes.EvalNode.RootNodeWrapper cachedRootNode;
                private final CallTarget cachedCallTarget;
                @Node.Child
                private DirectCallNode callNode;

                EvalNoBindingCachedNode_(EvalNodeGen root, ByteList cachedSource, KernelNodes.EvalNode.RootNodeWrapper cachedRootNode, CallTarget cachedCallTarget, DirectCallNode callNode) {
                    super(root, 1);
                    this.cachedSource = cachedSource;
                    this.cachedRootNode = cachedRootNode;
                    this.cachedCallTarget = cachedCallTarget;
                    this.callNode = callNode;
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (newNode.getClass() == EvalNoBindingUncachedNode_.class) {
                        this.removeSame("Contained by evalNoBindingUncached(VirtualFrame, DynamicObject, NotProvided, NotProvided, NotProvided)");
                    }
                    return super.merge(newNode, frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                @Override
                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    DynamicObject sourceValue_;
                    if (sourceValue instanceof DynamicObject && bindingValue instanceof NotProvided && filenameValue instanceof NotProvided && lineNumberValue instanceof NotProvided && RubyGuards.isRubyString(sourceValue_ = (DynamicObject)sourceValue) && StringCachingGuards.byteListsEqual(sourceValue_, this.cachedSource)) {
                        assert (!this.root.parseDependsOnDeclarationFrame(this.cachedRootNode));
                        return true;
                    }
                    return false;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof DynamicObject && bindingValue instanceof NotProvided && filenameValue instanceof NotProvided && lineNumberValue instanceof NotProvided) {
                        DynamicObject sourceValue_ = (DynamicObject)sourceValue;
                        NotProvided bindingValue_ = (NotProvided)bindingValue;
                        NotProvided filenameValue_ = (NotProvided)filenameValue;
                        NotProvided lineNumberValue_ = (NotProvided)lineNumberValue;
                        if (RubyGuards.isRubyString(sourceValue_) && StringCachingGuards.byteListsEqual(sourceValue_, this.cachedSource)) {
                            assert (!this.root.parseDependsOnDeclarationFrame(this.cachedRootNode));
                            return this.root.evalNoBindingCached(frameValue, sourceValue_, bindingValue_, filenameValue_, lineNumberValue_, this.cachedSource, this.cachedRootNode, this.cachedCallTarget, this.callNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root, ByteList cachedSource, KernelNodes.EvalNode.RootNodeWrapper cachedRootNode, CallTarget cachedCallTarget, DirectCallNode callNode) {
                    return new EvalNoBindingCachedNode_(root, cachedSource, cachedRootNode, cachedCallTarget, callNode);
                }
            }

            @GeneratedBy(value=KernelNodes.EvalNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EvalNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    return this.getNext().execute_(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.EvalNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EvalNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    return this.uninitialized((Frame)frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.EvalNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EvalNodeGen root;

                BaseNode_(EvalNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (EvalNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.source_, this.root.binding_, this.root.filename_, this.root.lineNumber_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    return this.execute_((VirtualFrame)frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

                public Object execute(VirtualFrame frameValue) {
                    Object sourceValue_ = this.root.source_.execute(frameValue);
                    Object bindingValue_ = this.root.binding_.execute(frameValue);
                    Object filenameValue_ = this.root.filename_.execute(frameValue);
                    Object lineNumberValue_ = this.executeLineNumber_(frameValue);
                    return this.execute_(frameValue, sourceValue_, bindingValue_, filenameValue_, lineNumberValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                    if (sourceValue instanceof DynamicObject) {
                        DynamicObject sourceValue_ = (DynamicObject)sourceValue;
                        if (bindingValue instanceof NotProvided && filenameValue instanceof NotProvided && lineNumberValue instanceof NotProvided) {
                            ByteList cachedSource1 = StringCachingGuards.privatizeByteList(sourceValue_);
                            KernelNodes.EvalNode.RootNodeWrapper cachedRootNode1 = this.root.compileSource((VirtualFrame)frameValue, sourceValue_);
                            if (RubyGuards.isRubyString(sourceValue_) && StringCachingGuards.byteListsEqual(sourceValue_, cachedSource1) && !this.root.parseDependsOnDeclarationFrame(cachedRootNode1) && !this.root.excludeEvalNoBindingCached_) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                CallTarget cachedCallTarget1 = this.root.createCallTarget(cachedRootNode1);
                                DirectCallNode callNode1 = DirectCallNode.create(cachedCallTarget1);
                                BaseNode_ s = EvalNoBindingCachedNode_.create(this.root, cachedSource1, cachedRootNode1, cachedCallTarget1, callNode1);
                                if (this.countSame(s) < this.root.getCacheLimit()) {
                                    return s;
                                }
                            }
                            if (RubyGuards.isRubyString(sourceValue_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                this.root.excludeEvalNoBindingCached_ = true;
                                return EvalNoBindingUncachedNode_.create(this.root);
                            }
                        }
                        if (bindingValue instanceof DynamicObject) {
                            DynamicObject filenameValue_;
                            DynamicObject bindingValue_ = (DynamicObject)bindingValue;
                            if (filenameValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(lineNumberValue)) {
                                filenameValue_ = (DynamicObject)filenameValue;
                                if (RubyGuards.isRubyString(sourceValue_) && this.root.isNil(bindingValue_) && RubyGuards.isRubyString(filenameValue_)) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    return EvalNilBindingNode_.create(this.root, lineNumberValue);
                                }
                            }
                            if (filenameValue instanceof NotProvided && lineNumberValue instanceof NotProvided && RubyGuards.isRubyString(sourceValue_) && RubyGuards.isRubyBinding(bindingValue_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                return EvalBinding0Node_.create(this.root);
                            }
                            if (filenameValue instanceof DynamicObject) {
                                DynamicObject lineNumberValue_;
                                filenameValue_ = (DynamicObject)filenameValue;
                                if (lineNumberValue instanceof DynamicObject) {
                                    lineNumberValue_ = (DynamicObject)lineNumberValue;
                                    if (RubyGuards.isRubyString(sourceValue_) && RubyGuards.isRubyBinding(bindingValue_) && this.root.isNil(filenameValue_) && this.root.isNil(lineNumberValue_)) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        return EvalBinding1Node_.create(this.root);
                                    }
                                }
                                if (lineNumberValue instanceof NotProvided && RubyGuards.isRubyString(sourceValue_) && RubyGuards.isRubyBinding(bindingValue_) && RubyGuards.isRubyString(filenameValue_)) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    return EvalBindingFilename0Node_.create(this.root);
                                }
                                if (lineNumberValue instanceof DynamicObject) {
                                    lineNumberValue_ = (DynamicObject)lineNumberValue;
                                    if (RubyGuards.isRubyString(sourceValue_) && RubyGuards.isRubyBinding(bindingValue_) && RubyGuards.isRubyString(filenameValue_) && this.root.isNil(lineNumberValue_)) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        return EvalBindingFilename1Node_.create(this.root);
                                    }
                                }
                                if (RubyTypesGen.isImplicitInteger(lineNumberValue) && RubyGuards.isRubyString(sourceValue_) && RubyGuards.isRubyBinding(bindingValue_) && RubyGuards.isRubyString(filenameValue_)) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    return EvalBindingFilenameLineNode_.create(this.root, lineNumberValue);
                                }
                            }
                            if (filenameValue instanceof NotProvided && lineNumberValue instanceof NotProvided && RubyGuards.isRubyString(sourceValue_) && !RubyGuards.isRubyBinding(bindingValue_)) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                return EvalBadBindingNode_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeLineNumber_(Frame frameValue) {
                    Object object;
                    Class lineNumberType_ = this.root.lineNumberType_;
                    if (lineNumberType_ == Integer.TYPE) {
                        return this.root.lineNumber_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (lineNumberType_ != null) return this.root.lineNumber_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.lineNumber_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.lineNumberType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.lineNumberType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.lineNumberType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.DupNode.class)
    public static final class DupNodeFactory
    extends NodeFactoryBase<KernelNodes.DupNode> {
        private static DupNodeFactory dupNodeFactoryInstance;

        private DupNodeFactory() {
            super(KernelNodes.DupNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.DupNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DupNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.DupNode> getInstance() {
            if (dupNodeFactoryInstance == null) {
                dupNodeFactoryInstance = new DupNodeFactory();
            }
            return dupNodeFactoryInstance;
        }

        public static KernelNodes.DupNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new DupNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.DupNode.class)
        public static final class DupNodeGen
        extends KernelNodes.DupNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private DupNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.dup(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CloneNode.class)
    public static final class CloneNodeFactory
    extends NodeFactoryBase<KernelNodes.CloneNode> {
        private static CloneNodeFactory cloneNodeFactoryInstance;

        private CloneNodeFactory() {
            super(KernelNodes.CloneNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.CloneNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CloneNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.CloneNode> getInstance() {
            if (cloneNodeFactoryInstance == null) {
                cloneNodeFactoryInstance = new CloneNodeFactory();
            }
            return cloneNodeFactoryInstance;
        }

        public static KernelNodes.CloneNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CloneNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.CloneNode.class)
        public static final class CloneNodeGen
        extends KernelNodes.CloneNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private CloneNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.clone(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CopyNode.class)
    public static final class CopyNodeFactory
    extends NodeFactoryBase<KernelNodes.CopyNode> {
        private static CopyNodeFactory copyNodeFactoryInstance;

        private CopyNodeFactory() {
            super(KernelNodes.CopyNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        @Override
        public KernelNodes.CopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return CopyNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.CopyNode> getInstance() {
            if (copyNodeFactoryInstance == null) {
                copyNodeFactoryInstance = new CopyNodeFactory();
            }
            return copyNodeFactoryInstance;
        }

        public static KernelNodes.CopyNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return new CopyNodeGen(context, sourceSection, operand);
        }

        @GeneratedBy(value=KernelNodes.CopyNode.class)
        public static final class CopyNodeGen
        extends KernelNodes.CopyNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private CopyNodeGen(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public DynamicObject executeCopy(VirtualFrame frameValue, DynamicObject operandValue) {
                return this.copy(frameValue, operandValue);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.copy(frameValue, operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelClassNode.class)
    public static final class KernelClassNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelClassNode> {
        private static KernelClassNodeFactory kernelClassNodeFactoryInstance;

        private KernelClassNodeFactory() {
            super(KernelNodes.KernelClassNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.KernelClassNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelClassNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.KernelClassNode> getInstance() {
            if (kernelClassNodeFactoryInstance == null) {
                kernelClassNodeFactoryInstance = new KernelClassNodeFactory();
            }
            return kernelClassNodeFactoryInstance;
        }

        public static KernelNodes.KernelClassNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new KernelClassNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.KernelClassNode.class)
        public static final class KernelClassNodeGen
        extends KernelNodes.KernelClassNode {
            @Node.Child
            private RubyNode arguments0_;

            private KernelClassNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.getClass(frameValue, arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CallerLocationsNode.class)
    public static final class CallerLocationsNodeFactory
    extends NodeFactoryBase<KernelNodes.CallerLocationsNode> {
        private static CallerLocationsNodeFactory callerLocationsNodeFactoryInstance;

        private CallerLocationsNodeFactory() {
            super(KernelNodes.CallerLocationsNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.CallerLocationsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CallerLocationsNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.CallerLocationsNode> getInstance() {
            if (callerLocationsNodeFactoryInstance == null) {
                callerLocationsNodeFactoryInstance = new CallerLocationsNodeFactory();
            }
            return callerLocationsNodeFactoryInstance;
        }

        public static KernelNodes.CallerLocationsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CallerLocationsNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.CallerLocationsNode.class)
        public static final class CallerLocationsNodeGen
        extends KernelNodes.CallerLocationsNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private CallerLocationsNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="callerLocations(int, int)", value=KernelNodes.CallerLocationsNode.class)
            private static final class CallerLocations2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                CallerLocations2Node_(CallerLocationsNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((CallerLocations2Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((CallerLocations2Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.callerLocations(arguments0Value_, arguments1Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.callerLocations(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CallerLocationsNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new CallerLocations2Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="callerLocations(int, NotProvided)", value=KernelNodes.CallerLocationsNode.class)
            private static final class CallerLocations1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                CallerLocations1Node_(CallerLocationsNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((CallerLocations1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.callerLocations(arguments0Value_, arguments1Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof NotProvided) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.callerLocations(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CallerLocationsNodeGen root, Object arguments0Value) {
                    return new CallerLocations1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="callerLocations(NotProvided, NotProvided)", value=KernelNodes.CallerLocationsNode.class)
            private static final class CallerLocations0Node_
            extends BaseNode_ {
                CallerLocations0Node_(CallerLocationsNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof NotProvided && arguments1Value instanceof NotProvided) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.callerLocations(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CallerLocationsNodeGen root) {
                    return new CallerLocations0Node_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.CallerLocationsNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CallerLocationsNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CallerLocationsNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.CallerLocationsNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CallerLocationsNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CallerLocationsNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.CallerLocationsNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected CallerLocationsNodeGen root;

                BaseNode_(CallerLocationsNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (CallerLocationsNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        if (arguments0Value instanceof NotProvided) {
                            return CallerLocations0Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                            return CallerLocations1Node_.create(this.root, arguments0Value);
                        }
                    }
                    if (RubyTypesGen.isImplicitInteger(arguments0Value) && RubyTypesGen.isImplicitInteger(arguments1Value)) {
                        return CallerLocations2Node_.create(this.root, arguments0Value, arguments1Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CalleeNameNode.class)
    public static final class CalleeNameNodeFactory
    extends NodeFactoryBase<KernelNodes.CalleeNameNode> {
        private static CalleeNameNodeFactory calleeNameNodeFactoryInstance;

        private CalleeNameNodeFactory() {
            super(KernelNodes.CalleeNameNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.CalleeNameNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CalleeNameNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.CalleeNameNode> getInstance() {
            if (calleeNameNodeFactoryInstance == null) {
                calleeNameNodeFactoryInstance = new CalleeNameNodeFactory();
            }
            return calleeNameNodeFactoryInstance;
        }

        public static KernelNodes.CalleeNameNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CalleeNameNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.CalleeNameNode.class)
        public static final class CalleeNameNodeGen
        extends KernelNodes.CalleeNameNode {
            private CalleeNameNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.calleeName();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.BlockGivenNode.class)
    public static final class BlockGivenNodeFactory
    extends NodeFactoryBase<KernelNodes.BlockGivenNode> {
        private static BlockGivenNodeFactory blockGivenNodeFactoryInstance;

        private BlockGivenNodeFactory() {
            super(KernelNodes.BlockGivenNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.BlockGivenNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BlockGivenNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.BlockGivenNode> getInstance() {
            if (blockGivenNodeFactoryInstance == null) {
                blockGivenNodeFactoryInstance = new BlockGivenNodeFactory();
            }
            return blockGivenNodeFactoryInstance;
        }

        public static KernelNodes.BlockGivenNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BlockGivenNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.BlockGivenNode.class)
        public static final class BlockGivenNodeGen
        extends KernelNodes.BlockGivenNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private BlockGivenNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static MaterializedFrame expectMaterializedFrame(Object value) throws UnexpectedResultException {
                if (value instanceof MaterializedFrame) {
                    return (MaterializedFrame)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="blockGiven(NotProvided)", value=KernelNodes.BlockGivenNode.class)
            private static final class BlockGiven1Node_
            extends BaseNode_ {
                BlockGiven1Node_(BlockGivenNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    NotProvided arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.blockGiven(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        return this.root.blockGiven(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BlockGivenNodeGen root) {
                    return new BlockGiven1Node_(root);
                }
            }

            @GeneratedBy(methodName="blockGiven(MaterializedFrame, ConditionProfile)", value=KernelNodes.BlockGivenNode.class)
            private static final class BlockGiven0Node_
            extends BaseNode_ {
                private final ConditionProfile blockProfile;

                BlockGiven0Node_(BlockGivenNodeGen root, ConditionProfile blockProfile) {
                    super(root, 1);
                    this.blockProfile = blockProfile;
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    MaterializedFrame arguments0Value_;
                    try {
                        arguments0Value_ = BlockGivenNodeGen.expectMaterializedFrame(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.blockGiven(arguments0Value_, this.blockProfile);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof MaterializedFrame) {
                        MaterializedFrame arguments0Value_ = (MaterializedFrame)arguments0Value;
                        return this.root.blockGiven(arguments0Value_, this.blockProfile);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BlockGivenNodeGen root, ConditionProfile blockProfile) {
                    return new BlockGiven0Node_(root, blockProfile);
                }
            }

            @GeneratedBy(value=KernelNodes.BlockGivenNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BlockGivenNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BlockGivenNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.BlockGivenNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BlockGivenNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(BlockGivenNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=KernelNodes.BlockGivenNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected BlockGivenNodeGen root;

                BaseNode_(BlockGivenNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (BlockGivenNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof MaterializedFrame) {
                        ConditionProfile blockProfile1 = ConditionProfile.createBinaryProfile();
                        return BlockGiven0Node_.create(this.root, blockProfile1);
                    }
                    if (arguments0Value instanceof NotProvided) {
                        return BlockGiven1Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=KernelNodes.BindingNode.class)
    public static final class BindingNodeFactory
    extends NodeFactoryBase<KernelNodes.BindingNode> {
        private static BindingNodeFactory bindingNodeFactoryInstance;

        private BindingNodeFactory() {
            super(KernelNodes.BindingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.BindingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BindingNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.BindingNode> getInstance() {
            if (bindingNodeFactoryInstance == null) {
                bindingNodeFactoryInstance = new BindingNodeFactory();
            }
            return bindingNodeFactoryInstance;
        }

        public static KernelNodes.BindingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BindingNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.BindingNode.class)
        public static final class BindingNodeGen
        extends KernelNodes.BindingNode {
            private BindingNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.binding();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<KernelNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(KernelNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        public static KernelNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new CompareNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.CompareNode.class)
        public static final class CompareNodeGen
        extends KernelNodes.CompareNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private CompareNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.compare(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.NotMatchNode.class)
    public static final class NotMatchNodeFactory
    extends NodeFactoryBase<KernelNodes.NotMatchNode> {
        private static NotMatchNodeFactory notMatchNodeFactoryInstance;

        private NotMatchNodeFactory() {
            super(KernelNodes.NotMatchNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.NotMatchNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NotMatchNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.NotMatchNode> getInstance() {
            if (notMatchNodeFactoryInstance == null) {
                notMatchNodeFactoryInstance = new NotMatchNodeFactory();
            }
            return notMatchNodeFactoryInstance;
        }

        public static KernelNodes.NotMatchNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new NotMatchNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.NotMatchNode.class)
        public static final class NotMatchNodeGen
        extends KernelNodes.NotMatchNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private NotMatchNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.notMatch(frameValue, arguments0Value_, arguments1Value_);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.MatchNode.class)
    public static final class MatchNodeFactory
    extends NodeFactoryBase<KernelNodes.MatchNode> {
        private static MatchNodeFactory matchNodeFactoryInstance;

        private MatchNodeFactory() {
            super(KernelNodes.MatchNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.MatchNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MatchNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.MatchNode> getInstance() {
            if (matchNodeFactoryInstance == null) {
                matchNodeFactoryInstance = new MatchNodeFactory();
            }
            return matchNodeFactoryInstance;
        }

        public static KernelNodes.MatchNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new MatchNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.MatchNode.class)
        public static final class MatchNodeGen
        extends KernelNodes.MatchNode {
            @Node.Child
            private RubyNode arguments0_;

            private MatchNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.equal(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SameOrEqualNode.class)
    public static final class SameOrEqualNodeFactory
    extends NodeFactoryBase<KernelNodes.SameOrEqualNode> {
        private static SameOrEqualNodeFactory sameOrEqualNodeFactoryInstance;

        private SameOrEqualNodeFactory() {
            super(KernelNodes.SameOrEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.SameOrEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SameOrEqualNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.SameOrEqualNode> getInstance() {
            if (sameOrEqualNodeFactoryInstance == null) {
                sameOrEqualNodeFactoryInstance = new SameOrEqualNodeFactory();
            }
            return sameOrEqualNodeFactoryInstance;
        }

        public static KernelNodes.SameOrEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SameOrEqualNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.SameOrEqualNode.class)
        public static final class SameOrEqualNodeGen
        extends KernelNodes.SameOrEqualNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;

            private SameOrEqualNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public boolean executeSameOrEqual(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.sameOrEqual(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.sameOrEqual(frameValue, arguments0Value_, arguments1Value_);
            }
        }
    }

    @GeneratedBy(value=KernelNodes.BacktickNode.class)
    public static final class BacktickNodeFactory
    extends NodeFactoryBase<KernelNodes.BacktickNode> {
        private static BacktickNodeFactory backtickNodeFactoryInstance;

        private BacktickNodeFactory() {
            super(KernelNodes.BacktickNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public KernelNodes.BacktickNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BacktickNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<KernelNodes.BacktickNode> getInstance() {
            if (backtickNodeFactoryInstance == null) {
                backtickNodeFactoryInstance = new BacktickNodeFactory();
            }
            return backtickNodeFactoryInstance;
        }

        public static KernelNodes.BacktickNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new BacktickNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=KernelNodes.BacktickNode.class)
        public static final class BacktickNodeGen
        extends KernelNodes.BacktickNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private BacktickNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments0Value_)) {
                    return this.backtick(frameValue, arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }
}

