/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jcmdline.FileParam;
import jcmdline.Parameter;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import org.pdfsam.console.business.parser.handlers.interfaces.AbstractCmdHandler;

public class RotateCmdHandler
extends AbstractCmdHandler {
    private static final String COMMAND_DESCRIPTION = "Rotate pdf documents.";
    private final List rotateOptions = new ArrayList<Parameter>(Arrays.asList(new FileParam("o", "output directory", 65526, false, false), new PdfFileParam("f", "pdf files to rotate: a list of existing pdf files (EX. -f /tmp/file1.pdf -f /tmp/file2.pdf)", 65519, false, true), new StringParam("p", "prefix for the output files name", true), new StringParam("r", "pages rotation. You can set pages rotation. Accepted string is \"pages:rotationdegrees\" where pages can be one among \"all\", \"odd\", \"even\" and where rotationdegrees can be \"90\", \"180\" or \"270\". Pages will be rotate clockwise", false)));
    private final List rotateArguments = new ArrayList<Parameter>(Arrays.asList(new StringParam("command", "command to execute {[rotate]}", new String[]{"rotate"}, false)));
    private static final String ROTATE_HELP_TEXT = "Rotate pdf files. \nYou must specify '-o /home/user' to set the output directory.\nYou must specify '-f /tmp/file1.pdf /tmp/file2.pdf:password -f /tmp/file3.pdf [...]' to specify a file list to rotate (use filename:password if the file is password protected).\nYou must specify '-r all:90' to set pages rotation. (EX. -r all:90 will rotate all pages of 90 degrees clockwise. -r even:270 will rotate even pages of 170 degrees clockwise.)\n'-p prefix_' to specify a prefix for output names of files. If it contains \"[TIMESTAMP]\" it performs variable substitution. (Ex. [BASENAME]_prefix_[TIMESTAMP] generates FileName_prefix_20070517_113423471.pdf)\n";
    private static final String ROTATE_EXAMPLE = "Example: java -jar pdfsam-console-2.4.3e.jar -f /tmp/1.pdf -o /tmp -r odd:180 -overwrite rotate\n";

    public Collection getArguments() {
        return this.rotateArguments;
    }

    public String getCommandDescription() {
        return COMMAND_DESCRIPTION;
    }

    public String getHelpExamples() {
        return ROTATE_EXAMPLE;
    }

    public Collection getOptions() {
        return this.rotateOptions;
    }

    public String getHelpMessage() {
        return ROTATE_HELP_TEXT;
    }
}

