/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.validators;

import java.io.File;
import jcmdline.BooleanParam;
import jcmdline.CmdLineHandler;
import jcmdline.FileParam;
import jcmdline.IntParam;
import jcmdline.PdfFileParam;
import jcmdline.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.MixParsedCommand;
import org.pdfsam.console.business.parser.validators.interfaces.AbstractCmdValidator;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.ParseException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.ValidationUtility;

public class MixCmdValidator
extends AbstractCmdValidator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractParsedCommand validateArguments(CmdLineHandler cmdLineHandler) throws ConsoleException {
        MixParsedCommand parsedCommandDTO = new MixParsedCommand();
        if (cmdLineHandler == null) throw new ConsoleException(2);
        FileParam oOption = (FileParam)cmdLineHandler.getOption("o");
        if (!oOption.isSet()) {
            throw new ParseException(15);
        }
        File outFile = oOption.getFile();
        ValidationUtility.assertValidPdfExtension(outFile.getName());
        parsedCommandDTO.setOutputFile(outFile);
        PdfFileParam f1Option = (PdfFileParam)cmdLineHandler.getOption("f1");
        if (!f1Option.isSet()) {
            throw new ParseException(16);
        }
        PdfFile firstFile = f1Option.getPdfFile();
        ValidationUtility.assertValidPdfExtension(firstFile.getFile().getName());
        parsedCommandDTO.setFirstInputFile(FileUtility.getPdfFile(firstFile));
        PdfFileParam f2Option = (PdfFileParam)cmdLineHandler.getOption("f2");
        if (!f2Option.isSet()) {
            throw new ParseException(17);
        }
        PdfFile secondFile = f2Option.getPdfFile();
        ValidationUtility.assertValidPdfExtension(secondFile.getFile().getName());
        parsedCommandDTO.setSecondInputFile(FileUtility.getPdfFile(secondFile));
        IntParam stepOption = (IntParam)cmdLineHandler.getOption("step");
        if (stepOption.isSet()) {
            int step = stepOption.intValue();
            if (step <= 0) throw new ParseException(27);
            parsedCommandDTO.setStep(stepOption.intValue());
        } else {
            parsedCommandDTO.setStep(1);
        }
        IntParam secondStepOption = (IntParam)cmdLineHandler.getOption("secondstep");
        if (secondStepOption.isSet()) {
            int step = secondStepOption.intValue();
            if (step <= 0) throw new ParseException(27);
            parsedCommandDTO.setSecondStep(secondStepOption.intValue());
        } else {
            parsedCommandDTO.setSecondStep(parsedCommandDTO.getStep());
        }
        parsedCommandDTO.setReverseFirst(((BooleanParam)cmdLineHandler.getOption("reversefirst")).isTrue());
        parsedCommandDTO.setReverseSecond(((BooleanParam)cmdLineHandler.getOption("reversesecond")).isTrue());
        return parsedCommandDTO;
    }
}

