/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.handlers;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.PageLabel;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.PageLabelsParsedCommand;
import org.pdfsam.console.business.pdf.handlers.interfaces.AbstractCmdExecutor;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.PageLabelsException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.PdfUtility;

public class PageLabelsCmdExecutor
extends AbstractCmdExecutor {
    private static final Logger LOG = Logger.getLogger(PageLabelsCmdExecutor.class.getPackage().getName());
    private PdfReader pdfReader = null;
    private PdfCopy pdfWriter = null;

    public void execute(AbstractParsedCommand parsedCommand) throws ConsoleException {
        if (parsedCommand != null && parsedCommand instanceof PageLabelsParsedCommand) {
            PageLabelsParsedCommand inputCommand = (PageLabelsParsedCommand)parsedCommand;
            this.setPercentageOfWorkDone(0);
            try {
                File tmpFile = FileUtility.generateTmpFile(inputCommand.getOutputFile());
                LOG.debug("Opening " + inputCommand.getInputFile().getFile().getAbsolutePath());
                this.pdfReader = PdfUtility.readerFor(inputCommand.getInputFile());
                this.pdfReader.removeUnusedObjects();
                this.pdfReader.consolidateNamedDestinations();
                int n = this.pdfReader.getNumberOfPages();
                Document currentDocument = new Document(this.pdfReader.getPageSizeWithRotation(1));
                this.pdfWriter = new PdfCopy(currentDocument, (OutputStream)new FileOutputStream(tmpFile));
                this.setCompressionSettingOnWriter(inputCommand, (PdfWriter)this.pdfWriter);
                this.setPdfVersionSettingOnWriter(inputCommand, (PdfWriter)this.pdfWriter, Character.valueOf(this.pdfReader.getPdfVersion()));
                currentDocument.addCreator("pdfsam-console (Ver. 2.4.3e)");
                currentDocument.open();
                for (int count = 1; count <= n; ++count) {
                    this.pdfWriter.addPage(this.pdfWriter.getImportedPage(this.pdfReader, count));
                }
                this.pdfReader.close();
                this.pdfWriter.freeReader(this.pdfReader);
                PdfPageLabels pageLabels = new PdfPageLabels();
                PageLabel[] labels = inputCommand.getLabels();
                int stepsNumber = labels.length + 1;
                for (int i = 0; i < labels.length; ++i) {
                    if (labels[i].getPageNumber() <= n) {
                        pageLabels.addPageLabel(labels[i].getPageNumber(), this.getPageLabelStyle(labels[i].getStyle()), labels[i].getPrefix(), labels[i].getLogicalPageNumber());
                    } else {
                        LOG.warn("Page number out of range, label starting at page " + labels[i].getPageNumber() + " will be ignored");
                    }
                    this.setPercentageOfWorkDone(i * 1000 / stepsNumber);
                }
                this.pdfWriter.setPageLabels(pageLabels);
                currentDocument.close();
                this.pdfWriter.close();
                FileUtility.renameTemporaryFile(tmpFile, inputCommand.getOutputFile(), inputCommand.isOverwrite());
                LOG.debug("Page labels set on file " + inputCommand.getOutputFile());
            }
            catch (Exception e) {
                throw new PageLabelsException(e);
            }
            finally {
                this.setWorkCompleted();
            }
        } else {
            throw new ConsoleException(5);
        }
    }

    private int getPageLabelStyle(String style) {
        int retVal = 0;
        if ("arabic".equals(style)) {
            retVal = 0;
        } else if ("empty".equals(style)) {
            retVal = 5;
        } else if ("lletter".equals(style)) {
            retVal = 4;
        } else if ("lroman".equals(style)) {
            retVal = 2;
        } else if ("uletter".equals(style)) {
            retVal = 3;
        } else if ("uroman".equals(style)) {
            retVal = 1;
        }
        return retVal;
    }

    public void clean() {
        this.closePdfReader(this.pdfReader);
        this.closePdfWriter((PdfWriter)this.pdfWriter);
    }
}

