/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.Bounds;
import org.pdfsam.console.business.dto.PageLabel;
import org.pdfsam.console.business.dto.PageRotation;
import org.pdfsam.console.exceptions.console.ValidationException;

public final class ValidationUtility {
    private static final Logger LOG = Logger.getLogger(ValidationUtility.class.getPackage().getName());
    public static final String ALL_STRING = "all";
    public static final String ODD_STRING = "odd";
    public static final String EVEN_STRING = "even";
    private static final String SELECTION_REGEXP = "(?:(?:[\\d]+[-]?[\\d]*)(?:,(?:[\\d]+[-]?[\\d]*))*)+";
    public static final String PDF_EXTENSION = ".pdf";

    private ValidationUtility() {
    }

    public static PageRotation[] getPagesRotation(String inputString, boolean allowSinglePagesRotation) throws ValidationException {
        ArrayList<PageRotation> retVal;
        block12: {
            retVal = new ArrayList<PageRotation>();
            try {
                if (inputString == null || inputString.length() <= 0) break block12;
                String[] rotateParams = inputString.split(",");
                for (int i = 0; i < rotateParams.length; ++i) {
                    String currentRotation = rotateParams[i];
                    if (currentRotation.length() > 3) {
                        String[] rotationParams = currentRotation.split(":");
                        if (rotationParams.length == 2) {
                            String pageNumber = rotationParams[0].trim();
                            int degrees = Integer.parseInt(rotationParams[1]) % 360;
                            if (degrees % 90 != 0) {
                                throw new ValidationException(2, new String[]{Integer.toString(degrees)});
                            }
                            if (ALL_STRING.equals(pageNumber)) {
                                if (!retVal.isEmpty()) {
                                    LOG.warn("Page rotation for every page found, other rotations removed");
                                    retVal.clear();
                                }
                                retVal.add(new PageRotation(-1, degrees, 3));
                                break;
                            }
                            if (ODD_STRING.equals(pageNumber)) {
                                if (!retVal.isEmpty()) {
                                    LOG.warn("Page rotation for odd pages found, other rotations removed");
                                    retVal.clear();
                                }
                                retVal.add(new PageRotation(-1, degrees, 1));
                                break;
                            }
                            if (EVEN_STRING.equals(pageNumber)) {
                                if (!retVal.isEmpty()) {
                                    LOG.warn("Page rotation for even pages found, other rotations removed");
                                    retVal.clear();
                                }
                                retVal.add(new PageRotation(-1, degrees, 2));
                                break;
                            }
                            if (!allowSinglePagesRotation) continue;
                            retVal.add(new PageRotation(Integer.parseInt(pageNumber), degrees));
                            continue;
                        }
                        throw new ValidationException(3, new String[]{currentRotation});
                    }
                    throw new ValidationException(3, new String[]{currentRotation});
                }
            }
            catch (Exception e) {
                throw new ValidationException(1, e);
            }
        }
        return retVal.toArray(new PageRotation[retVal.size()]);
    }

    public static PageLabel getPageLabel(String inputString) throws ValidationException {
        PageLabel retVal = null;
        if (inputString != null && inputString.length() > 0) {
            String[] values = inputString.split(":");
            if (values.length >= 2) {
                try {
                    retVal = new PageLabel();
                    retVal.setPageNumber(Integer.parseInt(values[0]));
                    if (values.length == 3) {
                        retVal.setLogicalPageNumber(Integer.parseInt(values[2]));
                    }
                }
                catch (Exception e) {
                    throw new ValidationException(6, new String[]{inputString}, e);
                }
                retVal.setStyle(ValidationUtility.getPageLabelStyle(values[1]));
            } else {
                throw new ValidationException(6, new String[]{inputString});
            }
        }
        return retVal;
    }

    private static String getPageLabelStyle(String inputString) throws ValidationException {
        String retVal = null;
        if (inputString != null && inputString.length() > 0) {
            if (!("arabic".equals(inputString) || "empty".equals(inputString) || "lletter".equals(inputString) || "lroman".equals(inputString) || "uletter".equals(inputString) || "uroman".equals(inputString))) {
                throw new ValidationException(7, new String[]{inputString});
            }
        } else {
            throw new ValidationException(7, new String[]{inputString});
        }
        retVal = inputString;
        return retVal;
    }

    public static PageRotation[] getPagesRotation(String inputString) throws ValidationException {
        return ValidationUtility.getPagesRotation(inputString, true);
    }

    public static void assertValidPdfExtension(String inputFileName) throws ValidationException {
        if (!inputFileName.toLowerCase().endsWith(PDF_EXTENSION) || inputFileName.length() <= PDF_EXTENSION.length()) {
            throw new ValidationException(4, new String[]{inputFileName});
        }
    }

    public static void assertValidDirectory(File inputDir) throws ValidationException {
        if (!inputDir.isDirectory()) {
            throw new ValidationException(5, new String[]{inputDir.getAbsolutePath()});
        }
    }

    public static void assertValidPageSelectionsArray(String[] selections) throws ValidationException {
        if (!ValidationUtility.isValidPageSelectionsArray(selections)) {
            throw new ValidationException(9);
        }
    }

    public static boolean isValidPageSelectionsArray(String[] selections) {
        boolean retVal = true;
        if (!ArrayUtils.isEmpty((Object[])selections)) {
            Pattern pattern = Pattern.compile(SELECTION_REGEXP, 2);
            for (int i = 0; i < selections.length; ++i) {
                String currentSelection = selections[i];
                if (ALL_STRING.equalsIgnoreCase(currentSelection) || pattern.matcher(currentSelection).matches()) continue;
                retVal = false;
                break;
            }
        }
        return retVal;
    }

    public static void assertValidBounds(Bounds bounds, int pdfNumberOfPages) throws ValidationException {
        if (bounds.getStart() <= 0) {
            throw new ValidationException(10, new String[]{Integer.toString(bounds.getStart()), bounds.toString()});
        }
        if (bounds.getEnd() > pdfNumberOfPages) {
            throw new ValidationException(11, new String[]{Integer.toString(bounds.getEnd())});
        }
        if (bounds.getStart() > bounds.getEnd()) {
            throw new ValidationException(12, new String[]{Integer.toString(bounds.getStart()), Integer.toString(bounds.getEnd()), bounds.toString()});
        }
    }

    public static void assertNotIntersectedBoundsList(List bounds) throws ValidationException {
        for (int i = 0; i < bounds.size(); ++i) {
            Bounds victim = (Bounds)bounds.get(i);
            for (int j = i + 1; j < bounds.size(); ++j) {
                Bounds current = (Bounds)bounds.get(j);
                if (!victim.intersects(current)) continue;
                throw new ValidationException(13, new String[]{victim.toString(), current.toString()});
            }
        }
    }
}

