/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.adapter;

import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapterRegistry;
import de.intarsys.tools.provider.ProviderTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StandardGraphicsEnvironmentAdapterRegistry
implements IGraphicsEnvironmentAdapterRegistry {
    private boolean lookupProviders = true;
    private Map<IGraphicsEnvironment, IGraphicsEnvironmentAdapter> adapters = new HashMap<IGraphicsEnvironment, IGraphicsEnvironmentAdapter>();
    private boolean initialized = false;

    protected IGraphicsEnvironmentAdapter[] findProviders() {
        Iterator iterator = ProviderTools.providers(IGraphicsEnvironmentAdapter.class);
        ArrayList<IGraphicsEnvironmentAdapter> arrayList = new ArrayList<IGraphicsEnvironmentAdapter>();
        while (iterator.hasNext()) {
            try {
                arrayList.add((IGraphicsEnvironmentAdapter)iterator.next());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return arrayList.toArray(new IGraphicsEnvironmentAdapter[arrayList.size()]);
    }

    protected void init() {
        if (!this.lookupProviders || this.initialized) {
            return;
        }
        this.initialized = true;
        IGraphicsEnvironmentAdapter[] iGraphicsEnvironmentAdapterArray = this.findProviders();
        int n = 0;
        while (n < iGraphicsEnvironmentAdapterArray.length) {
            this.registerGraphicsEnvironmentAdapter(iGraphicsEnvironmentAdapterArray[n].getGraphicsEnvironment(), iGraphicsEnvironmentAdapterArray[n]);
            ++n;
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    @Override
    public synchronized IGraphicsEnvironmentAdapter lookupGraphicsEnvironmentAdapter(IGraphicsEnvironment iGraphicsEnvironment) {
        this.init();
        IGraphicsEnvironmentAdapter iGraphicsEnvironmentAdapter = this.adapters.get(iGraphicsEnvironment);
        return iGraphicsEnvironmentAdapter;
    }

    @Override
    public synchronized void registerGraphicsEnvironmentAdapter(IGraphicsEnvironment iGraphicsEnvironment, IGraphicsEnvironmentAdapter iGraphicsEnvironmentAdapter) {
        this.adapters.put(iGraphicsEnvironment, iGraphicsEnvironmentAdapter);
    }

    public void setLookupProviders(boolean bl) {
        this.lookupProviders = bl;
    }
}

