/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.ICOSDocumentListener;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.platform.cwt.font.StandardFontFactory;
import java.util.List;

public class DocumentFontFactory
extends StandardFontFactory {
    private final PDDocument doc;
    private ICOSDocumentListener listenDocumentChange = new ICOSDocumentListener(){

        public void changed(COSDocument cOSDocument, Object object, Object object2, Object object3) {
            if (object == COSDocument.SLOT_ALL) {
                DocumentFontFactory.this.reset();
            }
        }
    };

    protected DocumentFontFactory(PDDocument pDDocument) {
        this.doc = pDDocument;
        pDDocument.cosGetDoc().addDocumentListener(this.listenDocumentChange);
        this.readFonts();
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    protected void readFonts() {
        List list = PDFontTools.getFonts((PDDocument)this.getDoc());
        for (PDFont pDFont : list) {
            if (!this.isReusable(pDFont)) continue;
            this.registerFont(pDFont);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.readFonts();
    }
}

