/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.paint;

import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.platform.cwt.adapter.GraphicsEnvironmentAdapterRegistry;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.paint.AbstractPaint;

public class ShadingPaint
extends AbstractPaint {
    private float alphaValue;
    private PDShading shading;

    public ShadingPaint(PDShading pDShading) {
        this.shading = pDShading;
        this.alphaValue = 1.0f;
    }

    public IPaint copy() {
        ShadingPaint shadingPaint = new ShadingPaint(this.shading);
        shadingPaint.alphaValue = this.alphaValue;
        shadingPaint.shading = this.shading;
        return shadingPaint;
    }

    public float getAlphaValue() {
        return this.alphaValue;
    }

    public PDShading getPdShading() {
        return this.shading;
    }

    public void setAlphaValue(float f) {
        this.alphaValue = f;
    }

    public void setBackgroundPaintFromGraphicsContext(IGraphicsContext iGraphicsContext) {
        IGraphicsEnvironmentAdapter iGraphicsEnvironmentAdapter = GraphicsEnvironmentAdapterRegistry.get().lookupGraphicsEnvironmentAdapter(iGraphicsContext.getGraphicsEnvironment());
        iGraphicsEnvironmentAdapter.setBackgroundShadingPaint(iGraphicsContext, this);
    }

    public void setForegroundPaintFromGraphicsContext(IGraphicsContext iGraphicsContext) {
        IGraphicsEnvironmentAdapter iGraphicsEnvironmentAdapter = GraphicsEnvironmentAdapterRegistry.get().lookupGraphicsEnvironmentAdapter(iGraphicsContext.getGraphicsEnvironment());
        iGraphicsEnvironmentAdapter.setForegroundShadingPaint(iGraphicsContext, this);
    }
}

