/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient;

import java.awt.Point;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.thumbnails.ThumbnailCreatorsRegisty;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.configuration.GuiConfiguration;
import org.pdfsam.guiclient.gui.frames.JMainFrame;
import org.pdfsam.guiclient.utils.filters.JarFilter;

public class GuiClient {
    private static final long serialVersionUID = -3608998690519362986L;
    private static final Logger log = Logger.getLogger(GuiClient.class.getPackage().getName());
    private static final String PROPERTY_FILE = "pdfsam.properties";
    private static final String NO_GUI_RESTORE_ARG = "-skipGui";
    public static final String AUTHOR = "Andrea Vacondio";
    public static final String UNIXNAME = "pdfsam";
    private static final String NAME = "PDF Split and Merge";
    private static final String VERSION_TYPE_PROPERTY = "pdfsam.version";
    private static final String VERSION_TYPE_DEFAULT = "basic";
    private static final String VERSION_PROPERTY = "pdfsam.jar.version";
    private static final String VERSION_DEFAULT = "1.0.0";
    private static final String BUILDDATE_PROPERTY = "pdfsam.builddate";
    private static final String BUILDDATE_DEFAULT = "";
    private static final String BRANCH_PROPERTY = "pdfsam.branch";
    private static final String BRANCH_DEFAULT = "1";
    private static JMainFrame clientGUI;
    private static Properties defaultProps;

    public static void main(String[] args) {
        try {
            GuiClient.loadApplicationProperties();
            GuiClient.loadExtendedLibraries();
            clientGUI = new JMainFrame();
            GuiClient.initializeUserInterface(args.length > 0 && NO_GUI_RESTORE_ARG.equalsIgnoreCase(args[0]));
            clientGUI.setVisible(true);
            GuiClient.initializeExtendedState();
        }
        catch (Throwable t) {
            log.fatal("Error:", t);
        }
    }

    private static void loadApplicationProperties() {
        try {
            InputStream is = GuiClient.class.getClassLoader().getResourceAsStream(PROPERTY_FILE);
            defaultProps.load(is);
        }
        catch (Exception e) {
            log.error("Unable to load pdfsam properties.", e);
        }
    }

    private static void loadExtendedLibraries() {
        try {
            String configSearchPath = new File(URLDecoder.decode(GuiClient.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8")).getParent();
            File currentDir = new File(configSearchPath, "ext");
            Object[] fileList = currentDir.listFiles(new JarFilter(false));
            if (!ArrayUtils.isEmpty((Object[])fileList)) {
                URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                for (Object currentFile : fileList) {
                    GuiClient.addJar(((File)currentFile).toURI().toURL(), urlClassLoader);
                }
                ThumbnailCreatorsRegisty.reload(urlClassLoader);
            }
        }
        catch (Exception e) {
            log.error("Unable to load extended libraries.", e);
        }
    }

    private static void addJar(URL jarUrl, URLClassLoader loader) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)loader, jarUrl);
    }

    public static String getVersion() {
        return defaultProps.getProperty(VERSION_PROPERTY, VERSION_DEFAULT);
    }

    public static String getApplicationName() {
        return "PDF Split and Merge " + defaultProps.getProperty(VERSION_TYPE_PROPERTY, VERSION_TYPE_DEFAULT);
    }

    public static String getVersionType() {
        return defaultProps.getProperty(VERSION_TYPE_PROPERTY, VERSION_TYPE_DEFAULT);
    }

    public static String getBuildDate() {
        return defaultProps.getProperty(BUILDDATE_PROPERTY, BUILDDATE_DEFAULT);
    }

    public static String getBranch() {
        return defaultProps.getProperty(BRANCH_PROPERTY, BRANCH_DEFAULT);
    }

    private static void initializeExtendedState() {
        clientGUI.setExtendedState(GuiConfiguration.getInstance().getExtendedState());
    }

    private static void initializeUserInterface(boolean skipGui) {
        if (!skipGui) {
            String defaultEnv;
            String selectedPlugin;
            Point locationOnScreen;
            if (GuiConfiguration.getInstance().getSize() != null) {
                clientGUI.setSize(GuiConfiguration.getInstance().getSize());
            }
            if ((locationOnScreen = GuiConfiguration.getInstance().getLocationOnScreen()) != null && locationOnScreen.x != -32000 && locationOnScreen.y != -32000) {
                clientGUI.setLocation(locationOnScreen);
            }
            if (GuiConfiguration.getInstance().getHorizontalDividerDimension() != null) {
                clientGUI.setHorizontalDividerDimension(GuiConfiguration.getInstance().getHorizontalDividerDimension());
            }
            if (GuiConfiguration.getInstance().getHorizontalDividerLocation() > 0) {
                clientGUI.setHorizontalDividerLocation(GuiConfiguration.getInstance().getHorizontalDividerLocation());
            } else {
                clientGUI.setHorizontalDividerLocation(155);
            }
            if (GuiConfiguration.getInstance().getVerticalDividerDimension() != null) {
                clientGUI.setVerticalDividerDimension(GuiConfiguration.getInstance().getVerticalDividerDimension());
            }
            if (GuiConfiguration.getInstance().getVerticalDividerLocation() > 0) {
                clientGUI.setVerticalDividerLocation(GuiConfiguration.getInstance().getVerticalDividerLocation());
            }
            if ((selectedPlugin = GuiConfiguration.getInstance().getSelectedPlugin()) != null && selectedPlugin.length() > 0 && ((defaultEnv = Configuration.getInstance().getDefaultEnvironment()) == null || defaultEnv.length() <= 0)) {
                clientGUI.getTreePanel().setSelectedPlugin(selectedPlugin);
            }
        }
        clientGUI.rebuildRecentEnvironmentsMenu();
    }

    static {
        defaultProps = new Properties();
    }
}

