/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business;

import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.commons.components.JVisualSelectionList;
import org.pdfsam.guiclient.commons.models.VisualListModel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class PagesWorker {
    private static final Logger log = Logger.getLogger(PagesWorker.class.getPackage().getName());
    public static final String MOVE_UP = "moveUp";
    public static final String MOVE_DOWN = "moveDown";
    public static final String REMOVE = "remove";
    public static final String UNDELETE = "undelete";
    public static final String ROTATE_CLOCK = "rotateclock";
    public static final String ROTATE_ANTICLOCK = "rotateanticlock";
    public static final String REVERSE = "reverse";
    private JVisualSelectionList list;

    public PagesWorker(JVisualSelectionList list) {
        this.list = list;
    }

    public void execute(String action) {
        int[] selectedIndexes;
        if (action != null && (selectedIndexes = this.list.getSelectedIndices()) != null && selectedIndexes.length > 0) {
            if (MOVE_UP.equals(action)) {
                ((VisualListModel)this.list.getModel()).moveUpIndexes(selectedIndexes);
                if (selectedIndexes[0] > 0) {
                    this.list.setSelectionInterval(selectedIndexes[0] - 1, selectedIndexes[selectedIndexes.length - 1] - 1);
                }
            } else if (MOVE_DOWN.equals(action)) {
                ((VisualListModel)this.list.getModel()).moveDownIndexes(selectedIndexes);
                if (selectedIndexes[selectedIndexes.length - 1] < ((VisualListModel)this.list.getModel()).getSize() - 1) {
                    this.list.setSelectionInterval(selectedIndexes[0] + 1, selectedIndexes[selectedIndexes.length - 1] + 1);
                }
            } else if (REMOVE.equals(action)) {
                ((VisualListModel)this.list.getModel()).removeElements(selectedIndexes, !this.list.isDrawDeletedItems());
            } else if (UNDELETE.equals(action)) {
                ((VisualListModel)this.list.getModel()).undeleteElements(selectedIndexes);
            } else if (ROTATE_CLOCK.equals(action)) {
                ((VisualListModel)this.list.getModel()).rotateClockwiseElements(selectedIndexes);
            } else if (ROTATE_ANTICLOCK.equals(action)) {
                ((VisualListModel)this.list.getModel()).rotateAnticlockwiseElements(selectedIndexes);
            } else if (REVERSE.equals(action)) {
                ((VisualListModel)this.list.getModel()).reverseElements(selectedIndexes);
            } else {
                log.warn(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unknown Action"));
            }
        }
    }
}

