/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.business.actions;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.pdfsam.guiclient.commons.business.loaders.PdfLoader;
import org.pdfsam.guiclient.commons.components.JPdfSelectionTable;
import org.pdfsam.guiclient.commons.models.AbstractPdfSelectionTableModel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.i18n.GettextResource;

public class ReloadDocumentSelectionTableAction
extends AbstractAction {
    private static final long serialVersionUID = 8142152957534813440L;
    private JPdfSelectionTable mainTable;
    private PdfLoader loader;

    public ReloadDocumentSelectionTableAction(JPdfSelectionTable mainTable, PdfLoader loader) {
        super(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Reload"));
        this.setEnabled(true);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 512));
        this.putValue("ShortDescription", GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Reload the selected document"));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/reload.png")));
        this.mainTable = mainTable;
        this.loader = loader;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectedRow = this.mainTable.getSelectedRow();
        if (this.mainTable.getSelectedRowCount() == 1) {
            PdfSelectionTableItem row = ((AbstractPdfSelectionTableModel)this.mainTable.getModel()).getRow(selectedRow);
            this.loader.reloadFile(row.getInputFile(), row.getPassword(), row.getPageSelection(), selectedRow);
        }
    }
}

