/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.business.loaders;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.pdfsam.guiclient.commons.business.loaders.PdfDocumentLoadedHook;
import org.pdfsam.guiclient.commons.business.loaders.callable.AddPdfDocument;

public class PdfLoaderExecutor {
    private ExecutorService executor;
    private List<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();

    public synchronized void execute(AddPdfDocument callable, PdfDocumentLoadedHook hook) {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        if (!this.isExecuting()) {
            this.futures.clear();
        }
        this.futures.add(this.executor.submit(callable));
        if (hook != null) {
            this.executor.submit(new HookedCallable(hook));
        }
    }

    public boolean isExecuting() {
        boolean retVal = false;
        for (Future<Boolean> future : this.futures) {
            if (future.isDone()) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    private class HookedCallable
    implements Callable<Boolean> {
        private PdfDocumentLoadedHook hook;

        public HookedCallable(PdfDocumentLoadedHook hook) {
            this.hook = hook;
        }

        @Override
        public Boolean call() throws Exception {
            this.hook.afterDocumentLoaded();
            return Boolean.TRUE;
        }
    }
}

