/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.dnd.handlers;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.commons.business.loaders.PdfThumbnailsLoader;
import org.pdfsam.guiclient.commons.components.JVisualSelectionList;
import org.pdfsam.guiclient.commons.dnd.DnDSupportUtility;
import org.pdfsam.guiclient.commons.dnd.transferables.VisualPageListTransferable;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.VisualPageListItem;
import org.pdfsam.guiclient.utils.filters.PdfFilter;
import org.pdfsam.i18n.GettextResource;

public class VisualListExportTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -8912890262680226922L;
    private static final Logger log = Logger.getLogger(VisualListExportTransferHandler.class.getPackage().getName());
    private PdfThumbnailsLoader loader = null;

    public VisualListExportTransferHandler() {
        this((PdfThumbnailsLoader)null);
    }

    public VisualListExportTransferHandler(PdfThumbnailsLoader loader) {
        this.loader = loader;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        VisualPageListTransferable retVal = null;
        Object[] selectedList = ((JVisualSelectionList)c).getSelectedValues();
        if (selectedList != null && selectedList.length > 0) {
            VisualPageListItem[] items = new VisualPageListItem[selectedList.length];
            for (int i = 0; i < selectedList.length; ++i) {
                items[i] = (VisualPageListItem)selectedList[i];
            }
            int[] indexes = ((JVisualSelectionList)c).getSelectedIndices();
            retVal = new VisualPageListTransferable(items, indexes);
        }
        return retVal;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        boolean retVal = false;
        if (this.loader != null && info.getComponent() instanceof JVisualSelectionList) {
            retVal = info.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || info.isDataFlavorSupported(DnDSupportUtility.URI_LIST_FLAVOR);
        }
        return retVal;
    }

    protected PdfThumbnailsLoader getLoader() {
        return this.loader;
    }

    protected void setLoader(PdfThumbnailsLoader loader) {
        this.loader = loader;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        boolean retVal = false;
        if (this.loader != null) {
            List<File> fileList = null;
            try {
                if (info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    fileList = (List<File>)info.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                } else if (info.isDataFlavorSupported(DnDSupportUtility.URI_LIST_FLAVOR)) {
                    fileList = DnDSupportUtility.textURIListToFileList((String)info.getTransferable().getTransferData(DnDSupportUtility.URI_LIST_FLAVOR));
                }
                if (fileList != null) {
                    if (fileList.size() != 1) {
                        log.warn(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please select a single pdf document."));
                    } else {
                        File selectedFile = fileList.get(0);
                        if (selectedFile != null && new PdfFilter(false).accept(selectedFile)) {
                            this.loader.addFile(selectedFile, true);
                            retVal = true;
                        } else {
                            log.warn(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"File type not supported."));
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error during drag and drop."), e);
            }
        }
        return retVal;
    }
}

