/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.configuration.services.xml;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.configuration.services.GuiConfigurationService;
import org.pdfsam.guiclient.configuration.services.xml.XmlConfigurationService;
import org.pdfsam.guiclient.utils.XmlUtility;
import org.pdfsam.i18n.GettextResource;

public class XmlGuiConfigurationService
implements GuiConfigurationService {
    private static final Logger LOG = Logger.getLogger(XmlGuiConfigurationService.class.getPackage().getName());
    public static final String CONFIGURATION_FILE_NAME = "gui-config.xml";
    private static final String ROOT_NODE = "/pdfsam-gui";
    private static final String EXTENDED_STATE_XPATH = "/gui-settings/extended-state/@value";
    private static final String SELECTED_PLUGIN_XPATH = "/gui-settings/selected-plugin/@class";
    private static final String LOCATION_X_XPATH = "/gui-settings/location/@xvalue";
    private static final String LOCATION_Y_XPATH = "/gui-settings/location/@yvalue";
    private static final String SIZE_WIDTH_XPATH = "/gui-settings/size/@width";
    private static final String SIZE_HEIGHT_XPATH = "/gui-settings/size/@height";
    private static final String VERTICAL_DIVIDER_LOCATION_XPATH = "/gui-settings/vertical-divider/@location";
    private static final String VERTICAL_DIVIDER_HEIGHT_XPATH = "/gui-settings/vertical-divider/@height";
    private static final String VERTICAL_DIVIDER_WIDTH_XPATH = "/gui-settings/vertical-divider/@width";
    private static final String HORIZONTAL_DIVIDER_LOCATION_XPATH = "/gui-settings/horizontal-divider/@location";
    private static final String HORIZONTAL_DIVIDER_HEIGHT_XPATH = "/gui-settings/horizontal-divider/@height";
    private static final String HORIZONTAL_DIVIDER_WIDTH_XPATH = "/gui-settings/horizontal-divider/@width";
    private static final String RECENT_ENVS_NODE_XPATH = "env/@value";
    private static final String RECENT_ENVS_PARENT_XPATH = "/recent_envs/";
    private Document document;
    private int extendedState = 6;
    private Dimension size;
    private Point locationOnScreen;
    private File configurationFile;
    private int horizontalDividerLocation;
    private Dimension horizontalDividerDimension;
    private int verticalDividerLocation;
    private Dimension verticalDividerDimension;
    private String selectedPlugin;
    private Deque<String> recentEnvironments = new ArrayDeque<String>();

    public XmlGuiConfigurationService() {
        this.initializeService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeService() {
        LOG.info(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Loading user interface configuration") + "..");
        this.configurationFile = new File(XmlConfigurationService.DEFAULT_CONFIG_DIRECTORY, CONFIGURATION_FILE_NAME);
        if (!this.configurationFile.exists()) {
            LOG.warn(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to find configuration file for the user interface"));
        } else {
            try {
                this.document = XmlUtility.parseXmlFile(this.configurationFile);
                if (this.document != null) {
                    this.iniExtendedState();
                    this.selectedPlugin = XmlUtility.getXmlValue(this.document, "/pdfsam-gui/gui-settings/selected-plugin/@class");
                    this.initDimension();
                    this.initLocationOnScreen();
                    this.initDividersLocation();
                    this.initHorizontalDividerDimension();
                    this.initVerticalDividerDimension();
                    this.initRecentEnvs();
                }
            }
            catch (DocumentException e) {
                LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error reading the configuration file for the user interface"), e);
            }
            finally {
                this.document = null;
            }
        }
    }

    private void initRecentEnvs() {
        this.recentEnvironments = new ArrayDeque<String>();
        for (String env : XmlUtility.getXmlValues(this.document, "/pdfsam-gui/recent_envs/env/@value")) {
            this.recentEnvironments.addLast(env);
        }
    }

    private void initDividersLocation() {
        String verticalLocation = XmlUtility.getXmlValue(this.document, "/pdfsam-gui/gui-settings/vertical-divider/@location");
        String horizontalLocation = XmlUtility.getXmlValue(this.document, "/pdfsam-gui/gui-settings/horizontal-divider/@location");
        if (verticalLocation.length() > 0) {
            try {
                this.verticalDividerLocation = Integer.parseInt(verticalLocation);
            }
            catch (NumberFormatException nfe) {
                LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error initializing the user interface vertical divider location"), nfe);
            }
        }
        if (horizontalLocation.length() > 0) {
            try {
                this.horizontalDividerLocation = Integer.parseInt(horizontalLocation);
            }
            catch (NumberFormatException nfe) {
                LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error initializing the user interface horizontal divider location"), nfe);
            }
        }
    }

    private void iniExtendedState() {
        String state = XmlUtility.getXmlValue(this.document, "/pdfsam-gui/gui-settings/extended-state/@value");
        if (state.length() > 0) {
            try {
                this.extendedState = Integer.parseInt(state);
            }
            catch (NumberFormatException nfe) {
                LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error initializing the user interface extended state"), nfe);
            }
        }
    }

    private void initDimension() {
        String width = XmlUtility.getXmlValue(this.document, "/pdfsam-gui/gui-settings/size/@width");
        String height = XmlUtility.getXmlValue(this.document, "/pdfsam-gui/gui-settings/size/@height");
        if (width.length() > 0 && height.length() > 0) {
            try {
                this.size = new Dimension(Integer.parseInt(width), Integer.parseInt(height));
            }
            catch (NumberFormatException nfe) {
                LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error initializing the user interface size"), nfe);
            }
        }
    }

    private void initHorizontalDividerDimension() {
        String width = XmlUtility.getXmlValue(this.document, "/pdfsam-gui/gui-settings/horizontal-divider/@width");
        String height = XmlUtility.getXmlValue(this.document, "/pdfsam-gui/gui-settings/horizontal-divider/@height");
        if (width.length() > 0 && height.length() > 0) {
            try {
                this.horizontalDividerDimension = new Dimension(Integer.parseInt(width), Integer.parseInt(height));
            }
            catch (NumberFormatException nfe) {
                LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error initializing the user interface horizontal divider size"), nfe);
            }
        }
    }

    private void initVerticalDividerDimension() {
        String width = XmlUtility.getXmlValue(this.document, "/pdfsam-gui/gui-settings/vertical-divider/@width");
        String height = XmlUtility.getXmlValue(this.document, "/pdfsam-gui/gui-settings/vertical-divider/@height");
        if (width.length() > 0 && height.length() > 0) {
            try {
                this.verticalDividerDimension = new Dimension(Integer.parseInt(width), Integer.parseInt(height));
            }
            catch (NumberFormatException nfe) {
                LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error initializing the user interface vertical divider size"), nfe);
            }
        }
    }

    private void initLocationOnScreen() {
        String x = XmlUtility.getXmlValue(this.document, "/pdfsam-gui/gui-settings/location/@xvalue");
        String y = XmlUtility.getXmlValue(this.document, "/pdfsam-gui/gui-settings/location/@yvalue");
        if (x.length() > 0 && y.length() > 0) {
            try {
                this.locationOnScreen = new Point(Integer.parseInt(x), Integer.parseInt(y));
            }
            catch (NumberFormatException nfe) {
                LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error initializing the user interface location"), nfe);
            }
        }
    }

    @Override
    public int getExtendedState() {
        return this.extendedState;
    }

    @Override
    public void setExtendedState(int extendedState) {
        this.extendedState = extendedState;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public void setSize(Dimension size) {
        this.size = size;
    }

    @Override
    public Point getLocationOnScreen() {
        return this.locationOnScreen;
    }

    @Override
    public void setLocationOnScreen(Point locationOnScreen) {
        this.locationOnScreen = locationOnScreen;
    }

    @Override
    public int getHorizontalDividerLocation() {
        return this.horizontalDividerLocation;
    }

    @Override
    public void setHorizontalDividerLocation(int horizontalDividerLocation) {
        this.horizontalDividerLocation = horizontalDividerLocation;
    }

    @Override
    public int getVerticalDividerLocation() {
        return this.verticalDividerLocation;
    }

    @Override
    public void setVerticalDividerLocation(int verticalDividerLocation) {
        this.verticalDividerLocation = verticalDividerLocation;
    }

    @Override
    public Dimension getHorizontalDividerDimension() {
        return this.horizontalDividerDimension;
    }

    @Override
    public void setHorizontalDividerDimension(Dimension horizontalDividerDimension) {
        this.horizontalDividerDimension = horizontalDividerDimension;
    }

    @Override
    public Dimension getVerticalDividerDimension() {
        return this.verticalDividerDimension;
    }

    @Override
    public void setVerticalDividerDimension(Dimension verticalDividerDimension) {
        this.verticalDividerDimension = verticalDividerDimension;
    }

    @Override
    public String getSelectedPlugin() {
        return this.selectedPlugin;
    }

    @Override
    public void setSelectedPlugin(String selectedPlugin) {
        this.selectedPlugin = selectedPlugin;
    }

    @Override
    public Collection<String> getRecentEnvironments() {
        return this.recentEnvironments;
    }

    @Override
    public void addRecentEnvironment(String envPath) {
        if (envPath != null) {
            if (this.recentEnvironments.contains(envPath)) {
                this.recentEnvironments.remove(envPath);
            } else {
                while (this.recentEnvironments.size() > 8) {
                    this.recentEnvironments.removeLast();
                }
            }
            this.recentEnvironments.addFirst(envPath);
        }
    }

    @Override
    public void save() throws IOException {
        if (this.configurationFile != null) {
            File parentDirectory = new File(XmlConfigurationService.DEFAULT_CONFIG_DIRECTORY);
            if (!parentDirectory.isDirectory() || !parentDirectory.exists()) {
                parentDirectory.mkdirs();
            }
            Document document = DocumentHelper.createDocument();
            Element root = document.addElement(ROOT_NODE.replaceAll("/", ""));
            XmlUtility.processXPath(root, EXTENDED_STATE_XPATH, Integer.toString(this.extendedState));
            XmlUtility.processXPath(root, SELECTED_PLUGIN_XPATH, this.selectedPlugin);
            if (this.size != null) {
                XmlUtility.processXPath(root, SIZE_WIDTH_XPATH, Integer.toString((int)this.size.getWidth()));
                XmlUtility.processXPath(root, SIZE_HEIGHT_XPATH, Integer.toString((int)this.size.getHeight()));
            }
            if (this.locationOnScreen != null) {
                XmlUtility.processXPath(root, LOCATION_X_XPATH, Integer.toString((int)this.locationOnScreen.getX()));
                XmlUtility.processXPath(root, LOCATION_Y_XPATH, Integer.toString((int)this.locationOnScreen.getY()));
            }
            if (this.horizontalDividerLocation > 0) {
                XmlUtility.processXPath(root, HORIZONTAL_DIVIDER_LOCATION_XPATH, Integer.toString(this.horizontalDividerLocation));
            }
            if (this.horizontalDividerDimension != null) {
                XmlUtility.processXPath(root, HORIZONTAL_DIVIDER_WIDTH_XPATH, Integer.toString((int)this.horizontalDividerDimension.getWidth()));
                XmlUtility.processXPath(root, HORIZONTAL_DIVIDER_HEIGHT_XPATH, Integer.toString((int)this.horizontalDividerDimension.getHeight()));
            }
            if (this.verticalDividerLocation > 0) {
                XmlUtility.processXPath(root, VERTICAL_DIVIDER_LOCATION_XPATH, Integer.toString(this.verticalDividerLocation));
            }
            if (this.verticalDividerDimension != null) {
                XmlUtility.processXPath(root, VERTICAL_DIVIDER_WIDTH_XPATH, Integer.toString((int)this.verticalDividerDimension.getWidth()));
                XmlUtility.processXPath(root, VERTICAL_DIVIDER_HEIGHT_XPATH, Integer.toString((int)this.verticalDividerDimension.getHeight()));
            }
            Element recentEnvNode = XmlUtility.processXPath(root, RECENT_ENVS_PARENT_XPATH, null);
            String[] recentEnvTokens = StringUtils.splitByWholeSeparator((String)RECENT_ENVS_NODE_XPATH, (String)"/@");
            XmlUtility.addXmlNodesAndAttribute(recentEnvNode, recentEnvTokens[0], recentEnvTokens[1], this.recentEnvironments);
            LOG.debug(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Saving GUI configuration") + "..");
            XmlUtility.writeXmlFile(document, this.configurationFile);
        }
    }
}

