/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.gui.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import org.pdfsam.guiclient.utils.ImageUtility;

public class JPreviewImage
extends JComponent {
    private static final long serialVersionUID = -8027227547898755631L;
    private static final Double ZOOM_STEP = Double.valueOf("0.05");
    private transient Image image;
    private Rectangle bounds;
    private AffineTransform transformation;
    private Double zoomLevel = Double.valueOf("1");
    private Dimension originalDimension;

    public JPreviewImage(Image image) {
        this();
        this.setImage(image);
    }

    public JPreviewImage() {
        this.bounds = new Rectangle();
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.resetComponent();
        if (image != null) {
            this.image = image;
            this.originalDimension = new Dimension(image.getWidth(this), image.getHeight(this));
            this.bounds = new Rectangle(this.originalDimension);
        }
        this.initTransformation();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean resized = width != this.getWidth() || height != this.getHeight();
        super.setBounds(x, y, width, height);
        if (resized) {
            this.initTransformation();
        }
    }

    public void initTransformation() {
        this.transformation = this.getCenteredTransformation();
        this.revalidate();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension retVal = super.getPreferredSize();
        if (this.image != null && !super.isPreferredSizeSet()) {
            retVal = this.bounds.getSize();
        }
        return retVal;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D graphics = (Graphics2D)g;
        graphics.setBackground(this.getBackground());
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            graphics.drawImage(this.image, this.transformation, this);
        }
        g.dispose();
    }

    private AffineTransform getCenteredTransformation() {
        AffineTransform retVal = null;
        if (this.image != null) {
            retVal = new AffineTransform();
            Dimension size = this.getSize();
            int x = -this.bounds.x;
            int y = -this.bounds.y;
            if (this.bounds.height < size.height) {
                y += (size.height - this.bounds.height) / 2;
            }
            if (this.bounds.width < size.width) {
                x += (size.width - this.bounds.width) / 2;
            }
            retVal.scale((double)this.bounds.width / this.originalDimension.getWidth(), (double)this.bounds.height / this.originalDimension.getHeight());
            retVal.translate(x, y);
        }
        return retVal;
    }

    public void resetComponent() {
        this.image = null;
        this.bounds = null;
        this.transformation = null;
        this.zoomLevel = Double.valueOf("1");
        this.originalDimension = null;
    }

    public void zoomIn() {
        this.zoomLevel = this.zoomLevel + ZOOM_STEP;
        this.initRectangle();
    }

    public void zoomOut() {
        this.zoomLevel = this.zoomLevel - ZOOM_STEP;
        this.initRectangle();
    }

    public void zoomNone() {
        this.zoomLevel = Double.valueOf("1");
        this.initRectangle();
    }

    public void zoom(int numberOfSteps) {
        this.zoomLevel = this.zoomLevel + ZOOM_STEP * (double)numberOfSteps;
        this.initRectangle();
    }

    public void rotateClockwise() {
        this.image = ImageUtility.rotateImage(this.image, 90);
        this.originalDimension = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        this.initRectangle();
    }

    public void rotateAntiClockwise() {
        this.image = ImageUtility.rotateImage(this.image, 270);
        this.originalDimension = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        this.initRectangle();
    }

    private void initRectangle() {
        if (this.bounds != null) {
            int width = (int)(this.originalDimension.getWidth() * this.zoomLevel);
            int height = (int)(this.originalDimension.getHeight() * this.zoomLevel);
            this.bounds = new Rectangle(width, height);
            this.initTransformation();
        }
    }
}

