/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance;

import de.intarsys.pdf.app.appearance.AppearanceCreatorRegistry;
import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.app.appearance.NullAppearanceCreator;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.tools.attribute.Attribute;

public class AppearanceCreatorTools {
    private static final Attribute ATTR_APPEARANCECREATOR = new Attribute("appearanceCreator");

    public static void createAppearance(PDAcroFormField pDAcroFormField) {
        IAppearanceCreator iAppearanceCreator = AppearanceCreatorTools.getAppearanceCreator(pDAcroFormField);
        for (PDAnnotation pDAnnotation : pDAcroFormField.getLogicalRoot().getAnnotations()) {
            AppearanceCreatorTools.createAppearance(pDAnnotation, iAppearanceCreator);
        }
    }

    public static PDAppearance createAppearance(PDAnnotation pDAnnotation) {
        IAppearanceCreator iAppearanceCreator = AppearanceCreatorTools.getAppearanceCreator(pDAnnotation);
        return AppearanceCreatorTools.createAppearance(pDAnnotation, iAppearanceCreator);
    }

    public static PDAppearance createAppearance(PDAnnotation pDAnnotation, IAppearanceCreator iAppearanceCreator) {
        Object object;
        if (iAppearanceCreator == null) {
            object = pDAnnotation.cosGetSubtype();
            iAppearanceCreator = AppearanceCreatorRegistry.get().lookupAppearanceCreator((COSName)object);
            if (iAppearanceCreator == null) {
                iAppearanceCreator = new NullAppearanceCreator();
            }
        }
        object = iAppearanceCreator.createAppearance(pDAnnotation, null);
        pDAnnotation.setAppearance((PDAppearance)object);
        return object;
    }

    public static IAppearanceCreator getAppearanceCreator(PDObject pDObject) {
        return (IAppearanceCreator)pDObject.getAttribute(ATTR_APPEARANCECREATOR);
    }

    public static void setAppearanceCreator(PDObject pDObject, IAppearanceCreator iAppearanceCreator) {
        pDObject.setAttribute(ATTR_APPEARANCECREATOR, iAppearanceCreator);
    }
}

