/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.common;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSOperators;

public class CSPrettyPrinter {
    private static final int COL_WIDTH = 50;
    private StringBuilder sb;
    private StringBuilder lb;
    private boolean createComment = false;
    private boolean createLineSeparator = true;
    private boolean createIndent = true;
    private String lineSeparator = System.getProperty("line.separator");
    private int indent = 0;

    public String getValue() {
        return this.sb.toString();
    }

    public void print(CSContent cSContent) {
        this.sb = new StringBuilder();
        this.lb = new StringBuilder();
        int n = cSContent.size();
        int n2 = 0;
        while (n2 < n) {
            CSOperation cSOperation = cSContent.getOperation(n2);
            this.printOperation(cSOperation);
            ++n2;
        }
    }

    protected void printOperation(CSOperation cSOperation) {
        this.lb.setLength(0);
        if (cSOperation.matchesOperator(CSOperators.CSO_Q)) {
            --this.indent;
        }
        if (this.isCreateIndent()) {
            int n = 0;
            while (n < this.indent) {
                this.lb.append("   ");
                ++n;
            }
        }
        String string = cSOperation.toString();
        this.lb.append(string);
        if (this.isCreateComment()) {
            int n = this.lb.length();
            while (n < 50) {
                this.lb.append(" ");
                ++n;
            }
            this.lb.append("% ");
            String string2 = CSOperators.getDescription(cSOperation.getOperator());
            this.lb.append(string2);
        }
        if (this.isCreateLineSeparator() || this.isCreateComment() || this.isCreateIndent()) {
            this.lb.append(this.lineSeparator);
        } else {
            this.lb.append(" ");
        }
        if (cSOperation.matchesOperator(CSOperators.CSO_q)) {
            ++this.indent;
        }
        this.sb.append((CharSequence)this.lb);
    }

    public boolean isCreateComment() {
        return this.createComment;
    }

    public void setCreateComment(boolean bl) {
        this.createComment = bl;
    }

    public boolean isCreateLineSeparator() {
        return this.createLineSeparator;
    }

    public void setCreateLineSeparator(boolean bl) {
        this.createLineSeparator = bl;
    }

    public boolean isCreateIndent() {
        return this.createIndent;
    }

    public void setCreateIndent(boolean bl) {
        this.createIndent = bl;
    }
}

