/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.text;

import java.awt.geom.Rectangle2D;

public class CSTextSearchHit {
    private StringBuilder buffer = new StringBuilder();
    private Rectangle2D rect;
    private String prefix;
    private String suffix;

    public void add(char c, Rectangle2D rectangle2D) {
        this.buffer.append(c);
        if (this.rect == null) {
            this.rect = (Rectangle2D)rectangle2D.clone();
        } else {
            this.rect.add(rectangle2D);
        }
    }

    public String getLabel() {
        return String.valueOf(this.getTrimmedPrefix()) + this.getText() + this.getSuffix() + "...";
    }

    public Rectangle2D getRect() {
        return this.rect;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getText() {
        return this.buffer.toString();
    }

    private String getTrimmedPrefix() {
        int n = this.prefix.length() - 1;
        while (n > 0) {
            char c = this.prefix.charAt(n);
            if (Character.isWhitespace(c) && this.prefix.length() - n >= 5) {
                ++n;
                break;
            }
            --n;
        }
        return this.prefix.substring(n);
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }
}

