/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSCompositeObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.attribute.TaggedAttribute;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class COSBasedObject
implements IAttributeSupport,
ICOSObjectListener {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private final COSObject object;
    private final IAttributeSupport attributeSupport;

    protected COSBasedObject(COSObject cOSObject) {
        this.object = cOSObject;
        if (cOSObject != null) {
            cOSObject.addObjectListener(this);
        }
        this.attributeSupport = cOSObject instanceof IAttributeSupport ? (IAttributeSupport)cOSObject : new AttributeMap();
    }

    @Override
    public void changed(COSObject cOSObject, Object object, Object object2, Object object3) {
        if (object != COSObject.SLOT_CONTAINER) {
            this.invalidateCaches();
        }
    }

    public COSArray cosGetArray() {
        return (COSArray)this.object;
    }

    public COSDictionary cosGetDict() {
        return (COSDictionary)this.object;
    }

    public COSDocument cosGetDoc() {
        return this.object.getDoc();
    }

    public COSObject cosGetField(COSName cOSName) {
        return this.cosGetDict().get(cOSName);
    }

    public COSObject cosGetObject() {
        return this.object;
    }

    public COSStream cosGetStream() {
        return (COSStream)this.object;
    }

    public boolean cosHasField(COSName cOSName) {
        return !this.cosGetDict().get(cOSName).isNull();
    }

    public COSObject cosRemoveField(COSName cOSName) {
        return this.cosGetDict().remove(cOSName);
    }

    public COSObject cosSetField(COSName cOSName, COSObject cOSObject) {
        if (cOSObject == null || cOSObject.isNull()) {
            return this.cosRemoveField(cOSName);
        }
        return this.cosGetDict().put(cOSName, cOSObject);
    }

    public Object getAttribute(Object object) {
        return this.attributeSupport.getAttribute((Object)new TaggedAttribute(object, this.getClass()));
    }

    public boolean getFieldBoolean(COSName cOSName, boolean bl) {
        COSBoolean cOSBoolean = this.cosGetField(cOSName).asBoolean();
        if (cOSBoolean == null) {
            return bl;
        }
        return cOSBoolean.booleanValue();
    }

    public CDSDate getFieldDate(COSName cOSName, CDSDate cDSDate) {
        COSString cOSString = this.cosGetField(cOSName).asString();
        if (cOSString == null) {
            return cDSDate;
        }
        return CDSDate.createFromCOS(cOSString);
    }

    public float getFieldFixed(COSName cOSName, float f) {
        COSNumber cOSNumber = this.cosGetField(cOSName).asNumber();
        if (cOSNumber == null) {
            return f;
        }
        return cOSNumber.floatValue();
    }

    public float[] getFieldFixedArray(COSName cOSName, float[] fArray) {
        COSArray cOSArray = this.cosGetField(cOSName).asArray();
        if (cOSArray != null) {
            float[] fArray2 = new float[cOSArray.size()];
            int n = 0;
            while (n < cOSArray.size()) {
                COSNumber cOSNumber = cOSArray.get(n).asNumber();
                fArray2[n] = cOSNumber != null ? cOSNumber.floatValue() : 0.0f;
                ++n;
            }
            return fArray2;
        }
        return fArray;
    }

    public int getFieldInt(COSName cOSName, int n) {
        COSNumber cOSNumber = this.cosGetField(cOSName).asNumber();
        if (cOSNumber == null) {
            return n;
        }
        return cOSNumber.intValue();
    }

    public String getFieldMLString(COSName cOSName, String string) {
        COSObject cOSObject = this.cosGetField(cOSName);
        if (cOSObject.isNull()) {
            return string;
        }
        COSString cOSString = cOSObject.asString();
        if (cOSString != null) {
            return cOSString.multiLineStringValue();
        }
        return cOSObject.stringValue();
    }

    public String getFieldString(COSName cOSName, String string) {
        COSObject cOSObject = this.cosGetField(cOSName);
        if (cOSObject.isNull()) {
            return string;
        }
        return cOSObject.stringValue();
    }

    protected void initializeFromCos() {
    }

    protected void initializeFromScratch() {
    }

    public void invalidateCaches() {
    }

    public Object removeAttribute(Object object) {
        return this.attributeSupport.removeAttribute((Object)new TaggedAttribute(object, this.getClass()));
    }

    public Object setAttribute(Object object, Object object2) {
        return this.attributeSupport.setAttribute((Object)new TaggedAttribute(object, this.getClass()), object2);
    }

    public COSObject setFieldBoolean(COSName cOSName, boolean bl) {
        COSBoolean cOSBoolean = COSBoolean.create(bl);
        return this.cosSetField(cOSName, cOSBoolean);
    }

    public COSObject setFieldFixed(COSName cOSName, float f) {
        COSFixed cOSFixed = COSFixed.create(f);
        return this.cosSetField(cOSName, cOSFixed);
    }

    protected COSObject setFieldFixedArray(COSName cOSName, float[] fArray) {
        if (fArray == null || fArray.length == 0) {
            return this.cosRemoveField(cOSName);
        }
        COSArray cOSArray = COSArray.create();
        int n = 0;
        while (n < fArray.length) {
            cOSArray.add(COSFixed.create(fArray[n]));
            ++n;
        }
        return this.cosSetField(cOSName, cOSArray);
    }

    public COSObject setFieldInt(COSName cOSName, int n) {
        COSInteger cOSInteger = COSInteger.create(n);
        return this.cosSetField(cOSName, cOSInteger);
    }

    public COSObject setFieldMLString(COSName cOSName, String string) {
        if (string == null) {
            return this.cosRemoveField(cOSName);
        }
        COSString cOSString = COSString.createMultiLine(string);
        return this.cosSetField(cOSName, cOSString);
    }

    public COSObject setFieldName(COSName cOSName, String string) {
        if (string == null) {
            return this.cosRemoveField(cOSName);
        }
        COSName cOSName2 = COSName.create(string.getBytes());
        return this.cosSetField(cOSName, cOSName2);
    }

    public COSObject setFieldObject(COSName cOSName, COSBasedObject cOSBasedObject) {
        if (cOSBasedObject == null) {
            return this.cosRemoveField(cOSName);
        }
        return this.cosSetField(cOSName, cOSBasedObject.cosGetObject());
    }

    public COSObject setFieldString(COSName cOSName, String string) {
        if (string == null) {
            return this.cosRemoveField(cOSName);
        }
        COSString cOSString = COSString.create(string);
        return this.cosSetField(cOSName, cOSString);
    }

    public String toString() {
        return this.cosGetObject().toString();
    }

    public static class MetaClass
    extends de.intarsys.pdf.cos.MetaClass {
        private Constructor constructor;

        protected MetaClass(Class clazz) {
            super(clazz);
        }

        public COSBasedObject createFromCos(COSObject cOSObject) {
            COSBasedObject cOSBasedObject = null;
            if (cOSObject != null && !cOSObject.isNull()) {
                MetaClass metaClass;
                if (cOSObject instanceof COSCompositeObject) {
                    cOSBasedObject = (COSBasedObject)((COSCompositeObject)cOSObject).getAttribute(this.getRootClass());
                }
                if (cOSBasedObject == null && (metaClass = this.doDetermineClass(cOSObject)) != null && (cOSBasedObject = metaClass.doCreateCOSBasedObject(cOSObject)) != null) {
                    cOSBasedObject.initializeFromCos();
                    if (cOSObject instanceof COSCompositeObject) {
                        ((COSCompositeObject)cOSObject).setAttribute(this.getRootClass(), cOSBasedObject);
                    }
                }
            }
            return cOSBasedObject;
        }

        public COSBasedObject createNew() {
            COSObject cOSObject = this.doCreateCOSObject();
            if (this.isIndirect()) {
                cOSObject.beIndirect();
            }
            COSBasedObject cOSBasedObject = this.doCreateCOSBasedObject(cOSObject);
            cOSBasedObject.initializeFromScratch();
            if (cOSObject instanceof COSCompositeObject) {
                ((COSCompositeObject)cOSObject).setAttribute(this.getRootClass(), cOSBasedObject);
            }
            return cOSBasedObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            try {
                MetaClass metaClass = this;
                synchronized (metaClass) {
                    if (this.constructor == null) {
                        this.constructor = this.getInstanceClass().getDeclaredConstructor(COSObject.class);
                        this.constructor.setAccessible(true);
                    }
                }
                COSBasedObject cOSBasedObject = (COSBasedObject)this.constructor.newInstance(cOSObject);
                return cOSBasedObject;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException("Constructor " + this.getInstanceClass().getName() + "(COSObject) missing");
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalStateException(String.valueOf(this.getInstanceClass().getName()) + " can not be instantiated (" + instantiationException.getMessage() + ")");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(String.valueOf(this.getInstanceClass().getName()) + " illegal access (" + illegalAccessException.getMessage() + ")");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalStateException(String.valueOf(this.getInstanceClass().getName()) + " invocation target exception(" + invocationTargetException.getMessage() + ")", invocationTargetException.getCause());
            }
        }

        protected COSObject doCreateCOSObject() {
            return COSDictionary.create();
        }

        protected MetaClass doDetermineClass(COSObject cOSObject) {
            return this;
        }

        protected boolean isIndirect() {
            return true;
        }
    }
}

